/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.runtime;

import org.pkl.core.Composite;
import org.pkl.core.PModule;
import org.pkl.core.PObject;
import org.pkl.core.ast.MemberNode;
import org.pkl.core.ast.expression.unary.ImportNode;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.runtime.VmValueVisitor;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.LateInit;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.graalvm.collections.UnmodifiableEconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.frame.MaterializedFrame;

public final class VmTyped
extends VmObject {
    @CompilerDirectives.CompilationFinal
    @LateInit
    private VmClass clazz;

    public VmTyped(MaterializedFrame enclosingFrame, @Nullable VmTyped parent, @Nullable VmClass clazz, UnmodifiableEconomicMap<Object, ObjectMember> members2) {
        super(enclosingFrame, parent, members2);
        this.clazz = clazz;
    }

    public void lateInitVmClass(VmClass clazz) {
        assert (this.clazz == null) : "VmTyped.clazz has already been initialized.";
        this.clazz = clazz;
    }

    public void addProperty(ObjectMember property) {
        EconomicMaps.put((EconomicMap)this.members, property.getName(), property);
    }

    public void addProperties(UnmodifiableEconomicMap<Object, ObjectMember> properties2) {
        EconomicMaps.putAll((EconomicMap)this.members, properties2);
    }

    @Override
    public VmClass getVmClass() {
        assert (this.clazz != null) : "VmTyped.clazz was not initialized.";
        return this.clazz;
    }

    @Override
    @Nullable
    public VmTyped getParent() {
        return (VmTyped)this.parent;
    }

    @Override
    public boolean isPrototype() {
        return this == this.getPrototype();
    }

    @Override
    public boolean isModuleObject() {
        return this.extraStorage instanceof ModuleInfo;
    }

    public ModuleInfo getModuleInfo() {
        assert (this.isModuleObject());
        return (ModuleInfo)this.getExtraStorage();
    }

    public VmTyped getModuleMirror() {
        assert (this.isModuleObject());
        return this.getModuleInfo().getMirror(this);
    }

    public VmValue getSupermoduleMirror() {
        assert (this.isModuleObject());
        VmTyped parent = this.getParent();
        assert (parent != null);
        return parent == BaseModule.getModuleClass().getPrototype() ? VmNull.withoutDefault() : parent.getModuleMirror();
    }

    public VmMap getImports() {
        assert (this.isModuleObject());
        VmMap.Builder builder = VmMap.builder();
        for (ObjectMember member : this.members.getValues()) {
            if (!member.isImport()) continue;
            MemberNode memberNode = member.getMemberNode();
            assert (memberNode != null);
            builder.add(member.getName().toString(), ((ImportNode)memberNode.getBodyNode()).getImportUri().toString());
        }
        return builder.build();
    }

    public VmMap getClassMirrors() {
        assert (this.isModuleObject());
        if (this.getModuleInfo().isAmend()) {
            return VmMap.EMPTY;
        }
        VmMap.Builder builder = VmMap.builder();
        for (ObjectMember member : this.members.getValues()) {
            if (!member.isClass() || member.isLocal()) continue;
            Identifier className = member.getName();
            VmClass clazz = (VmClass)this.getCachedValue(className);
            if (clazz == null) {
                clazz = (VmClass)VmUtils.doReadMember(this, this, className, member);
            }
            builder.add(className.toString(), clazz.getMirror());
        }
        return builder.build();
    }

    public VmMap getTypeAliasMirrors() {
        assert (this.isModuleObject());
        if (this.getModuleInfo().isAmend()) {
            return VmMap.EMPTY;
        }
        VmMap.Builder builder = VmMap.builder();
        for (ObjectMember member : this.members.getValues()) {
            if (!member.isTypeAlias() || member.isLocal()) continue;
            Identifier typeAliasName = member.getName();
            VmTypeAlias typeAlias = (VmTypeAlias)this.getCachedValue(typeAliasName);
            if (typeAlias == null) {
                typeAlias = (VmTypeAlias)VmUtils.doReadMember(this, this, typeAliasName, member);
            }
            builder.add(typeAliasName.toString(), typeAlias.getMirror());
        }
        return builder.build();
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public Composite export() {
        if (!this.isModuleObject()) {
            return new PObject(this.clazz.getPClassInfo(), this.exportMembers());
        }
        ModuleInfo moduleInfo = this.getModuleInfo();
        return new PModule(moduleInfo.getModuleKey().getUri(), moduleInfo.getModuleName(), this.clazz.getPClassInfo(), this.exportMembers());
    }

    @Override
    public void accept(VmValueVisitor visitor2) {
        visitor2.visitTyped(this);
    }

    @Override
    public <T> T accept(VmValueConverter<T> converter, Iterable<Object> path2) {
        return converter.convertTyped(this, path2);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VmTyped)) {
            return false;
        }
        VmTyped other = (VmTyped)obj;
        if (this.clazz != other.clazz) {
            return false;
        }
        this.force(false);
        other.force(false);
        for (Object t : this.clazz.getAllRegularPropertyNames()) {
            Object value2 = this.getCachedValue(t);
            assert (value2 != null);
            Object otherValue = other.getCachedValue(t);
            if (value2.equals(otherValue)) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public int hashCode() {
        if (this.cachedHash != 0) {
            return this.cachedHash;
        }
        this.force(false);
        int result2 = 0;
        for (Object t : this.clazz.getAllRegularPropertyNames()) {
            Object value2 = this.getCachedValue(t);
            assert (value2 != null);
            result2 = 31 * result2 + value2.hashCode();
        }
        this.cachedHash = result2;
        return result2;
    }
}

