/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTypeAlias;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmValueConverter;
import org.pkl.core.stdlib.PathConverterSupport;
import org.pkl.core.stdlib.PathSpecParser;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.Pair;

public final class PklConverter
implements VmValueConverter<Object> {
    private final Map<VmClass, VmFunction> typeConverters;
    private final Pair<Object[], VmFunction>[] pathConverters;
    @Nullable
    private final VmFunction stringConverter;
    @Nullable
    private final VmFunction booleanConverter;
    @Nullable
    private final VmFunction intConverter;
    @Nullable
    private final VmFunction floatConverter;
    @Nullable
    private final VmFunction durationConverter;
    @Nullable
    private final VmFunction dataSizeConverter;
    @Nullable
    private final VmFunction intSeqConverter;
    @Nullable
    private final VmFunction listConverter;
    @Nullable
    private final VmFunction setConverter;
    @Nullable
    private final VmFunction mapConverter;
    @Nullable
    private final VmFunction listingConverter;
    @Nullable
    private final VmFunction mappingConverter;
    @Nullable
    private final VmFunction dynamicConverter;
    @Nullable
    private final VmFunction pairConverter;
    @Nullable
    private final VmFunction regexConverter;
    @Nullable
    private final VmFunction nullConverter;
    @Nullable
    private final VmFunction classConverter;
    @Nullable
    private final VmFunction typeAliasConverter;

    public PklConverter(VmMapping converters) {
        converters.force(false, false);
        this.typeConverters = this.createTypeConverters(converters);
        this.pathConverters = this.createPathConverters(converters);
        this.stringConverter = this.typeConverters.get(BaseModule.getStringClass());
        this.booleanConverter = this.typeConverters.get(BaseModule.getBooleanClass());
        this.intConverter = this.typeConverters.get(BaseModule.getIntClass());
        this.floatConverter = this.typeConverters.get(BaseModule.getFloatClass());
        this.durationConverter = this.typeConverters.get(BaseModule.getDurationClass());
        this.dataSizeConverter = this.typeConverters.get(BaseModule.getDataSizeClass());
        this.intSeqConverter = this.typeConverters.get(BaseModule.getIntSeqClass());
        this.listConverter = this.typeConverters.get(BaseModule.getListClass());
        this.setConverter = this.typeConverters.get(BaseModule.getSetClass());
        this.mapConverter = this.typeConverters.get(BaseModule.getMapClass());
        this.listingConverter = this.typeConverters.get(BaseModule.getListingClass());
        this.mappingConverter = this.typeConverters.get(BaseModule.getMappingClass());
        this.dynamicConverter = this.typeConverters.get(BaseModule.getDynamicClass());
        this.pairConverter = this.typeConverters.get(BaseModule.getPairClass());
        this.regexConverter = this.typeConverters.get(BaseModule.getRegexClass());
        this.nullConverter = this.typeConverters.get(BaseModule.getNullClass());
        this.classConverter = this.typeConverters.get(BaseModule.getClassClass());
        this.typeAliasConverter = this.typeConverters.get(BaseModule.getTypeAliasClass());
    }

    @Override
    public Object convertString(String value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.stringConverter);
    }

    @Override
    public Object convertBoolean(Boolean value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.booleanConverter);
    }

    @Override
    public Object convertInt(Long value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.intConverter);
    }

    @Override
    public Object convertFloat(Double value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.floatConverter);
    }

    @Override
    public Object convertDuration(VmDuration value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.durationConverter);
    }

    @Override
    public Object convertDataSize(VmDataSize value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.dataSizeConverter);
    }

    @Override
    public Object convertIntSeq(VmIntSeq value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.intSeqConverter);
    }

    @Override
    public Object convertList(VmList value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.listConverter);
    }

    @Override
    public Object convertSet(VmSet value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.setConverter);
    }

    @Override
    public Object convertMap(VmMap value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.mapConverter);
    }

    @Override
    public Object convertListing(VmListing value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.listingConverter);
    }

    @Override
    public Object convertMapping(VmMapping value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.mappingConverter);
    }

    @Override
    public Object convertDynamic(VmDynamic value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.dynamicConverter);
    }

    @Override
    public Object convertTyped(VmTyped value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.findTypeConverter(value2.getVmClass()));
    }

    @Override
    public Object convertPair(VmPair value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.pairConverter);
    }

    @Override
    public Object convertRegex(VmRegex value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.regexConverter);
    }

    @Override
    public Object convertFunction(VmFunction value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.typeConverters.get(value2.getVmClass()));
    }

    @Override
    public Object convertClass(VmClass value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.classConverter);
    }

    @Override
    public Object convertTypeAlias(VmTypeAlias value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.typeAliasConverter);
    }

    @Override
    public Object convertNull(VmNull value2, Iterable<Object> path2) {
        return this.doConvert(value2, path2, this.nullConverter);
    }

    private Map<VmClass, VmFunction> createTypeConverters(VmMapping converters) {
        HashMap<VmClass, VmFunction> result2 = new HashMap<VmClass, VmFunction>();
        converters.iterateMemberValues((key2, member, value2) -> {
            assert (value2 != null);
            if (key2 instanceof VmClass) {
                VmClass vmClass = (VmClass)key2;
                result2.put(vmClass, (VmFunction)value2);
            }
            return true;
        });
        return result2;
    }

    private Pair<Object[], VmFunction>[] createPathConverters(VmMapping converters) {
        ArrayList result2 = new ArrayList();
        PathSpecParser parser = new PathSpecParser();
        converters.iterateMemberValues((key2, member, value2) -> {
            assert (value2 != null);
            if (key2 instanceof String) {
                String string = (String)key2;
                result2.add(Pair.of(parser.parse(string), (VmFunction)value2));
            }
            return true;
        });
        return result2.toArray(new Pair[0]);
    }

    @Nullable
    private VmFunction getPathConverter(Iterable<Object> path2) {
        for (Pair<Object[], VmFunction> converter : this.pathConverters) {
            if (!PathConverterSupport.pathMatches(Arrays.asList((Object[])converter.first), path2)) continue;
            return (VmFunction)converter.second;
        }
        return null;
    }

    @Nullable
    private VmFunction findTypeConverter(VmClass clazz) {
        for (VmClass current2 = clazz; current2 != null; current2 = current2.getSuperclass()) {
            VmFunction found = this.typeConverters.get(current2);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private Object doConvert(Object value2, Iterable<Object> path2, @Nullable VmFunction typeConverter) {
        VmFunction pathConverter = this.getPathConverter(path2);
        if (pathConverter != null) {
            return pathConverter.apply(value2);
        }
        if (typeConverter != null) {
            return typeConverter.apply(value2);
        }
        return value2;
    }
}

