/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import org.pkl.core.ast.PklNode;
import org.pkl.core.ast.expression.binary.LessThanNode;
import org.pkl.core.ast.expression.binary.LessThanNodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction1Node;
import org.pkl.core.ast.lambda.ApplyVmFunction1NodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction2Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2NodeGen;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class CollectionNodes {
    private CollectionNodes() {
    }

    public static final class CompareWithNode
    extends SortComparatorNode {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Override
        public boolean executeWith(Object left, Object right, @Nullable VmFunction comparator) {
            assert (comparator != null);
            Object result2 = this.applyLambdaNode.execute(comparator, left, right);
            if (result2 instanceof Boolean) {
                Boolean b2 = (Boolean)result2;
                return b2;
            }
            if (result2 instanceof Long) {
                Long l = (Long)result2;
                return l < 0L;
            }
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().typeMismatch(result2, BaseModule.getBooleanClass(), BaseModule.getIntClass()).build();
        }
    }

    public static final class CompareByNode
    extends SortComparatorNode {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1NodeGen.create();
        @Node.Child
        private LessThanNode lessThanNode = LessThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Override
        public boolean executeWith(Object left, Object right, @Nullable VmFunction selector) {
            assert (selector != null);
            Object leftResult = this.applyLambdaNode.execute(selector, left);
            Object rightResult = this.applyLambdaNode.execute(selector, right);
            return this.lessThanNode.executeWith(leftResult, rightResult);
        }
    }

    public static final class CompareNode
    extends SortComparatorNode {
        @Node.Child
        private LessThanNode lessThanNode = LessThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Override
        public boolean executeWith(Object left, Object right, @Nullable VmFunction function) {
            assert (function == null);
            return this.lessThanNode.executeWith(left, right);
        }
    }

    public static abstract class SortComparatorNode
    extends PklNode {
        public abstract boolean executeWith(Object var1, Object var2, @Nullable VmFunction var3);
    }
}

