/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import java.util.PrimitiveIterator;
import org.pkl.core.ast.lambda.ApplyVmFunction1Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2NodeGen;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.stdlib.PklName;
import org.pkl.core.util.EconomicMaps;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.LoopNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class IntSeqNodes {
    private IntSeqNodes() {
    }

    private static void reportLoopCount(Node node, long count2) {
        LoopNode.reportLoopCount(node, count2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)count2);
    }

    public static abstract class toListing
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmListing eval(VmIntSeq self) {
            EconomicMap<Object, ObjectMember> result2 = EconomicMaps.create();
            PrimitiveIterator.OfLong iterator2 = self.iterator();
            long idx = 0L;
            while (iterator2.hasNext()) {
                EconomicMaps.put(result2, idx, VmUtils.createSyntheticObjectElement(String.valueOf(idx), iterator2.nextLong()));
                ++idx;
            }
            IntSeqNodes.reportLoopCount(this, self.getLength());
            return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), result2, result2.size());
        }
    }

    public static abstract class toList
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmList eval(VmIntSeq self) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            PrimitiveIterator.OfLong iterator2 = self.iterator();
            while (iterator2.hasNext()) {
                builder.add(iterator2.nextLong());
            }
            IntSeqNodes.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class map
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmIntSeq self, VmFunction function) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            PrimitiveIterator.OfLong iterator2 = self.iterator();
            while (iterator2.hasNext()) {
                builder.add(this.applyLambdaNode.execute(function, iterator2.nextLong()));
            }
            IntSeqNodes.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class fold
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmIntSeq self, Object initial, VmFunction function) {
            Object result2 = initial;
            PrimitiveIterator.OfLong iter = self.iterator();
            while (iter.hasNext()) {
                result2 = this.applyLambdaNode.execute(function, result2, iter.nextLong());
            }
            IntSeqNodes.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    @PklName(value="step")
    public static abstract class stepMethod
    extends ExternalMethod1Node {
        @Specialization
        protected VmIntSeq eval(VmIntSeq self, long step2) {
            return new VmIntSeq(self.start, self.end, step2);
        }
    }

    public static abstract class step
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmIntSeq self) {
            return self.step;
        }
    }

    public static abstract class end
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmIntSeq self) {
            return self.end;
        }
    }

    public static abstract class start
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmIntSeq self) {
            return self.start;
        }
    }
}

