/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmDataSize;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmExceptionBuilder;
import org.pkl.core.runtime.VmIntSeq;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmMapping;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmRegex;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.AbstractRenderer;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.PklConverter;
import org.pkl.core.util.json.JsonEscaper;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;

public final class JsonRendererNodes {
    private JsonRendererNodes() {
    }

    private static JsonRenderer createRenderer(VmTyped self, StringBuilder builder) {
        String indent = (String)VmUtils.readMember(self, Identifier.INDENT);
        boolean omitNullProperties = (Boolean)VmUtils.readMember(self, Identifier.OMIT_NULL_PROPERTIES);
        VmMapping converters = (VmMapping)VmUtils.readMember(self, Identifier.CONVERTERS);
        PklConverter converter = new PklConverter(converters);
        return new JsonRenderer(builder, indent, converter, omitNullProperties);
    }

    private static final class JsonRenderer
    extends AbstractRenderer {
        private final String separator;
        private final JsonEscaper escaper = new JsonEscaper(false);

        JsonRenderer(StringBuilder builder, String indent, PklConverter converter, boolean omitNullProperties) {
            super("JSON", builder, indent, converter, omitNullProperties, omitNullProperties);
            this.separator = indent.isEmpty() ? ":" : ": ";
        }

        @Override
        protected void visitDocument(Object value2) {
            this.visit(value2);
            this.builder.append('\n');
        }

        @Override
        protected void visitTopLevelValue(Object value2) {
            this.visit(value2);
        }

        @Override
        public void visitString(String value2) {
            this.builder.append('\"');
            this.escaper.escape(value2, this.builder);
            this.builder.append('\"');
        }

        @Override
        public void visitInt(Long value2) {
            this.builder.append(value2);
        }

        @Override
        public void visitFloat(Double value2) {
            if (value2.isNaN() || value2.isInfinite()) {
                throw new VmExceptionBuilder().evalError("cannotRenderValue", value2, this.name).build();
            }
            this.builder.append(value2);
        }

        @Override
        public void visitBoolean(Boolean value2) {
            this.builder.append(value2);
        }

        @Override
        public void visitNull(VmNull value2) {
            this.builder.append("null");
        }

        @Override
        public void visitRenderDirective(VmTyped value2) {
            this.builder.append(VmUtils.readTextProperty(value2));
        }

        @Override
        public void visitDuration(VmDuration value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitDataSize(VmDataSize value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitRegex(VmRegex value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitIntSeq(VmIntSeq value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        public void visitPair(VmPair value2) {
            this.cannotRenderTypeAddConverter(value2);
        }

        @Override
        protected void startDynamic(VmDynamic value2) {
            if (value2.hasElements()) {
                this.doBeginArray();
            } else {
                this.doBeginObject();
            }
        }

        @Override
        protected void startTyped(VmTyped value2) {
            this.doBeginObject();
        }

        @Override
        protected void startListing(VmListing value2) {
            this.doBeginArray();
        }

        @Override
        protected void startMapping(VmMapping value2) {
            this.doBeginObject();
        }

        @Override
        protected void startList(VmList value2) {
            this.doBeginArray();
        }

        @Override
        protected void startSet(VmSet value2) {
            this.doBeginArray();
        }

        @Override
        protected void startMap(VmMap value2) {
            this.doBeginObject();
        }

        private void doBeginArray() {
            this.builder.append("[");
            this.increaseIndent();
        }

        private void doBeginObject() {
            this.builder.append("{");
            this.increaseIndent();
        }

        @Override
        protected void visitElement(long index, Object value2, boolean isFirst) {
            if (!isFirst) {
                this.builder.append(',');
            }
            this.startNewLine();
            this.visit(value2);
        }

        @Override
        protected void visitEntryKey(Object key2, boolean isFirst) {
            if (!isFirst) {
                this.builder.append(',');
            }
            this.startNewLine();
            if (key2 instanceof String) {
                String string = (String)key2;
                this.visitString(string);
                this.builder.append(this.separator);
                return;
            }
            if (VmUtils.isRenderDirective(key2)) {
                this.visitRenderDirective((VmTyped)key2);
                this.builder.append(this.separator);
                return;
            }
            this.cannotRenderNonStringKey(key2);
        }

        @Override
        protected void visitEntryValue(Object value2) {
            this.visit(value2);
        }

        @Override
        protected void visitProperty(Identifier name, Object value2, boolean isFirst) {
            if (!isFirst) {
                this.builder.append(',');
            }
            this.startNewLine();
            this.visitString(name.toString());
            this.builder.append(this.separator);
            this.visit(value2);
        }

        @Override
        protected void endDynamic(VmDynamic value2, boolean isEmpty2) {
            if (value2.hasElements()) {
                this.endArray(isEmpty2);
            } else {
                this.endObject(isEmpty2);
            }
        }

        @Override
        protected void endTyped(VmTyped value2, boolean isEmpty2) {
            this.endObject(isEmpty2);
        }

        @Override
        protected void endListing(VmListing value2, boolean isEmpty2) {
            this.endArray(isEmpty2);
        }

        @Override
        protected void endMapping(VmMapping value2, boolean isEmpty2) {
            this.endObject(isEmpty2);
        }

        @Override
        protected void endList(VmList value2) {
            this.endArray(value2.isEmpty());
        }

        @Override
        protected void endSet(VmSet value2) {
            this.endArray(value2.isEmpty());
        }

        @Override
        protected void endMap(VmMap value2) {
            this.endObject(value2.isEmpty());
        }

        private void endArray(boolean isEmpty2) {
            this.decreaseIndent();
            if (!isEmpty2) {
                this.startNewLine();
            }
            this.builder.append(']');
        }

        private void endObject(boolean isEmpty2) {
            this.decreaseIndent();
            if (!isEmpty2) {
                this.startNewLine();
            }
            this.builder.append('}');
        }

        private void startNewLine() {
            if (this.indent.isEmpty()) {
                return;
            }
            this.builder.append('\n');
            this.builder.append((CharSequence)this.currIndent);
        }
    }

    public static abstract class renderValue
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            JsonRendererNodes.createRenderer(self, builder).renderValue(value2);
            return builder.toString();
        }
    }

    public static abstract class renderDocument
    extends ExternalMethod1Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected String eval(VmTyped self, Object value2) {
            StringBuilder builder = new StringBuilder();
            JsonRendererNodes.createRenderer(self, builder).renderDocument(value2);
            return builder.toString();
        }
    }
}

