/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import java.util.Iterator;
import org.pkl.core.ast.expression.binary.GreaterThanNode;
import org.pkl.core.ast.expression.binary.GreaterThanNodeGen;
import org.pkl.core.ast.expression.binary.LessThanNode;
import org.pkl.core.ast.expression.binary.LessThanNodeGen;
import org.pkl.core.ast.internal.IsInstanceOfNode;
import org.pkl.core.ast.internal.IsInstanceOfNodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction1Node;
import org.pkl.core.ast.lambda.ApplyVmFunction1NodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction2Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2NodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction3Node;
import org.pkl.core.ast.lambda.ApplyVmFunction3NodeGen;
import org.pkl.core.runtime.VmClass;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDynamic;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmMap;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmPair;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalMethod3Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.stdlib.base.CollectionNodes;
import org.pkl.core.stdlib.base.MergeSort;
import org.pkl.core.util.EconomicSets;
import org.pkl.thirdparty.graalvm.collections.EconomicSet;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.LoopNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class ListNodes {
    private ListNodes() {
    }

    public static abstract class toDynamic
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmDynamic eval(VmList self) {
            return self.toDynamic();
        }
    }

    public static abstract class toListing
    extends ExternalMethod0Node {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected VmListing eval(VmList self) {
            return self.toListing();
        }
    }

    public static abstract class toMap
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction1Node applyKeyExtractorNode = ApplyVmFunction1Node.create();
        @Node.Child
        private ApplyVmFunction1Node applyValueExtractorNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmMap eval(VmList self, VmFunction keyExtractor, VmFunction valueExtractor) {
            VmMap.Builder builder = VmMap.builder();
            for (Object elem : self) {
                Object key2 = this.applyKeyExtractorNode.execute(keyExtractor, elem);
                Object value2 = this.applyValueExtractorNode.execute(valueExtractor, elem);
                builder.add(key2, value2);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class toSet
    extends ExternalMethod0Node {
        @Specialization
        protected VmSet eval(VmList self) {
            return self.toSet();
        }
    }

    public static abstract class toList
    extends ExternalMethod0Node {
        @Specialization
        protected VmList eval(VmList self) {
            return self;
        }
    }

    public static abstract class zip
    extends ExternalMethod1Node {
        @Specialization
        protected VmCollection eval(VmList self, VmCollection coll) {
            return self.zip(coll);
        }
    }

    public static abstract class join
    extends ExternalMethod1Node {
        @Specialization
        protected String eval(VmList self, String separator) {
            return self.join(separator);
        }
    }

    public static abstract class reverse
    extends ExternalMethod0Node {
        @Specialization
        protected VmList eval(VmList self) {
            return self.reverse();
        }
    }

    public static abstract class count
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected long eval(VmList self, VmFunction function) {
            long count2 = 0L;
            for (Object elem : self) {
                if (!this.applyLambdaNode.executeBoolean(function, elem)) continue;
                ++count2;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return count2;
        }
    }

    public static abstract class repeat
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VmList self, long n) {
            return self.repeat(n);
        }
    }

    public static abstract class replaceRangeOrNull
    extends ExternalMethod3Node {
        @Specialization
        protected Object eval(VmList self, long start2, long exclusiveEnd, VmCollection replacement) {
            return self.replaceRangeOrNull(start2, exclusiveEnd, replacement);
        }
    }

    public static abstract class replaceRange
    extends ExternalMethod3Node {
        @Specialization
        protected VmList eval(VmList self, long start2, long exclusiveEnd, VmCollection replacement) {
            int length2 = self.getLength();
            if (start2 < 0L || start2 > (long)length2) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("elementIndexOutOfRange", start2, 0, length2).withProgramValue("Collection", self).build();
            }
            if (exclusiveEnd < start2 || exclusiveEnd > (long)length2) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("elementIndexOutOfRange", exclusiveEnd, start2, length2).withProgramValue("Collection", self).build();
            }
            return self.replaceRange(start2, exclusiveEnd, replacement);
        }
    }

    public static abstract class replace
    extends ExternalMethod2Node {
        @Specialization
        protected VmList eval(VmList self, long index, Object replacement) {
            if (index < 0L || index >= (long)self.getLength()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("elementIndexOutOfRange", index, 0, self.getLength() - 1).withProgramValue("Collection", self).build();
            }
            return self.replace(index, replacement);
        }
    }

    public static abstract class replaceOrNull
    extends ExternalMethod2Node {
        @Specialization
        protected Object eval(VmList self, long index, Object replacement) {
            return self.replaceOrNull(index, replacement);
        }
    }

    public static abstract class add
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VmList self, Object element) {
            return self.add(element);
        }
    }

    public static abstract class sortWith
    extends ExternalMethod1Node {
        @Node.Child
        private CollectionNodes.CompareWithNode compareWithNode = new CollectionNodes.CompareWithNode();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            return VmList.create(MergeSort.sort(self.toArray(), this.compareWithNode, function));
        }
    }

    public static abstract class sortBy
    extends ExternalMethod1Node {
        @Node.Child
        private CollectionNodes.CompareByNode compareByNode = new CollectionNodes.CompareByNode();

        @Specialization
        protected VmList eval(VmList self, VmFunction selector) {
            return VmList.create(MergeSort.sort(self.toArray(), this.compareByNode, selector));
        }
    }

    public static abstract class sort
    extends ExternalMethod0Node {
        @Node.Child
        private CollectionNodes.CompareNode compareNode = new CollectionNodes.CompareNode();

        @Specialization
        protected VmList eval(VmList self) {
            return VmList.create(MergeSort.sort(self.toArray(), this.compareNode, null));
        }
    }

    public static abstract class maxWithOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            if (self.isEmpty()) {
                return VmNull.withoutDefault();
            }
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                boolean cmpResult = this.applyLambdaNode.executeBoolean(function, result2, elem);
                if (!cmpResult) continue;
                result2 = elem;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class minWithOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            if (self.isEmpty()) {
                return VmNull.withoutDefault();
            }
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                boolean cmpResult = this.applyLambdaNode.executeBoolean(function, elem, result2);
                if (!cmpResult) continue;
                result2 = elem;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class maxWith
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            self.checkNonEmpty();
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                boolean cmpResult = this.applyLambdaNode.executeBoolean(function, result2, elem);
                if (!cmpResult) continue;
                result2 = elem;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class minWith
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            self.checkNonEmpty();
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                boolean cmpResult = this.applyLambdaNode.executeBoolean(function, elem, result2);
                if (!cmpResult) continue;
                result2 = elem;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class maxByOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1NodeGen.create();
        @Node.Child
        private GreaterThanNode greaterThanNode = GreaterThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            if (self.isEmpty()) {
                return VmNull.withoutDefault();
            }
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            Object resultValue = this.applyLambdaNode.execute(function, result2);
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                Object elemValue = this.applyLambdaNode.execute(function, elem);
                if (!this.greaterThanNode.executeWith(elemValue, resultValue)) continue;
                result2 = elem;
                resultValue = elemValue;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class minByOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1NodeGen.create();
        @Node.Child
        private LessThanNode lessThanNode = LessThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            if (self.isEmpty()) {
                return VmNull.withoutDefault();
            }
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            Object resultValue = this.applyLambdaNode.execute(function, result2);
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                Object elemValue = this.applyLambdaNode.execute(function, elem);
                if (!this.lessThanNode.executeWith(elemValue, resultValue)) continue;
                result2 = elem;
                resultValue = elemValue;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class maxBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1NodeGen.create();
        @Node.Child
        private GreaterThanNode greaterThanNode = GreaterThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            self.checkNonEmpty();
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            Object resultValue = this.applyLambdaNode.execute(function, result2);
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                Object elemValue = this.applyLambdaNode.execute(function, elem);
                if (!this.greaterThanNode.executeWith(elemValue, resultValue)) continue;
                result2 = elem;
                resultValue = elemValue;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class minBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1NodeGen.create();
        @Node.Child
        private LessThanNode lessThanNode = LessThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            self.checkNonEmpty();
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            Object resultValue = this.applyLambdaNode.execute(function, result2);
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                Object elemValue = this.applyLambdaNode.execute(function, elem);
                if (!this.lessThanNode.executeWith(elemValue, resultValue)) continue;
                result2 = elem;
                resultValue = elemValue;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class maxOrNull
    extends ExternalPropertyNode {
        @Node.Child
        private GreaterThanNode greaterThanNode = GreaterThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Specialization
        protected Object eval(VmList self) {
            if (self.isEmpty()) {
                return VmNull.withoutDefault();
            }
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                if (!this.greaterThanNode.executeWith(elem, result2)) continue;
                result2 = elem;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class max
    extends ExternalPropertyNode {
        @Node.Child
        private GreaterThanNode greaterThanNode = GreaterThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Specialization
        protected Object eval(VmList self) {
            self.checkNonEmpty();
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                if (!this.greaterThanNode.executeWith(elem, result2)) continue;
                result2 = elem;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class minOrNull
    extends ExternalPropertyNode {
        @Node.Child
        private LessThanNode lessThanNode = LessThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Specialization
        protected Object eval(VmList self) {
            if (self.isEmpty()) {
                return VmNull.withoutDefault();
            }
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                if (!this.lessThanNode.executeWith(elem, result2)) continue;
                result2 = elem;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class min
    extends ExternalPropertyNode {
        @Node.Child
        private LessThanNode lessThanNode = LessThanNodeGen.create(VmUtils.unavailableSourceSection(), null, null);

        @Specialization
        protected Object eval(VmList self) {
            self.checkNonEmpty();
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                if (!this.lessThanNode.executeWith(elem, result2)) continue;
                result2 = elem;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class groupBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1NodeGen.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            VmMap.Builder builder = VmMap.builder();
            for (Object elem : self) {
                Object key2 = this.applyLambdaNode.execute(function, elem);
                Object value2 = builder.get(key2);
                VmList newValue = value2 == null ? VmList.of(elem) : ((VmList)value2).add(elem);
                builder.add(key2, newValue);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class reduceOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            if (self.isEmpty()) {
                return VmNull.withoutDefault();
            }
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                result2 = this.applyLambdaNode.execute(function, result2, elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class reduce
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            self.checkNonEmpty();
            Iterator<Object> iterator2 = self.iterator();
            Object result2 = iterator2.next();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                result2 = this.applyLambdaNode.execute(function, result2, elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class foldIndexed
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction3Node applyLambdaNode = ApplyVmFunction3NodeGen.create();

        @Specialization
        protected Object eval(VmList self, Object initial, VmFunction function) {
            Iterator<Object> iter = self.iterator();
            Object result2 = initial;
            long index = 0L;
            while (iter.hasNext()) {
                Object elem = iter.next();
                result2 = this.applyLambdaNode.execute(function, index++, result2, elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class foldBack
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmList self, Object initial, VmFunction function) {
            Iterator<Object> iter = self.reverseIterator();
            Object result2 = initial;
            while (iter.hasNext()) {
                Object elem = iter.next();
                result2 = this.applyLambdaNode.execute(function, elem, result2);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class fold
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmList self, Object initial, VmFunction function) {
            Iterator<Object> iter = self.iterator();
            Object result2 = initial;
            while (iter.hasNext()) {
                Object elem = iter.next();
                result2 = this.applyLambdaNode.execute(function, result2, elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return result2;
        }
    }

    public static abstract class dropLastWhile
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            int idx = self.getLength();
            Iterator<Object> iter = self.reverseIterator();
            while (iter.hasNext() && this.applyLambdaNode.executeBoolean(function, iter.next())) {
                --idx;
            }
            return self.take(idx);
        }
    }

    public static abstract class dropLast
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VmList self, long n) {
            return self.dropLast(n);
        }
    }

    public static abstract class dropWhile
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            int idx = 0;
            for (Object elem : self) {
                if (!this.applyLambdaNode.executeBoolean(function, elem)) break;
                ++idx;
            }
            return self.drop(idx);
        }
    }

    public static abstract class drop
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VmList self, long n) {
            return self.drop(n);
        }
    }

    public static abstract class takeLastWhile
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            int idx = self.getLength();
            Iterator<Object> iter = self.reverseIterator();
            while (iter.hasNext() && this.applyLambdaNode.executeBoolean(function, iter.next())) {
                --idx;
            }
            return self.drop(idx);
        }
    }

    public static abstract class takeLast
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VmList self, long n) {
            return self.takeLast(n);
        }
    }

    public static abstract class takeWhile
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            for (Object elem : self) {
                if (!this.applyLambdaNode.executeBoolean(function, elem)) {
                    return builder.build();
                }
                builder.add(elem);
            }
            return self;
        }
    }

    public static abstract class take
    extends ExternalMethod1Node {
        @Specialization
        protected VmList eval(VmList self, long n) {
            return self.take(n);
        }
    }

    public static abstract class flatten
    extends ExternalMethod0Node {
        @Specialization
        protected VmList eval(VmList self) {
            return (VmList)self.flatten();
        }
    }

    public static abstract class flatMapIndexed
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            long index = 0L;
            for (Object elem : self) {
                builder.addAll(this.applyLambdaNode.executeCollection(function, index++, elem));
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class flatMap
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            for (Object elem : self) {
                builder.addAll(this.applyLambdaNode.executeCollection(function, elem));
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class mapIndexed
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            long index = 0L;
            for (Object elem : self) {
                builder.add(this.applyLambdaNode.execute(function, index++, elem));
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class mapNonNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            for (Object elem : self) {
                Object newValue = this.applyLambdaNode.execute(function, elem);
                if (newValue instanceof VmNull) continue;
                builder.add(newValue);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class map
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            for (Object elem : self) {
                builder.add(this.applyLambdaNode.execute(function, elem));
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class distinctBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            EconomicSet visited = EconomicSets.create();
            for (Object elem : self) {
                if (!EconomicSets.add(visited, this.applyLambdaNode.execute(function, elem))) continue;
                builder.add(elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class distinct
    extends ExternalPropertyNode {
        @Specialization
        protected VmList eval(VmList self) {
            VmCollection.Builder<VmList> builder = self.builder();
            EconomicSet visited = EconomicSets.create();
            for (Object elem : self) {
                if (!EconomicSets.add(visited, elem)) continue;
                builder.add(elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class isDistinctBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected boolean eval(VmList self, VmFunction function) {
            EconomicSet visited = EconomicSets.create();
            for (Object elem : self) {
                if (EconomicSets.add(visited, this.applyLambdaNode.execute(function, elem))) continue;
                return false;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return true;
        }
    }

    public static abstract class isDistinct
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmList self) {
            EconomicSet visited = EconomicSets.create();
            for (Object elem : self) {
                if (EconomicSets.add(visited, elem)) continue;
                return false;
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return true;
        }
    }

    public static abstract class filterIsInstance
    extends ExternalMethod1Node {
        @Node.Child
        private IsInstanceOfNode isInstanceOfNode = IsInstanceOfNodeGen.create();

        @Specialization
        protected VmList eval(VmList self, VmClass clazz) {
            VmCollection.Builder<VmList> builder = self.builder();
            for (Object elem : self) {
                if (!this.isInstanceOfNode.executeBoolean(elem, clazz)) continue;
                builder.add(elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class filterIndexed
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            long index = 0L;
            for (Object elem : self) {
                if (!this.applyLambdaNode.executeBoolean(function, index++, elem)) continue;
                builder.add(elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class filterNonNull
    extends ExternalMethod0Node {
        @Specialization
        protected VmList eval(VmList self) {
            VmCollection.Builder<VmList> builder = self.builder();
            for (Object elem : self) {
                if (elem instanceof VmNull) continue;
                builder.add(elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class filter
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmList eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder = self.builder();
            for (Object elem : self) {
                if (!this.applyLambdaNode.executeBoolean(function, elem)) continue;
                builder.add(elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.build();
        }
    }

    public static abstract class any
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected boolean eval(VmList self, VmFunction function) {
            for (Object elem : self) {
                if (!this.applyLambdaNode.executeBoolean(function, elem)) continue;
                return true;
            }
            return false;
        }
    }

    public static abstract class every
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected boolean eval(VmList self, VmFunction function) {
            for (Object elem : self) {
                if (this.applyLambdaNode.executeBoolean(function, elem)) continue;
                return false;
            }
            return true;
        }
    }

    public static abstract class findLastIndexOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            int idx = self.getLength();
            Iterator<Object> iter = self.reverseIterator();
            while (iter.hasNext()) {
                --idx;
                if (!this.applyLambdaNode.executeBoolean(function, iter.next())) continue;
                return (long)idx;
            }
            return VmNull.withoutDefault();
        }
    }

    public static abstract class findLastIndex
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected long eval(VmList self, VmFunction function) {
            int idx = self.getLength();
            Iterator<Object> iter = self.reverseIterator();
            while (iter.hasNext()) {
                --idx;
                if (!this.applyLambdaNode.executeBoolean(function, iter.next())) continue;
                return idx;
            }
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("cannotFindMatchingCollectionElement", new Object[0]).withProgramValue("Collection", self).build();
        }
    }

    public static abstract class findIndexOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            long idx = 0L;
            for (Object elem : self) {
                if (this.applyLambdaNode.executeBoolean(function, elem)) {
                    return idx;
                }
                ++idx;
            }
            return VmNull.withoutDefault();
        }
    }

    public static abstract class findIndex
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected long eval(VmList self, VmFunction function) {
            long idx = 0L;
            for (Object elem : self) {
                if (this.applyLambdaNode.executeBoolean(function, elem)) {
                    return idx;
                }
                ++idx;
            }
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("cannotFindMatchingCollectionElement", new Object[0]).withProgramValue("Collection", self).build();
        }
    }

    public static abstract class lastIndexOfOrNull
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmList self, Object elem) {
            return self.lastIndexOfOrNull(elem);
        }
    }

    public static abstract class lastIndexOf
    extends ExternalMethod1Node {
        @Specialization
        protected long eval(VmList self, Object elem) {
            long result2 = self.lastIndexOf(elem);
            if (result2 == -1L) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("cannotFindCollectionElement", new Object[0]).withProgramValue("Element", elem).withProgramValue("Collection", self).build();
            }
            return result2;
        }
    }

    public static abstract class indexOfOrNull
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmList self, Object elem) {
            return self.indexOfOrNull(elem);
        }
    }

    public static abstract class indexOf
    extends ExternalMethod1Node {
        @Specialization
        protected long eval(VmList self, Object elem) {
            long result2 = self.indexOf(elem);
            if (result2 == -1L) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("cannotFindCollectionElement", new Object[0]).withProgramValue("Element", elem).withProgramValue("Collection", self).build();
            }
            return result2;
        }
    }

    public static abstract class findLastOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            Iterator<Object> iterator2 = self.reverseIterator();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                if (!this.applyLambdaNode.executeBoolean(function, elem)) continue;
                return elem;
            }
            return VmNull.withoutDefault();
        }
    }

    public static abstract class findLast
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            Iterator<Object> iterator2 = self.reverseIterator();
            while (iterator2.hasNext()) {
                Object elem = iterator2.next();
                if (!this.applyLambdaNode.executeBoolean(function, elem)) continue;
                return elem;
            }
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("cannotFindMatchingCollectionElement", new Object[0]).withProgramValue("Collection", self).build();
        }
    }

    public static abstract class findOrNull
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            for (Object elem : self) {
                if (!this.applyLambdaNode.executeBoolean(function, elem)) continue;
                return elem;
            }
            return VmNull.withoutDefault();
        }
    }

    public static abstract class find
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected Object eval(VmList self, VmFunction function) {
            for (Object elem : self) {
                if (!this.applyLambdaNode.executeBoolean(function, elem)) continue;
                return elem;
            }
            CompilerDirectives.transferToInterpreter();
            throw this.exceptionBuilder().evalError("cannotFindMatchingCollectionElement", new Object[0]).withProgramValue("Collection", self).build();
        }
    }

    public static abstract class contains
    extends ExternalMethod1Node {
        @Specialization
        protected boolean eval(VmList self, Object element) {
            return self.contains(element);
        }
    }

    public static abstract class partition
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyLambdaNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmPair eval(VmList self, VmFunction function) {
            VmCollection.Builder<VmList> builder1 = self.builder();
            VmCollection.Builder<VmList> builder2 = self.builder();
            for (Object elem : self) {
                if (this.applyLambdaNode.executeBoolean(function, elem)) {
                    builder1.add(elem);
                    continue;
                }
                builder2.add(elem);
            }
            LoopNode.reportLoopCount(this, self.getLength());
            return new VmPair(builder1.build(), builder2.build());
        }
    }

    public static abstract class splitOrNull
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmList self, long index) {
            return self.splitOrNull(index);
        }
    }

    public static abstract class split
    extends ExternalMethod1Node {
        @Specialization
        protected VmPair eval(VmList self, long index) {
            if (index < 0L || index > (long)self.getLength()) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("elementIndexOutOfRange", index, 0, self.getLength()).withProgramValue("Collection", self).build();
            }
            return self.split(index);
        }
    }

    public static abstract class endsWith
    extends ExternalMethod1Node {
        @Specialization
        protected boolean eval(VmList self, VmCollection other) {
            return self.endsWith(other);
        }
    }

    public static abstract class startsWith
    extends ExternalMethod1Node {
        @Specialization
        protected boolean eval(VmList self, VmCollection other) {
            return self.startsWith(other);
        }
    }

    public static abstract class singleOrNull
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmList self) {
            return self.getSingleOrNull();
        }
    }

    public static abstract class single
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmList self) {
            return self.getSingle();
        }
    }

    public static abstract class lastOrNull
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmList self) {
            return self.getLastOrNull();
        }
    }

    public static abstract class last
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmList self) {
            return self.getLast();
        }
    }

    public static abstract class restOrNull
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmList self) {
            return self.getRestOrNull();
        }
    }

    public static abstract class rest
    extends ExternalPropertyNode {
        @Specialization
        protected VmList eval(VmList self) {
            return self.getRest();
        }
    }

    public static abstract class firstOrNull
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmList self) {
            return self.getFirstOrNull();
        }
    }

    public static abstract class first
    extends ExternalPropertyNode {
        @Specialization
        protected Object eval(VmList self) {
            return self.getFirst();
        }
    }

    public static abstract class sublistOrNull
    extends ExternalMethod2Node {
        @Specialization
        protected Object eval(VmList self, long start2, long exclusiveEnd) {
            return self.subListOrNull(start2, exclusiveEnd);
        }
    }

    public static abstract class sublist
    extends ExternalMethod2Node {
        @Specialization
        protected Object eval(VmList self, long start2, long exclusiveEnd) {
            int length2 = self.getLength();
            if (start2 < 0L || start2 > (long)length2) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("elementIndexOutOfRange", start2, 0, length2).withProgramValue("Collection", self).build();
            }
            if (exclusiveEnd < start2 || exclusiveEnd > (long)length2) {
                CompilerDirectives.transferToInterpreter();
                throw this.exceptionBuilder().evalError("elementIndexOutOfRange", exclusiveEnd, start2, length2).withProgramValue("Collection", self).build();
            }
            return self.subList(start2, exclusiveEnd);
        }
    }

    public static abstract class getOrNull
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmList self, long index) {
            return self.getOrNull(index);
        }
    }

    public static abstract class lastIndex
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmList self) {
            return self.getLastIndex();
        }
    }

    public static abstract class isEmpty
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmList self) {
            return self.isEmpty();
        }
    }

    public static abstract class length
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmList self) {
            return self.getLength();
        }
    }
}

