/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import java.util.HashSet;
import org.pkl.core.ast.lambda.ApplyVmFunction1Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2Node;
import org.pkl.core.ast.lambda.ApplyVmFunction2NodeGen;
import org.pkl.core.ast.lambda.ApplyVmFunction3Node;
import org.pkl.core.ast.lambda.ApplyVmFunction3NodeGen;
import org.pkl.core.ast.member.ObjectMember;
import org.pkl.core.runtime.BaseModule;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmFunction;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmListing;
import org.pkl.core.runtime.VmObject;
import org.pkl.core.runtime.VmSet;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.ExternalMethod1Node;
import org.pkl.core.stdlib.ExternalMethod2Node;
import org.pkl.core.stdlib.ExternalPropertyNode;
import org.pkl.core.util.CollectionUtils;
import org.pkl.core.util.EconomicMaps;
import org.pkl.core.util.MutableLong;
import org.pkl.core.util.MutableReference;
import org.pkl.thirdparty.graalvm.collections.EconomicMap;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;
import org.pkl.thirdparty.truffle.api.nodes.LoopNode;
import org.pkl.thirdparty.truffle.api.nodes.Node;

public final class ListingNodes {
    private ListingNodes() {
    }

    public static abstract class toSet
    extends ExternalMethod0Node {
        @Specialization
        protected VmSet eval(VmListing self) {
            VmCollection.Builder<VmSet> builder = VmSet.EMPTY.builder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                builder.add(value2);
                return true;
            });
            return builder.build();
        }
    }

    public static abstract class toList
    extends ExternalMethod0Node {
        @Specialization
        protected VmList eval(VmListing self) {
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                builder.add(value2);
                return true;
            });
            return builder.build();
        }
    }

    public static abstract class join
    extends ExternalMethod1Node {
        @Specialization
        protected Object eval(VmListing self, String separator) {
            if (self.isEmpty()) {
                return "";
            }
            StringBuilder builder = new StringBuilder();
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                if (!key2.equals(0L)) {
                    builder.append(separator);
                }
                builder.append(value2);
                return true;
            });
            LoopNode.reportLoopCount(this, self.getLength());
            return builder.toString();
        }
    }

    public static abstract class foldIndexed
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction3Node applyLambdaNode = ApplyVmFunction3NodeGen.create();

        @Specialization
        protected Object eval(VmListing self, Object initial, VmFunction function) {
            MutableLong index = new MutableLong(0L);
            MutableReference<Object> result2 = new MutableReference<Object>(initial);
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                result2.set(this.applyLambdaNode.execute(function, index.getAndIncrement(), result2.get(), value2));
                return true;
            });
            LoopNode.reportLoopCount(this, self.getLength());
            return result2.get();
        }
    }

    public static abstract class fold
    extends ExternalMethod2Node {
        @Node.Child
        private ApplyVmFunction2Node applyLambdaNode = ApplyVmFunction2NodeGen.create();

        @Specialization
        protected Object eval(VmListing self, Object initial, VmFunction function) {
            MutableReference<Object> result2 = new MutableReference<Object>(initial);
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                result2.set(this.applyLambdaNode.execute(function, result2.get(), value2));
                return true;
            });
            LoopNode.reportLoopCount(this, self.getLength());
            return result2.get();
        }
    }

    public static abstract class distinctBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyNode = ApplyVmFunction1Node.create();

        @Specialization
        protected VmListing eval(VmListing self, VmFunction selector) {
            HashSet visitedValues = CollectionUtils.newHashSet();
            EconomicMap<Object, ObjectMember> newMembers = EconomicMaps.create();
            MutableLong index = new MutableLong(0L);
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                if (visitedValues.add(this.applyNode.execute(selector, value2))) {
                    newMembers.put(index.getAndIncrement(), VmUtils.createSyntheticObjectElement(member.getQualifiedName(), value2));
                }
                return true;
            });
            return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), newMembers, newMembers.size());
        }
    }

    public static abstract class distinct
    extends ExternalPropertyNode {
        @Specialization
        protected VmListing eval(VmListing self) {
            HashSet visitedValues = CollectionUtils.newHashSet();
            EconomicMap<Object, ObjectMember> newMembers = EconomicMaps.create();
            MutableLong index = new MutableLong(0L);
            self.forceAndIterateMemberValues((key2, member, value2) -> {
                if (visitedValues.add(value2)) {
                    newMembers.put(index.getAndIncrement(), VmUtils.createSyntheticObjectElement(member.getQualifiedName(), value2));
                }
                return true;
            });
            return new VmListing(VmUtils.createEmptyMaterializedFrame(), (VmObject)BaseModule.getListingClass().getPrototype(), newMembers, newMembers.size());
        }
    }

    public static abstract class isDistinctBy
    extends ExternalMethod1Node {
        @Node.Child
        private ApplyVmFunction1Node applyNode = ApplyVmFunction1Node.create();

        @Specialization
        protected boolean eval(VmListing self, VmFunction selector) {
            HashSet visitedValues = CollectionUtils.newHashSet();
            return self.forceAndIterateMemberValues((key2, member, value2) -> visitedValues.add(this.applyNode.execute(selector, value2)));
        }
    }

    public static abstract class isDistinct
    extends ExternalPropertyNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected boolean eval(VmListing self) {
            HashSet visitedValues = CollectionUtils.newHashSet();
            return self.forceAndIterateMemberValues((key2, member, value2) -> visitedValues.add(value2));
        }
    }

    public static abstract class isEmpty
    extends ExternalPropertyNode {
        @Specialization
        protected boolean eval(VmListing self) {
            return self.isEmpty();
        }
    }

    public static abstract class length
    extends ExternalPropertyNode {
        @Specialization
        protected long eval(VmListing self) {
            return self.getLength();
        }
    }
}

