/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.base;

import org.pkl.core.runtime.VmFunction;
import org.pkl.core.stdlib.base.CollectionNodes;
import org.pkl.core.util.Nullable;

final class MergeSort {
    private static final int INITIAL_MERGE_SORT_STRIDE = 8;

    private MergeSort() {
    }

    public static Object[] sort(Object[] array, CollectionNodes.SortComparatorNode comparator, @Nullable VmFunction function) {
        int length2 = array.length;
        Object[] temp = new Object[length2];
        for (int start2 = 0; start2 < length2; start2 += 8) {
            int end2 = Math.min(start2 + 8, length2);
            MergeSort.insertionSort(array, start2, end2, comparator, function);
        }
        for (int stride = 8; stride < length2; stride *= 2) {
            for (int start3 = 0; start3 < length2 - stride; start3 += stride + stride) {
                int end3 = Math.min(start3 + stride + stride, length2);
                int mid = start3 + stride;
                MergeSort.merge(array, temp, start3, mid, end3, comparator, function);
            }
        }
        return array;
    }

    private static void merge(Object[] array, Object[] temp, int start2, int mid, int end2, CollectionNodes.SortComparatorNode comparator, @Nullable VmFunction function) {
        if (comparator.executeWith(array[mid - 1], array[mid], function)) {
            return;
        }
        System.arraycopy(array, start2, temp, start2, end2 - start2);
        int i2 = start2;
        int j = mid;
        for (int k = start2; k < end2; ++k) {
            array[k] = i2 >= mid ? temp[j++] : (j >= end2 ? temp[i2++] : (comparator.executeWith(temp[j], temp[i2], function) ? temp[j++] : temp[i2++]));
        }
    }

    private static void insertionSort(Object[] array, int start2, int end2, CollectionNodes.SortComparatorNode comparator, @Nullable VmFunction function) {
        for (int i2 = start2; i2 < end2; ++i2) {
            for (int j = i2; j > start2 && comparator.executeWith(array[j], array[j - 1], function); --j) {
                Object swap = array[j];
                array[j] = array[j - 1];
                array[j - 1] = swap;
            }
        }
    }
}

