/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.benchmark;

import java.util.function.LongFunction;
import org.pkl.core.DurationUnit;
import org.pkl.core.runtime.BenchmarkModule;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.VmCollection;
import org.pkl.core.runtime.VmDuration;
import org.pkl.core.runtime.VmList;
import org.pkl.core.runtime.VmNull;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.runtime.VmValue;
import org.pkl.core.stdlib.VmObjectFactory;
import org.pkl.core.util.Nullable;

final class BenchmarkUtils {
    private static final VmObjectFactory<BenchmarkResult> benchmarkResultFactory = new VmObjectFactory<BenchmarkResult>(BenchmarkModule::getBenchmarkResultClass).addIntProperty("iterations", BenchmarkResult::iterations).addIntProperty("repetitions", BenchmarkResult::repetitions).addValueProperty("samples", BenchmarkResult::samples).addDurationProperty("min", BenchmarkResult::min).addDurationProperty("max", BenchmarkResult::max).addDurationProperty("mean", BenchmarkResult::mean).addDurationProperty("stdev", BenchmarkResult::stdDeviation).addDurationProperty("error", BenchmarkResult::errorMargin);

    private BenchmarkUtils() {
    }

    static VmTyped runBenchmark(VmTyped benchmark, LongFunction<Object> iterationRunner) {
        int iterations = ((Long)VmUtils.readMember(benchmark, Identifier.ITERATIONS)).intValue();
        VmDuration iterationTime = (VmDuration)VmUtils.readMember(benchmark, Identifier.ITERATION_TIME);
        long iterationTimeNanos = Math.round(iterationTime.getValue(DurationUnit.NANOS));
        boolean isVerbose = (Boolean)VmUtils.readMember(benchmark, Identifier.IS_VERBOSE);
        long repetitions = 0L;
        for (int i2 = 0; i2 < iterations; ++i2) {
            repetitions = BenchmarkUtils.runWarmupIteration(iterationRunner, iterationTimeNanos);
        }
        double[] samples = new double[iterations];
        double min2 = Double.MAX_VALUE;
        double max2 = Double.MIN_VALUE;
        double mean = 0.0;
        double sumOfSquares = 0.0;
        for (int i3 = 0; i3 < iterations; ++i3) {
            double sample;
            long actualIterationTime = BenchmarkUtils.runMeasureIteration(iterationRunner, repetitions);
            samples[i3] = sample = (double)actualIterationTime / (double)repetitions;
            min2 = Math.min(min2, sample);
            max2 = Math.max(max2, sample);
            double delta = sample - mean;
            sumOfSquares += delta * (sample - (mean += delta / (double)(i3 + 1)));
        }
        double variance = sumOfSquares / (double)(iterations - 1);
        double stdDeviation = Math.sqrt(variance);
        double stdError = stdDeviation / Math.sqrt(iterations);
        double errorMargin = stdError * 2.576;
        BenchmarkResult result2 = new BenchmarkResult(iterations, repetitions, (double[])(isVerbose ? samples : null), min2, max2, mean, stdDeviation, errorMargin);
        return benchmarkResultFactory.create(result2);
    }

    private static long runWarmupIteration(LongFunction<Object> iterationRunner, long iterationTime) {
        int state = 1;
        long repetitions = 1L;
        long minIterationTime = Math.round((double)(iterationTime * 2L) / 3.0);
        long startTime = System.nanoTime();
        do {
            iterationRunner.apply(repetitions);
            if (state == 1) {
                state = 2;
                repetitions *= 2L;
                continue;
            }
            if (state == 2) {
                state = 5;
                repetitions = repetitions * 5L / 2L;
                continue;
            }
            state = 1;
            repetitions *= 2L;
        } while (System.nanoTime() - startTime < minIterationTime);
        return repetitions;
    }

    private static long runMeasureIteration(LongFunction<Object> iterationRunner, long repetitions) {
        long startTime = System.nanoTime();
        iterationRunner.apply(repetitions);
        return System.nanoTime() - startTime;
    }

    private static final class BenchmarkResult {
        final long iterations;
        final long repetitions;
        final VmValue samples;
        final VmDuration min;
        final VmDuration max;
        final VmDuration mean;
        final VmDuration stdDeviation;
        final VmDuration errorMargin;

        BenchmarkResult(long iterations, long repetitions, double @Nullable [] samples, double min2, double max2, double mean, double stdDeviation, double errorMargin) {
            this.iterations = iterations;
            this.repetitions = repetitions;
            DurationUnit unit2 = BenchmarkResult.chooseUnit(mean);
            this.samples = BenchmarkResult.toList(samples, unit2);
            this.min = BenchmarkResult.toDuration(min2, unit2);
            this.max = BenchmarkResult.toDuration(max2, unit2);
            this.mean = BenchmarkResult.toDuration(mean, unit2);
            this.stdDeviation = BenchmarkResult.toDuration(stdDeviation, unit2);
            this.errorMargin = BenchmarkResult.toDuration(errorMargin, unit2);
        }

        long iterations() {
            return this.iterations;
        }

        long repetitions() {
            return this.repetitions;
        }

        VmValue samples() {
            return this.samples;
        }

        VmDuration min() {
            return this.min;
        }

        VmDuration max() {
            return this.max;
        }

        VmDuration mean() {
            return this.mean;
        }

        VmDuration stdDeviation() {
            return this.stdDeviation;
        }

        VmDuration errorMargin() {
            return this.errorMargin;
        }

        private static DurationUnit chooseUnit(double nanos) {
            if (nanos < 1000.0) {
                return DurationUnit.NANOS;
            }
            if (nanos < 1000000.0) {
                return DurationUnit.MICROS;
            }
            if (nanos < 1.0E9) {
                return DurationUnit.MILLIS;
            }
            return DurationUnit.SECONDS;
        }

        private static VmDuration toDuration(double nanos, DurationUnit unit2) {
            return new VmDuration(nanos / (double)unit2.getNanos(), unit2);
        }

        private static VmValue toList(double @Nullable [] values2, DurationUnit unit2) {
            if (values2 == null) {
                return VmNull.withoutDefault();
            }
            VmCollection.Builder<VmList> builder = VmList.EMPTY.builder();
            for (double value2 : values2) {
                builder.add(BenchmarkResult.toDuration(value2, unit2));
            }
            return builder.build();
        }
    }
}

