/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.stdlib.benchmark;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Path;
import java.util.List;
import org.pkl.core.SecurityManager;
import org.pkl.core.SecurityManagerException;
import org.pkl.core.module.ModuleKey;
import org.pkl.core.module.PathElement;
import org.pkl.core.module.ResolvedModuleKey;
import org.pkl.core.runtime.Identifier;
import org.pkl.core.runtime.ModuleInfo;
import org.pkl.core.runtime.VmLanguage;
import org.pkl.core.runtime.VmTyped;
import org.pkl.core.runtime.VmUtils;
import org.pkl.core.stdlib.ExternalMethod0Node;
import org.pkl.core.stdlib.benchmark.BenchmarkUtils;
import org.pkl.core.util.MutableReference;
import org.pkl.core.util.Nullable;
import org.pkl.thirdparty.truffle.api.CompilerDirectives;
import org.pkl.thirdparty.truffle.api.dsl.Specialization;

public final class OutputBenchmarkNodes {

    private static final class UncachedModuleKey
    implements ModuleKey {
        private final ModuleKey delegate;

        public UncachedModuleKey(ModuleKey delegate2) {
            this.delegate = delegate2;
        }

        @Override
        public URI getUri() {
            return this.delegate.getUri();
        }

        @Override
        public ResolvedModuleKey resolve(SecurityManager securityManager2) throws IOException, SecurityManagerException {
            final ResolvedModuleKey resolvedDelegate = this.delegate.resolve(securityManager2);
            return new ResolvedModuleKey(){

                @Override
                public ModuleKey getOriginal() {
                    return this;
                }

                @Override
                public URI getUri() {
                    return resolvedDelegate.getUri();
                }

                @Override
                public String loadSource() throws IOException {
                    return resolvedDelegate.loadSource();
                }
            };
        }

        @Override
        public boolean isCached() {
            return false;
        }

        @Override
        @Nullable
        public Path getFileCacheLocation() {
            return this.delegate.getFileCacheLocation();
        }

        @Override
        public boolean hasHierarchicalUris() {
            return this.delegate.hasHierarchicalUris();
        }

        @Override
        public boolean isLocal() {
            return this.delegate.isLocal();
        }

        @Override
        public boolean isGlobbable() {
            return this.delegate.isGlobbable();
        }

        @Override
        public boolean hasElement(SecurityManager securityManager2, URI uri) throws IOException, SecurityManagerException {
            return this.delegate.hasElement(securityManager2, uri);
        }

        @Override
        public List<PathElement> listElements(SecurityManager securityManager2, URI baseUri) throws IOException, SecurityManagerException {
            return this.delegate.listElements(securityManager2, baseUri);
        }
    }

    public static abstract class run
    extends ExternalMethod0Node {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        protected VmTyped eval(VmTyped self) {
            VmTyped module = (VmTyped)VmUtils.readMember(self, Identifier.SOURCE_MODULE);
            ModuleInfo moduleInfo = VmUtils.getModuleInfo(module);
            UncachedModuleKey moduleKey = new UncachedModuleKey(moduleInfo.getModuleKey());
            MutableReference<Object> blackhole = new MutableReference<Object>(null);
            VmLanguage language = VmLanguage.get(this);
            return BenchmarkUtils.runBenchmark(self, repetitions -> {
                for (long i2 = 0L; i2 < repetitions; ++i2) {
                    VmTyped uncachedModule = language.loadModule(moduleKey);
                    Object output2 = VmUtils.readMember(uncachedModule, Identifier.OUTPUT);
                    blackhole.set(VmUtils.readTextProperty(output2));
                }
                return blackhole.get();
            });
        }
    }
}

