/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.pkl.core.runtime.VmExceptionBuilder;

public final class ByteArrayUtils {
    private ByteArrayUtils() {
    }

    public static String md5(byte[] input2) {
        return ByteArrayUtils.hash(input2, "MD5");
    }

    public static String sha1(byte[] input2) {
        return ByteArrayUtils.hash(input2, "SHA-1");
    }

    public static String sha256(byte[] input2) {
        return ByteArrayUtils.hash(input2, "SHA-256");
    }

    public static long sha256Int(byte[] input2) {
        return ByteArrayUtils.hashInt(input2, "SHA-256");
    }

    public static String toHex(byte[] hash) {
        char[] hexDigitTable = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuilder builder = new StringBuilder(hash.length * 2);
        for (byte b2 : hash) {
            builder.append(hexDigitTable[b2 >> 4 & 0xF]);
            builder.append(hexDigitTable[b2 & 0xF]);
        }
        return builder.toString();
    }

    private static String hash(byte[] input2, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = digest.digest(input2);
            return ByteArrayUtils.toHex(hash);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new VmExceptionBuilder().unreachableCode().withCause(e2).build();
        }
    }

    private static long hashInt(byte[] input2, String algorithm) {
        try {
            MessageDigest digest = MessageDigest.getInstance(algorithm);
            byte[] hash = digest.digest(input2);
            long hash64 = 0L;
            for (int i2 = 0; i2 < 8; ++i2) {
                hash64 |= ((long)hash[i2] & 0xFFL) << i2 * 8;
            }
            return hash64;
        }
        catch (NoSuchAlgorithmException e2) {
            throw new VmExceptionBuilder().unreachableCode().withCause(e2).build();
        }
    }
}

