/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.util.PrimitiveIterator;
import java.util.Set;
import org.pkl.core.PClassInfo;
import org.pkl.core.PType;
import org.pkl.core.util.Nullable;

public final class CodeGeneratorUtils {
    private static final int UNDERSCORE = 95;

    private CodeGeneratorUtils() {
    }

    public static boolean isRepresentableAsEnum(PType type2, @Nullable Set<String> collector) {
        if (type2 instanceof PType.StringLiteral) {
            PType.StringLiteral stringLiteralType = (PType.StringLiteral)type2;
            if (collector != null) {
                collector.add(stringLiteralType.getLiteral());
            }
            return true;
        }
        if (type2 instanceof PType.Alias) {
            PType.Alias aliasType = (PType.Alias)type2;
            return CodeGeneratorUtils.isRepresentableAsEnum(aliasType.getAliasedType(), collector);
        }
        if (type2 instanceof PType.Union) {
            PType.Union unionType = (PType.Union)type2;
            for (PType elementType : unionType.getElementTypes()) {
                if (CodeGeneratorUtils.isRepresentableAsEnum(elementType, collector)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isRepresentableAsString(PType type2) {
        if (type2 instanceof PType.StringLiteral) {
            return true;
        }
        if (type2 instanceof PType.Class) {
            PType.Class classType = (PType.Class)type2;
            return classType.getPClass().getInfo() == PClassInfo.String;
        }
        if (type2 instanceof PType.Alias) {
            PType.Alias aliasType = (PType.Alias)type2;
            return CodeGeneratorUtils.isRepresentableAsString(aliasType.getAliasedType());
        }
        if (type2 instanceof PType.Union) {
            PType.Union unionType = (PType.Union)type2;
            for (PType elementType : unionType.getElementTypes()) {
                if (CodeGeneratorUtils.isRepresentableAsString(elementType)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Nullable
    public static String toEnumConstantName(String pklStringLiteral) {
        if (pklStringLiteral.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        int firstCodePoint = pklStringLiteral.codePointAt(0);
        if (Character.getType(firstCodePoint) == 9) {
            builder.appendCodePoint(95);
        }
        PrimitiveIterator.OfInt iterator2 = pklStringLiteral.codePoints().iterator();
        boolean seenPotentialWordEnd = false;
        while (iterator2.hasNext()) {
            int codePoint = iterator2.nextInt();
            int category = Character.getType(codePoint);
            if (CodeGeneratorUtils.isPunctuationOrSpacing(category)) {
                builder.appendCodePoint(95);
                seenPotentialWordEnd = false;
                continue;
            }
            if (!CodeGeneratorUtils.isValidIdentifierPart(codePoint, category)) {
                return null;
            }
            boolean isUpperCase = Character.isUpperCase(codePoint);
            if (seenPotentialWordEnd && isUpperCase) {
                builder.appendCodePoint(95).appendCodePoint(codePoint);
                seenPotentialWordEnd = false;
                continue;
            }
            builder.appendCodePoint(isUpperCase ? codePoint : Character.toUpperCase(codePoint));
            seenPotentialWordEnd = !isUpperCase;
        }
        return builder.toString();
    }

    private static boolean isValidIdentifierPart(int codePoint, int category) {
        return switch (category) {
            case 1, 2, 3, 4, 5, 9, 10 -> true;
            default -> codePoint == 95;
        };
    }

    private static boolean isPunctuationOrSpacing(int category) {
        return switch (category) {
            case 12, 13, 14, 20, 21, 22, 23, 24, 29, 30 -> true;
            default -> false;
        };
    }
}

