/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.http.HttpResponse;
import org.pkl.core.PklBugException;
import org.pkl.core.util.ErrorMessages;

public final class HttpUtils {
    private HttpUtils() {
    }

    public static boolean isHttpUrl(URL url2) {
        String protocol = url2.getProtocol();
        return "https".equalsIgnoreCase(protocol) || "http".equalsIgnoreCase(protocol);
    }

    public static boolean isHttpUrl(URI uri) {
        String scheme = uri.getScheme();
        return "https".equalsIgnoreCase(scheme) || "http".equalsIgnoreCase(scheme);
    }

    public static void checkHasStatusCode200(HttpResponse<?> response) throws IOException {
        if (response.statusCode() == 200) {
            return;
        }
        Object body2 = response.body();
        if (body2 instanceof AutoCloseable) {
            AutoCloseable closeable = (AutoCloseable)body2;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new IOException(ErrorMessages.create("badHttpStatusCode", response.statusCode(), response.uri()));
    }

    public static URI setPort(URI uri, int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException(String.valueOf(port));
        }
        try {
            return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), port, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        catch (URISyntaxException e2) {
            throw PklBugException.unreachableCode();
        }
    }
}

