/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util;

import java.util.function.Consumer;

public final class StringUtils {
    private static final String TABLE = "\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000";
    private static final int MULTIPLIER = 1682554634;
    private static final int SHIFT = Integer.numberOfLeadingZeros("\u2002\u3000\r\u0085\u200a\u2005\u2000\u3000\u2029\u000b\u3000\u2008\u2003\u205f\u3000\u1680\t \u2006\u2001\u202f\u00a0\f\u2009\u3000\u2004\u3000\u3000\u2028\n\u2007\u3000".length() - 1);

    private StringUtils() {
    }

    public static boolean isWhitespace(int codePoint) {
        return Character.isBmpCodePoint(codePoint) && StringUtils.isWhitespace((char)codePoint);
    }

    public static boolean isWhitespace(char ch) {
        return TABLE.charAt(1682554634 * ch >>> SHIFT) == ch;
    }

    public static boolean isBlank(String str) {
        for (int i2 = 0; i2 < str.length(); ++i2) {
            if (StringUtils.isWhitespace(str.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static String trim(String str) {
        int index = StringUtils.indexOfNonWhitespace(str);
        if (index == str.length()) {
            return "";
        }
        int lastIndex2 = StringUtils.lastIndexOfNonWhitespace(str);
        return str.substring(index, lastIndex2);
    }

    public static String trimStart(String str) {
        return str.substring(StringUtils.indexOfNonWhitespace(str));
    }

    public static String trimEnd(String str) {
        return str.substring(0, StringUtils.lastIndexOfNonWhitespace(str));
    }

    public static <T> void joinToStringBuilder(StringBuilder builder, Iterable<T> coll, String delimiter, Consumer<T> eachFn) {
        int i2 = 0;
        for (T v : coll) {
            if (i2++ != 0) {
                builder.append(delimiter);
            }
            eachFn.accept(v);
        }
    }

    public static <T> void joinToStringBuilder(StringBuilder builder, Iterable<T> coll, String delimiter) {
        StringUtils.joinToStringBuilder(builder, coll, delimiter, builder::append);
    }

    public static <T> void joinToStringBuilder(StringBuilder builder, Iterable<T> coll, Consumer<T> eachFn) {
        StringUtils.joinToStringBuilder(builder, coll, ", ", eachFn);
    }

    private static int indexOfNonWhitespace(String str) {
        int length2 = str.length();
        for (int i2 = 0; i2 < length2; ++i2) {
            if (StringUtils.isWhitespace(str.charAt(i2))) continue;
            return i2;
        }
        return length2;
    }

    private static int lastIndexOfNonWhitespace(String str) {
        int length2;
        for (int i2 = length2 = str.length(); i2 > 0; --i2) {
            if (StringUtils.isWhitespace(str.charAt(i2 - 1))) continue;
            return i2;
        }
        return 0;
    }
}

