/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.json;

import org.pkl.core.util.AbstractCharEscaper;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.Nullable;

public final class JsonEscaper
extends AbstractCharEscaper {
    private static final String[] REPLACEMENTS = new String[93];
    private static final String[] HTML_SAFE_REPLACEMENTS;
    @Nullable
    private final String[] replacements;

    public JsonEscaper(boolean isHtmlSafe) {
        this.replacements = isHtmlSafe ? HTML_SAFE_REPLACEMENTS : REPLACEMENTS;
    }

    @Override
    @Nullable
    protected String findReplacement(char ch) {
        return ch <= '\\' ? this.replacements[ch] : (ch == '\u2028' ? "\\u2028" : (ch == '\u2029' ? "\\u2029" : null));
    }

    static {
        for (int i2 = 0; i2 < 32; ++i2) {
            JsonEscaper.REPLACEMENTS[i2] = IoUtils.toUnicodeEscape(i2);
        }
        JsonEscaper.REPLACEMENTS[34] = "\\\"";
        JsonEscaper.REPLACEMENTS[9] = "\\t";
        JsonEscaper.REPLACEMENTS[8] = "\\b";
        JsonEscaper.REPLACEMENTS[10] = "\\n";
        JsonEscaper.REPLACEMENTS[13] = "\\r";
        JsonEscaper.REPLACEMENTS[12] = "\\f";
        JsonEscaper.REPLACEMENTS[92] = "\\\\";
        HTML_SAFE_REPLACEMENTS = (String[])REPLACEMENTS.clone();
        JsonEscaper.HTML_SAFE_REPLACEMENTS[60] = "\\u003c";
        JsonEscaper.HTML_SAFE_REPLACEMENTS[62] = "\\u003e";
        JsonEscaper.HTML_SAFE_REPLACEMENTS[38] = "\\u0026";
        JsonEscaper.HTML_SAFE_REPLACEMENTS[61] = "\\u003d";
        JsonEscaper.HTML_SAFE_REPLACEMENTS[39] = "\\u0027";
    }
}

