/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.json;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.pkl.core.util.Nullable;
import org.pkl.core.util.json.JsonEscaper;

public final class JsonWriter
implements Closeable,
Flushable {
    static final int EMPTY_ARRAY = 1;
    static final int NONEMPTY_ARRAY = 2;
    static final int EMPTY_OBJECT = 3;
    static final int DANGLING_NAME = 4;
    static final int NONEMPTY_OBJECT = 5;
    static final int EMPTY_DOCUMENT = 6;
    static final int NONEMPTY_DOCUMENT = 7;
    static final int CLOSED = 8;
    private final Writer out;
    private int[] stack = new int[32];
    private int stackSize = 0;
    @Nullable
    private String indent;
    private String separator;
    private boolean lenient;
    private boolean htmlSafe;
    private JsonEscaper escaper;
    @Nullable
    private String deferredName;
    private boolean serializeNulls;

    public JsonWriter(Writer out2) {
        this.push(6);
        this.separator = ":";
        this.escaper = new JsonEscaper(false);
        this.serializeNulls = true;
        this.out = out2;
    }

    public void setIndent(String indent) {
        if (indent.isEmpty()) {
            this.indent = null;
            this.separator = ":";
        } else {
            this.indent = indent;
            this.separator = ": ";
        }
    }

    public void setLenient(boolean lenient) {
        this.lenient = lenient;
    }

    public boolean isLenient() {
        return this.lenient;
    }

    public void setHtmlSafe(boolean htmlSafe) {
        this.htmlSafe = htmlSafe;
        this.escaper = new JsonEscaper(htmlSafe);
    }

    public boolean isHtmlSafe() {
        return this.htmlSafe;
    }

    public void setSerializeNulls(boolean serializeNulls) {
        this.serializeNulls = serializeNulls;
    }

    public boolean getSerializeNulls() {
        return this.serializeNulls;
    }

    public JsonWriter beginArray() throws IOException {
        this.writeDeferredName();
        return this.open(1, '[');
    }

    public JsonWriter endArray() throws IOException {
        return this.close(1, 2, ']');
    }

    public JsonWriter beginObject() throws IOException {
        this.writeDeferredName();
        return this.open(3, '{');
    }

    public JsonWriter endObject() throws IOException {
        return this.close(3, 5, '}');
    }

    private JsonWriter open(int empty2, char openBracket) throws IOException {
        this.beforeValue();
        this.push(empty2);
        this.out.write(openBracket);
        return this;
    }

    private JsonWriter close(int empty2, int nonempty, char closeBracket) throws IOException {
        int context2 = this.peek();
        if (context2 != nonempty && context2 != empty2) {
            throw new IllegalStateException("Nesting problem.");
        }
        if (this.deferredName != null) {
            throw new IllegalStateException("Dangling name: " + this.deferredName);
        }
        --this.stackSize;
        if (context2 == nonempty) {
            this.newline();
        }
        this.out.write(closeBracket);
        return this;
    }

    private void push(int newTop) {
        if (this.stackSize == this.stack.length) {
            this.stack = Arrays.copyOf(this.stack, this.stackSize * 2);
        }
        this.stack[this.stackSize++] = newTop;
    }

    private int peek() {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        return this.stack[this.stackSize - 1];
    }

    private void replaceTop(int topOfStack) {
        this.stack[this.stackSize - 1] = topOfStack;
    }

    public JsonWriter name(String name) {
        if (this.deferredName != null) {
            throw new IllegalStateException();
        }
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.deferredName = name;
        return this;
    }

    private void writeDeferredName() throws IOException {
        if (this.deferredName != null) {
            this.beforeName();
            this.string(this.deferredName);
            this.deferredName = null;
        }
    }

    public JsonWriter value(@Nullable String value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.string(value2);
        return this;
    }

    public JsonWriter nullValue() throws IOException {
        if (this.deferredName != null) {
            if (this.serializeNulls) {
                this.writeDeferredName();
            } else {
                this.deferredName = null;
                return this;
            }
        }
        this.beforeValue();
        this.out.write("null");
        return this;
    }

    public JsonWriter value(boolean value2) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value2 ? "true" : "false");
        return this;
    }

    public JsonWriter value(@Nullable Boolean value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(value2 != false ? "true" : "false");
        return this;
    }

    public JsonWriter value(double value2) throws IOException {
        this.writeDeferredName();
        if (!this.lenient && (Double.isNaN(value2) || Double.isInfinite(value2))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value2);
        }
        this.beforeValue();
        this.out.append(Double.toString(value2));
        return this;
    }

    public JsonWriter value(long value2) throws IOException {
        this.writeDeferredName();
        this.beforeValue();
        this.out.write(Long.toString(value2));
        return this;
    }

    public JsonWriter value(@Nullable Number value2) throws IOException {
        if (value2 == null) {
            return this.nullValue();
        }
        this.writeDeferredName();
        String string = value2.toString();
        if (!this.lenient && (string.equals("-Infinity") || string.equals("Infinity") || string.equals("NaN"))) {
            throw new IllegalArgumentException("Numeric values must be finite, but was " + value2);
        }
        this.beforeValue();
        this.out.append(string);
        return this;
    }

    public JsonWriter rawText(String text) throws IOException {
        this.out.append(text);
        return this;
    }

    @Override
    public void flush() throws IOException {
        if (this.stackSize == 0) {
            throw new IllegalStateException("JsonWriter is closed.");
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        int size = this.stackSize;
        if (size > 1 || size == 1 && this.stack[size - 1] != 7) {
            throw new IOException("Incomplete document");
        }
        this.stackSize = 0;
    }

    private void string(String value2) throws IOException {
        this.out.write(34);
        this.out.write(this.escaper.escape(value2));
        this.out.write(34);
    }

    public void newline() throws IOException {
        if (this.indent == null) {
            return;
        }
        this.out.write(10);
        int size = this.stackSize;
        for (int i2 = 1; i2 < size; ++i2) {
            this.out.write(this.indent);
        }
    }

    private void beforeName() throws IOException {
        int context2 = this.peek();
        if (context2 == 5) {
            this.out.write(44);
        } else if (context2 != 3) {
            throw new IllegalStateException("Nesting problem.");
        }
        this.newline();
        this.replaceTop(4);
    }

    private void beforeValue() throws IOException {
        switch (this.peek()) {
            case 7: {
                if (!this.lenient) {
                    throw new IllegalStateException("JSON must have only one top-level value.");
                }
            }
            case 6: {
                this.replaceTop(7);
                break;
            }
            case 1: {
                this.replaceTop(2);
                this.newline();
                break;
            }
            case 2: {
                this.out.append(',');
                this.newline();
                break;
            }
            case 4: {
                this.out.append(this.separator);
                this.replaceTop(5);
                break;
            }
            default: {
                throw new IllegalStateException("Nesting problem.");
            }
        }
    }
}

