/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.core.util.yaml;

import org.pkl.core.util.IoUtils;
import org.pkl.core.util.yaml.Yaml11Emitter;
import org.pkl.core.util.yaml.YamlEmitter;

public final class YamlCompatEmitter
extends YamlEmitter {
    public YamlCompatEmitter(StringBuilder builder, String indent) {
        super(builder, indent);
    }

    @Override
    protected boolean isReservedWord(String str) {
        return YamlCompatEmitter.isReserved11Word(str);
    }

    @Override
    protected boolean isNumber(String str, int colonIndex) {
        int offset;
        int length2 = str.length();
        assert (length2 > 0);
        if (length2 == 1) {
            char ch = str.charAt(0);
            return IoUtils.isDecimalDigit(ch) || ch == '.';
        }
        switch (str.charAt(0)) {
            case '+': 
            case '-': {
                int n = 1;
                break;
            }
            default: {
                int n = offset = 0;
            }
        }
        if (colonIndex != -1) {
            return Yaml11Emitter.isSexagesimalNumber(str, offset, length2, colonIndex);
        }
        switch (str.charAt(offset)) {
            case 'o': {
                return Yaml11Emitter.isOctalNumber(str, offset + 1, length2);
            }
            case '0': {
                if (offset == length2 - 1) {
                    return true;
                }
                switch (str.charAt(offset + 1)) {
                    case 'b': {
                        return Yaml11Emitter.isBinaryNumber(str, offset + 2, length2);
                    }
                    case 'o': {
                        return Yaml11Emitter.isOctalNumber(str, offset + 2, length2);
                    }
                    case 'x': {
                        return Yaml11Emitter.isHexadecimalNumber(str, offset + 2, length2);
                    }
                }
            }
        }
        return YamlCompatEmitter.isDecimalNumber(str, offset, length2);
    }

    static boolean isDecimalNumber(String str, int start2, int length2) {
        int index;
        char ch = '\u0000';
        for (index = start2; index < length2 && IoUtils.isDecimalDigitOrUnderscore(ch = str.charAt(index)); ++index) {
        }
        if (index == length2) {
            return true;
        }
        if (ch == '.') {
            ++index;
            while (index < length2 && IoUtils.isDecimalDigitOrUnderscore(ch = str.charAt(index))) {
                ++index;
            }
            if (index == length2) {
                return true;
            }
        }
        if (ch == 'e' || ch == 'E') {
            if (++index == length2) {
                return false;
            }
            ch = str.charAt(index);
            if ((ch == '-' || ch == '+') && ++index == length2) {
                return false;
            }
            while (index < length2 && IoUtils.isDecimalDigit(ch = str.charAt(index))) {
                ++index;
            }
        }
        return index == length2;
    }
}

