/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.doc;

import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pkl.commons.PathsKt;
import org.pkl.core.ModuleSchema;
import org.pkl.core.util.IoUtils;
import org.pkl.doc.DocGenerator;
import org.pkl.doc.DocGeneratorException;
import org.pkl.doc.DocPackage;
import org.pkl.doc.DocPackageInfo;
import org.pkl.doc.DocsiteInfo;
import org.pkl.doc.HtmlGenerator;
import org.pkl.doc.PackageData;
import org.pkl.doc.PackageDataGenerator;
import org.pkl.doc.RuntimeDataGenerator;
import org.pkl.doc.SearchIndexGenerator;
import org.pkl.doc.UtilKt;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.comparisons.ComparisonsKt;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.DefaultConstructorMarker;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.sequences.SequencesKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fBe\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\n\u0012\u0016\u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0017H\u0002J\u0006\u0010\u001d\u001a\u00020\u001aJ\f\u0010\u001e\u001a\u00020\u001a*\u00020\u0018H\u0002R\u001e\u0010\u0015\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/pkl/doc/DocGenerator;", "", "docsiteInfo", "Lorg/pkl/doc/DocsiteInfo;", "modules", "", "Lorg/pkl/doc/DocPackageInfo;", "", "Lorg/pkl/core/ModuleSchema;", "importResolver", "Lorg/pkl/thirdparty/kotlin/Function1;", "Ljava/net/URI;", "versionComparator", "Ljava/util/Comparator;", "", "Lorg/pkl/thirdparty/kotlin/Comparator;", "outputDir", "Ljava/nio/file/Path;", "isTestMode", "", "(Lorg/pkl/doc/DocsiteInfo;Ljava/util/Map;Lkotlin/jvm/functions/Function1;Ljava/util/Comparator;Ljava/nio/file/Path;Z)V", "descendingVersionComparator", "docPackages", "", "Lorg/pkl/doc/DocPackage;", "createSymlinks", "", "currentPackagesData", "Lorg/pkl/doc/PackageData;", "run", "deletePackageDir", "Companion", "pkl-doc"})
public final class DocGenerator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DocsiteInfo docsiteInfo;
    @NotNull
    private final Function1<URI, ModuleSchema> importResolver;
    @NotNull
    private final Path outputDir;
    private final boolean isTestMode;
    @NotNull
    private final Comparator<String> descendingVersionComparator;
    @NotNull
    private final List<DocPackage> docPackages;

    /*
     * WARNING - void declaration
     */
    public DocGenerator(@NotNull DocsiteInfo docsiteInfo, @NotNull Map<DocPackageInfo, ? extends Collection<ModuleSchema>> modules, @NotNull Function1<? super URI, ModuleSchema> importResolver, @NotNull Comparator<String> versionComparator, @NotNull Path outputDir, boolean isTestMode) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(docsiteInfo, "docsiteInfo");
        Intrinsics.checkNotNullParameter(modules, "modules");
        Intrinsics.checkNotNullParameter(importResolver, "importResolver");
        Intrinsics.checkNotNullParameter(versionComparator, "versionComparator");
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        this.docsiteInfo = docsiteInfo;
        this.importResolver = importResolver;
        this.outputDir = outputDir;
        this.isTestMode = isTestMode;
        Comparator<String> comparator = versionComparator.reversed();
        Intrinsics.checkNotNullExpressionValue(comparator, "versionComparator.reversed()");
        this.descendingVersionComparator = comparator;
        Map<DocPackageInfo, ? extends Collection<ModuleSchema>> map2 = modules;
        DocGenerator docGenerator = this;
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            void it;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator2.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new DocPackage((DocPackageInfo)it.getKey(), CollectionsKt.toList((Iterable)it.getValue())));
        }
        docGenerator.docPackages = (List)destination$iv$iv;
    }

    public /* synthetic */ DocGenerator(DocsiteInfo docsiteInfo, Map map2, Function1 function1, Comparator comparator, Path path2, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        this(docsiteInfo, map2, function1, comparator, path2, bl);
    }

    public final void run() {
        try {
            HtmlGenerator htmlGenerator = new HtmlGenerator(this.docsiteInfo, this.docPackages, this.importResolver, this.outputDir, this.isTestMode);
            SearchIndexGenerator searchIndexGenerator = new SearchIndexGenerator(this.outputDir);
            PackageDataGenerator packageDataGenerator = new PackageDataGenerator(this.outputDir);
            RuntimeDataGenerator runtimeDataGenerator = new RuntimeDataGenerator(this.descendingVersionComparator, this.outputDir);
            for (DocPackage docPackage : this.docPackages) {
                if (docPackage.isUnlisted()) continue;
                this.deletePackageDir(docPackage);
                htmlGenerator.generate(docPackage);
                searchIndexGenerator.generate(docPackage);
                packageDataGenerator.generate(docPackage);
            }
            List<PackageData> packagesData = packageDataGenerator.readAll();
            List<PackageData> currentPackagesData = Companion.current$pkl_doc(packagesData, this.descendingVersionComparator);
            this.createSymlinks(currentPackagesData);
            htmlGenerator.generateSite(currentPackagesData);
            searchIndexGenerator.generateSiteIndex(currentPackagesData);
            runtimeDataGenerator.deleteDataDir();
            runtimeDataGenerator.generate(packagesData);
        }
        catch (IOException e2) {
            throw new DocGeneratorException("I/O error generating documentation.", e2);
        }
    }

    private final void deletePackageDir(DocPackage $this$deletePackageDir) {
        Path path2 = this.outputDir.resolve($this$deletePackageDir.getName() + "/" + $this$deletePackageDir.getVersion());
        Intrinsics.checkNotNullExpressionValue(path2, "outputDir.resolve(\"$name/$version\")");
        PathsKt.deleteRecursively(path2);
    }

    private final void createSymlinks(List<PackageData> currentPackagesData) {
        for (PackageData packageData : currentPackagesData) {
            Path path2;
            Path basePath = this.outputDir.resolve(UtilKt.getPathEncoded(packageData.getRef().getPkg()));
            Path src = basePath.resolve(packageData.getRef().getVersion());
            Path dest = basePath.resolve("current");
            Intrinsics.checkNotNullExpressionValue(dest, "dest");
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists(dest, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                Intrinsics.checkNotNullExpressionValue(src, "src");
                if (Files.isSameFile(dest, src)) continue;
            }
            Files.deleteIfExists(dest);
            Path path3 = dest;
            Intrinsics.checkNotNullExpressionValue(IoUtils.relativize(src, basePath), "relativize(src, basePath)");
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue(Files.createSymbolicLink(path3, path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createSymbolicLink(this, target, *attributes)");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J5\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\b\u0012\u0004\u0012\u00020\u00050\u00042\u0016\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tH\u0000\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/pkl/doc/DocGenerator$Companion;", "", "()V", "current", "", "Lorg/pkl/doc/PackageData;", "versionComparator", "Ljava/util/Comparator;", "", "Lorg/pkl/thirdparty/kotlin/Comparator;", "current$pkl_doc", "pkl-doc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<PackageData> current$pkl_doc(@NotNull List<PackageData> $this$current, @NotNull Comparator<String> versionComparator) {
            Intrinsics.checkNotNullParameter($this$current, "<this>");
            Intrinsics.checkNotNullParameter(versionComparator, "versionComparator");
            Comparator comparator = new Comparator(){

                public final int compare(T a2, T b2) {
                    PackageData it = (PackageData)a2;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getRef().getPkg());
                    it = (PackageData)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getRef().getPkg()));
                }
            };
            Comparator comparator2 = new Comparator(comparator, versionComparator){
                final /* synthetic */ Comparator $this_thenBy;
                final /* synthetic */ Comparator $comparator;
                {
                    this.$this_thenBy = $receiver;
                    this.$comparator = $comparator;
                }

                public final int compare(T a2, T b2) {
                    int n;
                    int previousCompare = this.$this_thenBy.compare(a2, b2);
                    if (previousCompare != 0) {
                        n = previousCompare;
                    } else {
                        PackageData packageData = (PackageData)a2;
                        Comparator comparator = this.$comparator;
                        boolean bl = false;
                        PackageData it = (PackageData)b2;
                        String string = it.getRef().getVersion();
                        bl = false;
                        String string2 = it.getRef().getVersion();
                        n = comparator.compare(string, string2);
                    }
                    return n;
                }
            };
            return SequencesKt.toList(SequencesKt.distinctBy(SequencesKt.sortedWith(SequencesKt.filter(CollectionsKt.asSequence((Iterable)$this$current), current.1.INSTANCE), comparator2), current.2.INSTANCE));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

