/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.doc;

import java.net.URI;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pkl.core.ModuleSchema;
import org.pkl.core.PClass;
import org.pkl.doc.ClassPageGenerator;
import org.pkl.doc.ClassScope;
import org.pkl.doc.DocModule;
import org.pkl.doc.DocPackage;
import org.pkl.doc.DocsiteInfo;
import org.pkl.doc.MainPageGenerator;
import org.pkl.doc.ModulePageGenerator;
import org.pkl.doc.ModuleScope;
import org.pkl.doc.PackageData;
import org.pkl.doc.PackagePageGenerator;
import org.pkl.doc.PackageScope;
import org.pkl.doc.SiteScope;
import org.pkl.doc.UtilKt;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0006J\u0014\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u0005J\b\u0010\u0018\u001a\u00020\u0013H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/pkl/doc/HtmlGenerator;", "", "docsiteInfo", "Lorg/pkl/doc/DocsiteInfo;", "docPackages", "", "Lorg/pkl/doc/DocPackage;", "importResolver", "Lorg/pkl/thirdparty/kotlin/Function1;", "Ljava/net/URI;", "Lorg/pkl/core/ModuleSchema;", "outputDir", "Ljava/nio/file/Path;", "isTestMode", "", "(Lorg/pkl/doc/DocsiteInfo;Ljava/util/List;Lkotlin/jvm/functions/Function1;Ljava/nio/file/Path;Z)V", "siteScope", "Lorg/pkl/doc/SiteScope;", "generate", "", "docPackage", "generateSite", "packagesData", "Lorg/pkl/doc/PackageData;", "generateStaticResources", "pkl-doc"})
public final class HtmlGenerator {
    @NotNull
    private final DocsiteInfo docsiteInfo;
    @NotNull
    private final Path outputDir;
    private final boolean isTestMode;
    @NotNull
    private final SiteScope siteScope;

    public HtmlGenerator(@NotNull DocsiteInfo docsiteInfo, @NotNull List<DocPackage> docPackages, @NotNull Function1<? super URI, ModuleSchema> importResolver, @NotNull Path outputDir, boolean isTestMode) {
        Intrinsics.checkNotNullParameter(docsiteInfo, "docsiteInfo");
        Intrinsics.checkNotNullParameter(docPackages, "docPackages");
        Intrinsics.checkNotNullParameter(importResolver, "importResolver");
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        this.docsiteInfo = docsiteInfo;
        this.outputDir = outputDir;
        this.isTestMode = isTestMode;
        this.siteScope = new SiteScope(docPackages, this.docsiteInfo.getOverviewImports(), importResolver, this.outputDir);
    }

    public final void generate(@NotNull DocPackage docPackage) {
        Intrinsics.checkNotNullParameter(docPackage, "docPackage");
        PackageScope packageScope2 = this.siteScope.getPackage(docPackage.getName());
        new PackagePageGenerator(this.docsiteInfo, docPackage, packageScope2).run();
        for (DocModule docModule : docPackage.getDocModules()) {
            if (docModule.isUnlisted()) continue;
            ModuleScope moduleScope = packageScope2.getModule(docModule.getName());
            new ModulePageGenerator(this.docsiteInfo, docPackage, docModule, moduleScope, this.isTestMode).run();
            Map<String, PClass> map2 = docModule.getSchema().getClasses();
            Intrinsics.checkNotNullExpressionValue(map2, "docModule.schema.classes");
            Iterator<Map.Entry<String, PClass>> iterator2 = map2.entrySet().iterator();
            while (iterator2.hasNext()) {
                PClass clazz = iterator2.next().getValue();
                Intrinsics.checkNotNullExpressionValue(clazz, "clazz");
                if (UtilKt.isUnlisted(clazz)) continue;
                new ClassPageGenerator(this.docsiteInfo, docPackage, docModule, clazz, new ClassScope(clazz, moduleScope.getUrl(), moduleScope), this.isTestMode).run();
            }
        }
    }

    public final void generateSite(@NotNull List<PackageData> packagesData) {
        Intrinsics.checkNotNullParameter(packagesData, "packagesData");
        new MainPageGenerator(this.docsiteInfo, packagesData, this.siteScope).run();
        this.generateStaticResources();
    }

    private final void generateStaticResources() {
        UtilKt.copyResource("fonts/lato-v14-latin_latin-ext-regular.woff2", this.outputDir);
        UtilKt.copyResource("fonts/lato-v14-latin_latin-ext-700.woff2", this.outputDir);
        UtilKt.copyResource("fonts/open-sans-v15-latin_latin-ext-regular.woff2", this.outputDir);
        UtilKt.copyResource("fonts/open-sans-v15-latin_latin-ext-italic.woff2", this.outputDir);
        UtilKt.copyResource("fonts/open-sans-v15-latin_latin-ext-700.woff2", this.outputDir);
        UtilKt.copyResource("fonts/open-sans-v15-latin_latin-ext-700italic.woff2", this.outputDir);
        UtilKt.copyResource("fonts/source-code-pro-v7-latin_latin-ext-regular.woff2", this.outputDir);
        UtilKt.copyResource("fonts/source-code-pro-v7-latin_latin-ext-700.woff2", this.outputDir);
        UtilKt.copyResource("fonts/MaterialIcons-Regular.woff2", this.outputDir);
        UtilKt.copyResource("scripts/pkldoc.js", this.outputDir);
        UtilKt.copyResource("scripts/search-worker.js", this.outputDir);
        UtilKt.copyResource("scripts/scroll-into-view.min.js", this.outputDir);
        UtilKt.copyResource("styles/pkldoc.css", this.outputDir);
        UtilKt.copyResource("images/apple-touch-icon.png", this.outputDir);
        UtilKt.copyResource("images/favicon.svg", this.outputDir);
        UtilKt.copyResource("images/favicon-16x16.png", this.outputDir);
        UtilKt.copyResource("images/favicon-32x32.png", this.outputDir);
    }
}

