/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.doc;

import java.net.URI;
import org.pkl.commons.StringsKt;
import org.pkl.core.Member;
import org.pkl.core.ModuleSchema;
import org.pkl.core.PClass;
import org.pkl.core.TypeAlias;
import org.pkl.doc.ClassScope;
import org.pkl.doc.DocScope;
import org.pkl.doc.MethodScope;
import org.pkl.doc.PackageScope;
import org.pkl.doc.PageScope;
import org.pkl.doc.PropertyScope;
import org.pkl.doc.TypeAliasScope;
import org.pkl.doc.UtilKt;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.Lazy;
import org.pkl.thirdparty.kotlin.LazyKt;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.jvm.functions.Function0;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u0005H\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0012\u0010'\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010(\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010!2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u001b\u0010\t\u001a\u00020\u00058VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\r\u001a\u0004\b\u0017\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006,"}, d2={"Lorg/pkl/doc/ModuleScope;", "Lorg/pkl/doc/PageScope;", "module", "Lorg/pkl/core/ModuleSchema;", "url", "Ljava/net/URI;", "parent", "Lorg/pkl/doc/PackageScope;", "(Lorg/pkl/core/ModuleSchema;Ljava/net/URI;Lorg/pkl/doc/PackageScope;)V", "dataUrl", "getDataUrl", "()Ljava/net/URI;", "dataUrl$delegate", "Lorg/pkl/thirdparty/kotlin/Lazy;", "getModule", "()Lorg/pkl/core/ModuleSchema;", "name", "", "getName", "()Ljava/lang/String;", "getParent", "()Lorg/pkl/doc/PackageScope;", "path", "getPath", "path$delegate", "getUrl", "equals", "", "other", "", "getMethod", "Lorg/pkl/doc/MethodScope;", "getProperty", "Lorg/pkl/doc/DocScope;", "hashCode", "", "resolveImport", "uri", "resolveMethod", "resolveModuleNameToDocUrl", "resolveModuleNameToSourceUrl", "sourceLocation", "Lorg/pkl/core/Member$SourceLocation;", "resolveVariable", "pkl-doc"})
public final class ModuleScope
extends PageScope {
    @NotNull
    private final ModuleSchema module;
    @NotNull
    private final URI url;
    @Nullable
    private final PackageScope parent;
    @NotNull
    private final Lazy path$delegate;
    @NotNull
    private final Lazy dataUrl$delegate;

    public ModuleScope(@NotNull ModuleSchema module, @NotNull URI url2, @Nullable PackageScope parent) {
        Intrinsics.checkNotNullParameter(module, "module");
        Intrinsics.checkNotNullParameter(url2, "url");
        this.module = module;
        this.url = url2;
        this.parent = parent;
        this.path$delegate = LazyKt.lazy((Function0)new Function0<String>(this){
            final /* synthetic */ ModuleScope this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final String invoke() {
                String string = this.this$0.getModule().getModuleName();
                Intrinsics.checkNotNullExpressionValue(string, "module.moduleName");
                PackageScope packageScope2 = this.this$0.getParent();
                Intrinsics.checkNotNull(packageScope2);
                return UtilKt.getUriEncoded(UtilKt.getModulePath(string, packageScope2.getDocPackageInfo().getModuleNamePrefix()));
            }
        });
        this.dataUrl$delegate = LazyKt.lazy((Function0)new Function0<URI>(this){
            final /* synthetic */ ModuleScope this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final URI invoke() {
                PackageScope packageScope2 = this.this$0.getParent();
                Intrinsics.checkNotNull(packageScope2);
                return packageScope2.getDataUrl().resolve("./" + this.this$0.getPath() + "/index.js");
            }
        });
    }

    @NotNull
    public final ModuleSchema getModule() {
        return this.module;
    }

    @Override
    @NotNull
    public URI getUrl() {
        return this.url;
    }

    @Override
    @Nullable
    public PackageScope getParent() {
        return this.parent;
    }

    @NotNull
    public final String getName() {
        String string = this.module.getModuleName();
        Intrinsics.checkNotNullExpressionValue(string, "module.moduleName");
        return string;
    }

    @NotNull
    public final String getPath() {
        Lazy lazy = this.path$delegate;
        return (String)lazy.getValue();
    }

    @Override
    @NotNull
    public URI getDataUrl() {
        Lazy lazy = this.dataUrl$delegate;
        Object t = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t, "<get-dataUrl>(...)");
        return (URI)t;
    }

    @Override
    @Nullable
    public MethodScope getMethod(@NotNull String name) {
        MethodScope methodScope;
        Intrinsics.checkNotNullParameter(name, "name");
        PClass.Method method = this.module.getModuleClass().getAllMethods().get(name);
        if (method != null) {
            PClass.Method it = method;
            boolean bl = false;
            methodScope = new MethodScope(it, this);
        } else {
            methodScope = null;
        }
        return methodScope;
    }

    @Override
    @Nullable
    public DocScope getProperty(@NotNull String name) {
        DocScope docScope;
        Intrinsics.checkNotNullParameter(name, "name");
        PClass.Property property = this.module.getModuleClass().getAllProperties().get(name);
        if (property != null) {
            PClass.Property it = property;
            boolean bl = false;
            docScope = new PropertyScope(it, this);
        } else {
            PClass pClass = this.module.getAllClasses().get(name);
            if (pClass != null) {
                PClass it = pClass;
                boolean bl = false;
                docScope = new ClassScope(it, this.getUrl(), this);
            } else {
                TypeAliasScope typeAliasScope;
                TypeAlias typeAlias = this.module.getAllTypeAliases().get(name);
                if (typeAlias != null) {
                    TypeAlias it = typeAlias;
                    boolean bl = false;
                    typeAliasScope = new TypeAliasScope(it, this.getUrl(), this);
                } else {
                    typeAliasScope = null;
                }
                docScope = typeAliasScope;
            }
        }
        return docScope;
    }

    private final ModuleSchema resolveImport(URI uri) {
        PackageScope packageScope2 = this.getParent();
        Intrinsics.checkNotNull(packageScope2);
        return packageScope2.resolveImport(uri);
    }

    @Override
    @Nullable
    public URI resolveModuleNameToDocUrl(@NotNull String name) {
        URI uRI;
        Intrinsics.checkNotNullParameter(name, "name");
        if (Intrinsics.areEqual(name, this.module.getModuleName())) {
            uRI = this.getUrl();
        } else {
            PackageScope packageScope2 = this.getParent();
            Intrinsics.checkNotNull(packageScope2);
            uRI = packageScope2.resolveModuleNameToDocUrl(name);
        }
        return uRI;
    }

    @Override
    @Nullable
    public URI resolveModuleNameToSourceUrl(@NotNull String name, @NotNull Member.SourceLocation sourceLocation) {
        URI uRI;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(sourceLocation, "sourceLocation");
        if (Intrinsics.areEqual(name, this.module.getModuleName())) {
            String string;
            PackageScope packageScope2 = this.getParent();
            Intrinsics.checkNotNull(packageScope2);
            String string2 = packageScope2.getDocPackageInfo().getSourceCodeUrlScheme();
            uRI = string2 != null && (string = UtilKt.replaceSourceCodePlaceholders(string2, "/" + this.getPath() + ".pkl", sourceLocation)) != null ? StringsKt.toUri(string) : null;
        } else {
            PackageScope packageScope3 = this.getParent();
            Intrinsics.checkNotNull(packageScope3);
            uRI = packageScope3.resolveModuleNameToSourceUrl(name, sourceLocation);
        }
        return uRI;
    }

    @Override
    @Nullable
    public MethodScope resolveMethod(@NotNull String name) {
        MethodScope methodScope;
        Intrinsics.checkNotNullParameter(name, "name");
        PClass.Method method = this.module.getModuleClass().getMethods().get(name);
        if (method != null) {
            PClass.Method it = method;
            boolean bl = false;
            methodScope = new MethodScope(it, this);
        } else {
            PackageScope packageScope2 = this.getParent();
            Intrinsics.checkNotNull(packageScope2);
            methodScope = packageScope2.getPklBaseMethod(name);
            if (methodScope == null) {
                methodScope = this.getMethod(name);
            }
        }
        return methodScope;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public DocScope resolveVariable(@NotNull String name) {
        TypeAliasScope typeAliasScope;
        ClassScope classScope;
        PropertyScope propertyScope;
        ModuleScope moduleScope;
        DocScope docScope;
        String string;
        Intrinsics.checkNotNullParameter(name, "name");
        String it = string = name;
        boolean bl = false;
        Object object = Intrinsics.areEqual(it, "module") ? string : null;
        if (object != null) {
            String it2 = object;
            boolean bl2 = false;
            object = this;
            if (object != null) {
                docScope = (DocScope)object;
                return docScope;
            }
        }
        URI uRI = this.module.getImports().get(name);
        if (uRI != null) {
            URI uri = uRI;
            boolean bl3 = false;
            ModuleSchema mod = this.resolveImport(uri);
            String string2 = mod.getModuleName();
            Intrinsics.checkNotNullExpressionValue(string2, "mod.moduleName");
            URI uRI2 = this.resolveModuleNameToDocUrl(string2);
            if (uRI2 != null) {
                URI url2 = uRI2;
                boolean bl4 = false;
                moduleScope = new ModuleScope(mod, url2, null);
            } else {
                moduleScope = null;
            }
        } else {
            moduleScope = null;
        }
        if (moduleScope != null) {
            docScope = moduleScope;
            return docScope;
        }
        PClass.Property property = this.module.getModuleClass().getProperties().get(name);
        if (property != null) {
            PClass.Property it3 = property;
            boolean bl5 = false;
            propertyScope = new PropertyScope(it3, this);
        } else {
            propertyScope = null;
        }
        if (propertyScope != null) {
            docScope = propertyScope;
            return docScope;
        }
        PClass pClass = this.module.getAllClasses().get(name);
        if (pClass != null) {
            PClass it4 = pClass;
            boolean bl6 = false;
            classScope = new ClassScope(it4, this.getUrl(), this);
        } else {
            classScope = null;
        }
        if (classScope != null) {
            docScope = classScope;
            return docScope;
        }
        TypeAlias typeAlias = this.module.getAllTypeAliases().get(name);
        if (typeAlias != null) {
            TypeAlias it5 = typeAlias;
            boolean bl7 = false;
            typeAliasScope = new TypeAliasScope(it5, this.getUrl(), this);
        } else {
            typeAliasScope = null;
        }
        if (typeAliasScope != null) {
            docScope = typeAliasScope;
            return docScope;
        }
        PackageScope packageScope2 = this.getParent();
        Intrinsics.checkNotNull(packageScope2);
        DocScope docScope2 = packageScope2.getPklBaseProperty(name);
        docScope = docScope2;
        if (docScope2 != null) return docScope;
        docScope = this.getProperty(name);
        return docScope;
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ModuleScope && Intrinsics.areEqual(this.module, ((ModuleScope)other).module);
    }

    public int hashCode() {
        return this.module.hashCode();
    }
}

