/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.doc;

import java.io.Closeable;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pkl.commons.PathsKt;
import org.pkl.core.util.json.JsonWriter;
import org.pkl.doc.ClassData;
import org.pkl.doc.DependencyData;
import org.pkl.doc.ModuleData;
import org.pkl.doc.ModuleId;
import org.pkl.doc.ModuleRef;
import org.pkl.doc.PackageData;
import org.pkl.doc.PackageRef;
import org.pkl.doc.RuntimeDataGenerator;
import org.pkl.doc.RuntimeDataGeneratorKt;
import org.pkl.doc.TypeId;
import org.pkl.doc.TypeRef;
import org.pkl.doc.UtilKt;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.Unit;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.collections.SetsKt;
import org.pkl.thirdparty.kotlin.comparisons.ComparisonsKt;
import org.pkl.thirdparty.kotlin.io.CloseableKt;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u001e\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0006\u0010\u001d\u001a\u00020\u0017J\u0014\u0010\u001e\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0014H\u0002J\u0016\u0010!\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010 \u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\u0010H\u0002J?\u0010%\u001a\u00020\u0017\"\u0004\b\u0000\u0010&\"\u0004\b\u0001\u0010'*\u0014\u0012\u0004\u0012\u0002H&\u0012\n\u0012\b\u0012\u0004\u0012\u0002H'0\f0\n2\u0006\u0010(\u001a\u0002H&2\u0006\u0010)\u001a\u0002H'H\u0002\u00a2\u0006\u0002\u0010*J\u0018\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00100,*\b\u0012\u0004\u0012\u00020\u00100-H\u0002J\u0018\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140,*\b\u0012\u0004\u0012\u00020\u00140-H\u0002Jh\u0010/\u001a\u00020\u0017\"\u0004\b\u0000\u00100*\u0002012\u0006\u00102\u001a\u00020\u00042\f\u00103\u001a\b\u0012\u0004\u0012\u0002H00\u00192\u0012\u00104\u001a\u000e\u0012\u0004\u0012\u0002H0\u0012\u0004\u0012\u00020\u0004052\u0014\u00106\u001a\u0010\u0012\u0004\u0012\u0002H0\u0012\u0006\u0012\u0004\u0018\u00010\u0004052\u0014\u00107\u001a\u0010\u0012\u0004\u0012\u0002H0\u0012\u0006\u0012\u0004\u0018\u00010\u000405H\u0002R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0012\u0012\u0004\u0012\u00020\u00040\u0003j\b\u0012\u0004\u0012\u00020\u0004`\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0011\u001a\u0018\u0012\b\u0012\u00060\u0004j\u0002`\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/pkl/doc/RuntimeDataGenerator;", "", "descendingVersionComparator", "Ljava/util/Comparator;", "", "Lorg/pkl/thirdparty/kotlin/Comparator;", "outputDir", "Ljava/nio/file/Path;", "(Ljava/util/Comparator;Ljava/nio/file/Path;)V", "classVersions", "", "Lorg/pkl/doc/TypeId;", "", "moduleVersions", "Lorg/pkl/doc/ModuleId;", "packageUsages", "Lorg/pkl/doc/PackageRef;", "packageVersions", "Lorg/pkl/doc/PackageId;", "subtypes", "Lorg/pkl/doc/TypeRef;", "typeUsages", "collectData", "", "packages", "", "Lorg/pkl/doc/PackageData;", "clazz", "Lorg/pkl/doc/ClassData;", "deleteDataDir", "generate", "writeClassFile", "ref", "writeData", "writeModuleFile", "Lorg/pkl/doc/ModuleRef;", "writePackageFile", "add", "K", "V", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "packagesWithHighestVersions", "", "", "typesWithHighestVersions", "writeLinks", "T", "Lorg/pkl/core/util/json/JsonWriter;", "id", "items", "text", "Lorg/pkl/thirdparty/kotlin/Function1;", "href", "classes", "pkl-doc"})
public final class RuntimeDataGenerator {
    @NotNull
    private final Comparator<String> descendingVersionComparator;
    @NotNull
    private final Path outputDir;
    @NotNull
    private final Map<String, Set<String>> packageVersions;
    @NotNull
    private final Map<ModuleId, Set<String>> moduleVersions;
    @NotNull
    private final Map<TypeId, Set<String>> classVersions;
    @NotNull
    private final Map<PackageRef, Set<PackageRef>> packageUsages;
    @NotNull
    private final Map<TypeRef, Set<TypeRef>> typeUsages;
    @NotNull
    private final Map<TypeRef, Set<TypeRef>> subtypes;

    public RuntimeDataGenerator(@NotNull Comparator<String> descendingVersionComparator, @NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter(descendingVersionComparator, "descendingVersionComparator");
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        this.descendingVersionComparator = descendingVersionComparator;
        this.outputDir = outputDir;
        this.packageVersions = new LinkedHashMap();
        this.moduleVersions = new LinkedHashMap();
        this.classVersions = new LinkedHashMap();
        this.packageUsages = new LinkedHashMap();
        this.typeUsages = new LinkedHashMap();
        this.subtypes = new LinkedHashMap();
    }

    public final void deleteDataDir() {
        Path path2 = this.outputDir.resolve("data");
        Intrinsics.checkNotNullExpressionValue(path2, "outputDir.resolve(\"data\")");
        PathsKt.deleteRecursively(path2);
    }

    public final void generate(@NotNull List<PackageData> packages2) {
        Intrinsics.checkNotNullParameter(packages2, "packages");
        this.collectData(packages2);
        this.writeData(packages2);
    }

    private final void collectData(List<PackageData> packages2) {
        for (PackageData pkg : packages2) {
            this.add(this.packageVersions, pkg.getRef().getPkg(), pkg.getRef().getVersion());
            for (DependencyData dependency : pkg.getDependencies()) {
                if (RuntimeDataGeneratorKt.access$isStdlib(dependency)) continue;
                this.add(this.packageUsages, dependency.getRef(), pkg.getRef());
            }
            for (ModuleData module : pkg.getModules()) {
                this.add(this.moduleVersions, module.getRef().getId(), module.getRef().getVersion());
                if (module.getModuleClass() != null) {
                    this.collectData(module.getModuleClass());
                }
                for (ClassData clazz : module.getClasses()) {
                    this.collectData(clazz);
                }
            }
        }
    }

    private final void collectData(ClassData clazz) {
        this.add(this.classVersions, clazz.getRef().getId(), clazz.getRef().getVersion());
        for (TypeRef superclass : clazz.getSuperclasses()) {
            this.add(this.subtypes, superclass, clazz.getRef());
        }
        for (TypeRef type2 : clazz.getUsedTypes()) {
            this.add(this.typeUsages, type2, clazz.getRef());
        }
    }

    private final void writeData(List<PackageData> packages2) {
        for (PackageData pkg : packages2) {
            this.writePackageFile(pkg.getRef());
            for (ModuleData mod : pkg.getModules()) {
                this.writeModuleFile(mod.getRef());
                for (ClassData clazz : mod.getClasses()) {
                    this.writeClassFile(clazz.getRef());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writePackageFile(PackageRef ref) {
        Path path2 = this.outputDir.resolve("data/" + UtilKt.getPathEncoded(ref.getPkg()) + "/" + UtilKt.getPathEncoded(ref.getVersion()) + "/index.js");
        Intrinsics.checkNotNullExpressionValue(path2, "outputDir\n      .resolve\u2026n.pathEncoded}/index.js\")");
        Closeable closeable = UtilKt.jsonWriter(path2);
        Throwable throwable = null;
        try {
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl = false;
            writer.setLenient(true);
            this.writeLinks(writer, "known-versions", CollectionsKt.sortedWith(this.packageVersions.getOrDefault(ref.getPkg(), SetsKt.emptySet()), this.descendingVersionComparator), writePackageFile.1.1.INSTANCE, (Function1)new Function1<String, String>(ref){
                final /* synthetic */ PackageRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it, this.$ref.getVersion()) ? null : PackageRef.copy$default(this.$ref, null, null, it, 3, null).pageUrlRelativeTo(this.$ref);
                }
            }, (Function1)new Function1<String, String>(ref){
                final /* synthetic */ PackageRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it, this.$ref.getVersion()) ? "current-version" : null;
                }
            });
            Iterable $this$sortedBy$iv = this.packagesWithHighestVersions(this.packageUsages.getOrDefault(ref, SetsKt.emptySet()));
            boolean $i$f$sortedBy = false;
            this.writeLinks(writer, "known-usages", CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    PackageRef it = (PackageRef)a2;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getPkg());
                    it = (PackageRef)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getPkg()));
                }
            }), writePackageFile.1.5.INSTANCE, (Function1)new Function1<PackageRef, String>(ref){
                final /* synthetic */ PackageRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull PackageRef it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.pageUrlRelativeTo(this.$ref);
                }
            }, writePackageFile.1.7.INSTANCE);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeModuleFile(ModuleRef ref) {
        Path path2 = this.outputDir.resolve("data/" + UtilKt.getPathEncoded(ref.getPkg()) + "/" + UtilKt.getPathEncoded(ref.getVersion()) + "/" + UtilKt.getPathEncoded(ref.getModule()) + "/index.js");
        Intrinsics.checkNotNullExpressionValue(path2, "outputDir\n      .resolve\u2026ncoded}/index.js\"\n      )");
        Closeable closeable = UtilKt.jsonWriter(path2);
        Throwable throwable = null;
        try {
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl = false;
            writer.setLenient(true);
            this.writeLinks(writer, "known-versions", CollectionsKt.sortedWith(this.moduleVersions.getOrDefault(ref.getId(), SetsKt.emptySet()), this.descendingVersionComparator), writeModuleFile.1.1.INSTANCE, (Function1)new Function1<String, String>(ref){
                final /* synthetic */ ModuleRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it, this.$ref.getVersion()) ? null : ModuleRef.copy$default(this.$ref, null, null, it, null, 11, null).pageUrlRelativeTo(this.$ref);
                }
            }, (Function1)new Function1<String, String>(ref){
                final /* synthetic */ ModuleRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it, this.$ref.getVersion()) ? "current-version" : null;
                }
            });
            Iterable $this$sortedBy$iv = this.typesWithHighestVersions(this.typeUsages.getOrDefault(ref.getModuleClassRef(), SetsKt.emptySet()));
            boolean $i$f$sortedBy = false;
            this.writeLinks(writer, "known-usages", CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    TypeRef it = (TypeRef)a2;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getDisplayName());
                    it = (TypeRef)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getDisplayName()));
                }
            }), writeModuleFile.1.5.INSTANCE, (Function1)new Function1<TypeRef, String>(ref){
                final /* synthetic */ ModuleRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull TypeRef it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.pageUrlRelativeTo(this.$ref);
                }
            }, writeModuleFile.1.7.INSTANCE);
            $this$sortedBy$iv = this.typesWithHighestVersions(this.subtypes.getOrDefault(ref.getModuleClassRef(), SetsKt.emptySet()));
            $i$f$sortedBy = false;
            this.writeLinks(writer, "known-subtypes", CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    TypeRef it = (TypeRef)a2;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getDisplayName());
                    it = (TypeRef)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getDisplayName()));
                }
            }), writeModuleFile.1.9.INSTANCE, (Function1)new Function1<TypeRef, String>(ref){
                final /* synthetic */ ModuleRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull TypeRef it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.pageUrlRelativeTo(this.$ref);
                }
            }, writeModuleFile.1.11.INSTANCE);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void writeClassFile(TypeRef ref) {
        Path path2 = this.outputDir.resolve("data/" + UtilKt.getPathEncoded(ref.getPkg()) + "/" + UtilKt.getPathEncoded(ref.getVersion()) + "/" + UtilKt.getPathEncoded(ref.getModule()) + "/" + UtilKt.getPathEncoded(ref.getType()) + ".js");
        Intrinsics.checkNotNullExpressionValue(path2, "outputDir\n      .resolve\u2026.pathEncoded}.js\"\n      )");
        Closeable closeable = UtilKt.jsonWriter(path2);
        Throwable throwable = null;
        try {
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl = false;
            writer.setLenient(true);
            this.writeLinks(writer, "known-versions", CollectionsKt.sortedWith(this.classVersions.getOrDefault(ref.getId(), SetsKt.emptySet()), this.descendingVersionComparator), writeClassFile.1.1.INSTANCE, (Function1)new Function1<String, String>(ref){
                final /* synthetic */ TypeRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it, this.$ref.getVersion()) ? null : TypeRef.copy$default(this.$ref, null, null, it, null, null, false, 59, null).pageUrlRelativeTo(this.$ref);
                }
            }, (Function1)new Function1<String, String>(ref){
                final /* synthetic */ TypeRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull String it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return Intrinsics.areEqual(it, this.$ref.getVersion()) ? "current-version" : null;
                }
            });
            Iterable $this$sortedBy$iv = this.typesWithHighestVersions(this.typeUsages.getOrDefault(ref, SetsKt.emptySet()));
            boolean $i$f$sortedBy = false;
            this.writeLinks(writer, "known-usages", CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    TypeRef it = (TypeRef)a2;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getDisplayName());
                    it = (TypeRef)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getDisplayName()));
                }
            }), writeClassFile.1.5.INSTANCE, (Function1)new Function1<TypeRef, String>(ref){
                final /* synthetic */ TypeRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull TypeRef it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.pageUrlRelativeTo(this.$ref);
                }
            }, writeClassFile.1.7.INSTANCE);
            $this$sortedBy$iv = this.typesWithHighestVersions(this.subtypes.getOrDefault(ref, SetsKt.emptySet()));
            $i$f$sortedBy = false;
            this.writeLinks(writer, "known-subtypes", CollectionsKt.sortedWith($this$sortedBy$iv, new Comparator(){

                public final int compare(T a2, T b2) {
                    TypeRef it = (TypeRef)a2;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getDisplayName());
                    it = (TypeRef)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues(comparable2, (Comparable)((Object)it.getDisplayName()));
                }
            }), writeClassFile.1.9.INSTANCE, (Function1)new Function1<TypeRef, String>(ref){
                final /* synthetic */ TypeRef $ref;
                {
                    this.$ref = $ref;
                    super(1);
                }

                @Nullable
                public final String invoke(@NotNull TypeRef it) {
                    Intrinsics.checkNotNullParameter(it, "it");
                    return it.pageUrlRelativeTo(this.$ref);
                }
            }, writeClassFile.1.11.INSTANCE);
            Unit unit2 = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    private final <T> void writeLinks(JsonWriter $this$writeLinks, String id2, List<? extends T> items, Function1<? super T, String> text, Function1<? super T, String> href, Function1<? super T, String> classes2) {
        if (items.isEmpty()) {
            return;
        }
        $this$writeLinks.rawText("runtimeData.links('");
        $this$writeLinks.rawText(id2);
        $this$writeLinks.rawText("','");
        JsonWriter $this$array$iv = $this$writeLinks;
        boolean $i$f$array = false;
        $this$array$iv.beginArray();
        JsonWriter $this$writeLinks_u24lambda_u2d9 = $this$array$iv;
        boolean bl = false;
        for (T item : items) {
            JsonWriter $this$obj$iv = $this$writeLinks_u24lambda_u2d9;
            boolean $i$f$obj = false;
            $this$obj$iv.beginObject();
            JsonWriter $this$writeLinks_u24lambda_u2d9_u24lambda_u2d8 = $this$obj$iv;
            boolean bl2 = false;
            $this$writeLinks_u24lambda_u2d9_u24lambda_u2d8.name("text").value(text.invoke(item));
            $this$writeLinks_u24lambda_u2d9_u24lambda_u2d8.name("href").value(href.invoke(item));
            $this$writeLinks_u24lambda_u2d9_u24lambda_u2d8.name("classes").value(classes2.invoke(item));
            $this$obj$iv.endObject();
        }
        $this$array$iv.endArray();
        $this$writeLinks.rawText("');\n");
    }

    private final Collection<PackageRef> packagesWithHighestVersions(Set<PackageRef> $this$packagesWithHighestVersions) {
        Map highestVersions = new LinkedHashMap();
        for (PackageRef ref : $this$packagesWithHighestVersions) {
            PackageRef prev = (PackageRef)highestVersions.get(ref.getPkg());
            if (prev != null && this.descendingVersionComparator.compare(prev.getVersion(), ref.getVersion()) <= 0) continue;
            highestVersions.put(ref.getPkg(), ref);
        }
        return highestVersions.values();
    }

    private final Collection<TypeRef> typesWithHighestVersions(Set<TypeRef> $this$typesWithHighestVersions) {
        Map highestVersions = new LinkedHashMap();
        for (TypeRef ref : $this$typesWithHighestVersions) {
            TypeRef prev = (TypeRef)highestVersions.get(ref.getId());
            if (prev != null && this.descendingVersionComparator.compare(prev.getVersion(), ref.getVersion()) <= 0) continue;
            highestVersions.put(ref.getId(), ref);
        }
        return highestVersions.values();
    }

    private final <K, V> void add(Map<K, Set<V>> $this$add, K key2, V value2) {
        Object[] objectArray;
        Object[] oldValue = $this$add.get(key2);
        if (oldValue == null) {
            var6_5 = new Object[]{value2};
            objectArray = SetsKt.mutableSetOf(var6_5);
        } else {
            Object[] $this$add_u24lambda_u2d10 = var6_5 = oldValue;
            boolean bl = false;
            $this$add_u24lambda_u2d10.add(value2);
            objectArray = var6_5;
        }
        Object[] newValue = objectArray;
        $this$add.put(key2, (Set<Object[]>)newValue);
    }
}

