/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.doc;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pkl.commons.PathsKt;
import org.pkl.core.Member;
import org.pkl.core.ModuleSchema;
import org.pkl.core.PClass;
import org.pkl.core.PClassInfo;
import org.pkl.core.PObject;
import org.pkl.core.PType;
import org.pkl.core.TypeAlias;
import org.pkl.core.util.json.JsonWriter;
import org.pkl.doc.DocModule;
import org.pkl.doc.DocPackage;
import org.pkl.doc.ModuleData;
import org.pkl.doc.PackageData;
import org.pkl.doc.UtilKt;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.io.CloseableKt;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.text.Charsets;
import org.pkl.thirdparty.kotlin.text.StringsKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0013\u001a\u00020\u0006*\u00060\u0014j\u0002`\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0016\u0010\u0018\u001a\u00020\u0019*\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/pkl/doc/SearchIndexGenerator;", "", "outputDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "generate", "", "docPackage", "Lorg/pkl/doc/DocPackage;", "generateSiteIndex", "packagesData", "", "Lorg/pkl/doc/PackageData;", "renderSignature", "", "method", "Lorg/pkl/core/PClass$Method;", "property", "Lorg/pkl/core/PClass$Property;", "appendType", "Ljava/lang/StringBuilder;", "Lorg/pkl/thirdparty/kotlin/text/StringBuilder;", "type", "Lorg/pkl/core/PType;", "writeAnnotations", "Lorg/pkl/core/util/json/JsonWriter;", "member", "Lorg/pkl/core/Member;", "pkl-doc"})
public final class SearchIndexGenerator {
    @NotNull
    private final Path outputDir;

    public SearchIndexGenerator(@NotNull Path outputDir) {
        Intrinsics.checkNotNullParameter(outputDir, "outputDir");
        this.outputDir = outputDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generateSiteIndex(@NotNull List<PackageData> packagesData) {
        Intrinsics.checkNotNullParameter(packagesData, "packagesData");
        Path path2 = this.outputDir.resolve("search-index.js");
        Intrinsics.checkNotNullExpressionValue(path2, "outputDir.resolve(\"search-index.js\")");
        Path path3 = PathsKt.createParentDirectories(path2, new FileAttribute[0]);
        Closeable closeable = UtilKt.jsonWriter(path3);
        Throwable throwable = null;
        try {
            JsonWriter jsonWriter;
            JsonWriter writer = (JsonWriter)closeable;
            boolean bl = false;
            JsonWriter $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3 = jsonWriter = writer;
            boolean bl2 = false;
            $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3.rawText("searchData='");
            JsonWriter $this$array$iv = $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3;
            boolean $i$f$array = false;
            $this$array$iv.beginArray();
            JsonWriter $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = $this$array$iv;
            boolean bl3 = false;
            for (PackageData pkg : packagesData) {
                String pkgPath = pkg.getRef().getPkg() + "/current";
                JsonWriter $this$obj$iv = $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2;
                boolean $i$f$obj = false;
                $this$obj$iv.beginObject();
                JsonWriter $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0 = $this$obj$iv;
                boolean bl4 = false;
                $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.name("name").value(pkg.getRef().getPkg());
                $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.name("kind").value(0L);
                $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.name("url").value(pkgPath + "/index.html");
                if (pkg.getDeprecation() != null) {
                    $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d0.name("deprecated").value(true);
                }
                $this$obj$iv.endObject();
                for (ModuleData module : pkg.getModules()) {
                    JsonWriter $this$obj$iv2 = $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2;
                    boolean $i$f$obj2 = false;
                    $this$obj$iv2.beginObject();
                    JsonWriter $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1 = $this$obj$iv2;
                    boolean bl5 = false;
                    $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.name("name").value(module.getRef().getFullName());
                    $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.name("kind").value(1L);
                    $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.name("url").value(pkgPath + "/" + module.getRef().getModule() + "/index.html");
                    if (module.getDeprecation() != null) {
                        $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2_u24lambda_u2d1.name("deprecated").value(true);
                    }
                    $this$obj$iv2.endObject();
                }
            }
            $this$array$iv.endArray();
            $this$generateSiteIndex_u24lambda_u2d4_u24lambda_u2d3.rawText("';\n");
            JsonWriter jsonWriter2 = jsonWriter;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void generate(@NotNull DocPackage docPackage) {
        Intrinsics.checkNotNullParameter(docPackage, "docPackage");
        Path path2 = this.outputDir.resolve(UtilKt.getPathEncoded(docPackage.getName()) + "/" + docPackage.getVersion() + "/search-index.js");
        Intrinsics.checkNotNullExpressionValue(path2, "outputDir\n        .resol\u2026ersion}/search-index.js\")");
        Path path3 = PathsKt.createParentDirectories(path2, new FileAttribute[0]);
        Object object = path3;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Object object2 = Charsets.UTF_8;
        int n = 8192;
        object = new JsonWriter(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), (Charset)object2), n));
        object2 = null;
        try {
            JsonWriter jsonWriter;
            JsonWriter writer = (JsonWriter)object;
            boolean bl = false;
            JsonWriter $this$generate_u24lambda_u2d14_u24lambda_u2d13 = jsonWriter = writer;
            boolean bl2 = false;
            $this$generate_u24lambda_u2d14_u24lambda_u2d13.setSerializeNulls(false);
            $this$generate_u24lambda_u2d14_u24lambda_u2d13.rawText("searchData='");
            int nextId = 0;
            JsonWriter $this$array$iv = $this$generate_u24lambda_u2d14_u24lambda_u2d13;
            boolean $i$f$array = false;
            $this$array$iv.beginArray();
            JsonWriter $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12 = $this$array$iv;
            boolean bl3 = false;
            for (DocModule docModule : docPackage.getDocModules()) {
                boolean $i$f$obj;
                JsonWriter $this$obj$iv;
                if (docModule.isUnlisted()) continue;
                ModuleSchema module = docModule.getSchema();
                int moduleId = nextId++;
                JsonWriter $this$obj$iv2 = $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12;
                boolean bl4 = false;
                $this$obj$iv2.beginObject();
                JsonWriter $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d5 = $this$obj$iv2;
                boolean bl42 = false;
                $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d5.name("name").value(module.getModuleName());
                $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d5.name("kind").value(1L);
                $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d5.name("url").value(docModule.getPath() + "/index.html");
                this.writeAnnotations($this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d5, module.getModuleClass());
                $this$obj$iv2.endObject();
                Map<String, PClass.Property> map2 = module.getModuleClass().getProperties();
                Intrinsics.checkNotNullExpressionValue(map2, "module.moduleClass.properties");
                for (Map.Entry<String, PClass.Property> entry : map2.entrySet()) {
                    String propertyName = entry.getKey();
                    PClass.Property property = entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(property, "property");
                    if (UtilKt.isUnlisted(property)) continue;
                    ++nextId;
                    $this$obj$iv = $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12;
                    $i$f$obj = false;
                    $this$obj$iv.beginObject();
                    JsonWriter jsonWriter2 = $this$obj$iv;
                    boolean bl5 = false;
                    jsonWriter2.name("name").value(propertyName);
                    jsonWriter2.name("kind").value(5L);
                    jsonWriter2.name("url").value(docModule.getPath() + "/index.html#" + propertyName);
                    jsonWriter2.name("sig").value(this.renderSignature(property));
                    jsonWriter2.name("parId").value((Number)moduleId);
                    this.writeAnnotations(jsonWriter2, property);
                    $this$obj$iv.endObject();
                }
                Map<String, PClass.Method> map3 = module.getModuleClass().getMethods();
                Intrinsics.checkNotNullExpressionValue(map3, "module.moduleClass.methods");
                for (Map.Entry<String, PClass.ClassMember> entry : map3.entrySet()) {
                    String methodName = entry.getKey();
                    PClass.Method method = (PClass.Method)entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(method, "method");
                    if (UtilKt.isUnlisted(method)) continue;
                    ++nextId;
                    $this$obj$iv = $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12;
                    $i$f$obj = false;
                    $this$obj$iv.beginObject();
                    JsonWriter jsonWriter3 = $this$obj$iv;
                    boolean bl6 = false;
                    jsonWriter3.name("name").value(methodName);
                    jsonWriter3.name("kind").value(4L);
                    jsonWriter3.name("url").value(docModule.getPath() + "/index.html#" + methodName + "()");
                    jsonWriter3.name("sig").value(this.renderSignature(method));
                    jsonWriter3.name("parId").value((Number)moduleId);
                    this.writeAnnotations(jsonWriter3, method);
                    $this$obj$iv.endObject();
                }
                Map<String, PClass> map4 = module.getClasses();
                Intrinsics.checkNotNullExpressionValue(map4, "module.classes");
                for (Map.Entry<String, Member> entry : map4.entrySet()) {
                    String className = entry.getKey();
                    PClass clazz = (PClass)entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(clazz, "clazz");
                    if (UtilKt.isUnlisted(clazz)) continue;
                    int classId = nextId++;
                    Iterator<Map.Entry<String, PClass.Method>> $this$obj$iv4 = $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12;
                    boolean bl5 = false;
                    ((JsonWriter)((Object)$this$obj$iv4)).beginObject();
                    JsonWriter $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d8 = $this$obj$iv4;
                    boolean bl7 = false;
                    $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d8.name("name").value(className);
                    $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d8.name("kind").value(3L);
                    $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d8.name("url").value(docModule.getPath() + "/" + className + ".html");
                    $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d8.name("parId").value((Number)moduleId);
                    this.writeAnnotations($this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d8, clazz);
                    ((JsonWriter)((Object)$this$obj$iv4)).endObject();
                    Map<String, PClass.Property> map5 = clazz.getProperties();
                    Intrinsics.checkNotNullExpressionValue(map5, "clazz.properties");
                    for (Map.Entry entry2 : map5.entrySet()) {
                        String propertyName = (String)entry2.getKey();
                        PClass.Property property = (PClass.Property)entry2.getValue();
                        Intrinsics.checkNotNullExpressionValue(property, "property");
                        if (UtilKt.isUnlisted(property)) continue;
                        ++nextId;
                        JsonWriter $this$obj$iv3 = $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12;
                        boolean $i$f$obj3 = false;
                        $this$obj$iv3.beginObject();
                        JsonWriter $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d9 = $this$obj$iv3;
                        boolean bl8 = false;
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d9.name("name").value(propertyName);
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d9.name("kind").value(5L);
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d9.name("url").value(docModule.getPath() + "/" + className + ".html#" + propertyName);
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d9.name("sig").value(this.renderSignature(property));
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d9.name("parId").value((Number)classId);
                        this.writeAnnotations($this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d9, property);
                        $this$obj$iv3.endObject();
                    }
                    Map<String, PClass.Method> map6 = clazz.getMethods();
                    Intrinsics.checkNotNullExpressionValue(map6, "clazz.methods");
                    for (Map.Entry<String, PClass.Method> entry3 : map6.entrySet()) {
                        String methodName = entry3.getKey();
                        PClass.Method method = entry3.getValue();
                        Intrinsics.checkNotNullExpressionValue(method, "method");
                        if (UtilKt.isUnlisted(method)) continue;
                        ++nextId;
                        JsonWriter $this$obj$iv3 = $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12;
                        boolean $i$f$obj2 = false;
                        $this$obj$iv3.beginObject();
                        JsonWriter $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d10 = $this$obj$iv3;
                        boolean bl9 = false;
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d10.name("name").value(methodName);
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d10.name("kind").value(4L);
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d10.name("url").value(docModule.getPath() + "/" + className + ".html#" + methodName + "()");
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d10.name("sig").value(this.renderSignature(method));
                        $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d10.name("parId").value((Number)classId);
                        this.writeAnnotations($this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12_u24lambda_u2d10, method);
                        $this$obj$iv3.endObject();
                    }
                }
                Map<String, TypeAlias> map7 = module.getTypeAliases();
                Intrinsics.checkNotNullExpressionValue(map7, "module.typeAliases");
                for (Map.Entry<String, Member> entry : map7.entrySet()) {
                    String typeAliasName = entry.getKey();
                    TypeAlias typeAlias = (TypeAlias)entry.getValue();
                    Intrinsics.checkNotNullExpressionValue(typeAlias, "typeAlias");
                    if (UtilKt.isUnlisted(typeAlias)) continue;
                    ++nextId;
                    JsonWriter $this$obj$iv5 = $this$generate_u24lambda_u2d14_u24lambda_u2d13_u24lambda_u2d12;
                    boolean $i$f$obj5 = false;
                    $this$obj$iv5.beginObject();
                    JsonWriter jsonWriter4 = $this$obj$iv5;
                    boolean bl10 = false;
                    jsonWriter4.name("name").value(typeAliasName);
                    jsonWriter4.name("kind").value(2L);
                    jsonWriter4.name("url").value(docModule.getPath() + "/index.html#" + typeAliasName);
                    jsonWriter4.name("parId").value((Number)moduleId);
                    this.writeAnnotations(jsonWriter4, typeAlias);
                    $this$obj$iv5.endObject();
                }
            }
            $this$array$iv.endArray();
            $this$generate_u24lambda_u2d14_u24lambda_u2d13.rawText("';\n");
            JsonWriter jsonWriter2 = jsonWriter;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
    }

    private final String renderSignature(PClass.Method method) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderSignature_u24lambda_u2d15 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderSignature_u24lambda_u2d15.append('(');
        boolean first2 = true;
        Map<String, PType> map2 = method.getParameters();
        Intrinsics.checkNotNullExpressionValue(map2, "method.parameters");
        Iterator<Map.Entry<String, PType>> iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            String name = iterator2.next().getKey();
            if (first2) {
                first2 = false;
            } else {
                $this$renderSignature_u24lambda_u2d15.append(", ");
            }
            $this$renderSignature_u24lambda_u2d15.append(name);
        }
        $this$renderSignature_u24lambda_u2d15.append(')');
        $this$renderSignature_u24lambda_u2d15.append(": ");
        PType pType = method.getReturnType();
        Intrinsics.checkNotNullExpressionValue(pType, "method.returnType");
        this.appendType($this$renderSignature_u24lambda_u2d15, pType);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder()\n      .a\u2026      }\n      .toString()");
        return string;
    }

    private final String renderSignature(PClass.Property property) {
        StringBuilder stringBuilder;
        StringBuilder $this$renderSignature_u24lambda_u2d16 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$renderSignature_u24lambda_u2d16.append(": ");
        PType pType = property.getType();
        Intrinsics.checkNotNullExpressionValue(pType, "property.type");
        this.appendType($this$renderSignature_u24lambda_u2d16, pType);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder()\n      .a\u2026      }\n      .toString()");
        return string;
    }

    private final void appendType(StringBuilder $this$appendType, PType type2) {
        PType pType = type2;
        if (Intrinsics.areEqual(pType, PType.UNKNOWN)) {
            $this$appendType.append("unknown");
        } else if (Intrinsics.areEqual(pType, PType.NOTHING)) {
            $this$appendType.append("nothing");
        } else if (Intrinsics.areEqual(pType, PType.MODULE)) {
            $this$appendType.append("module");
        } else if (pType instanceof PType.StringLiteral) {
            $this$appendType.append("\\\"" + ((PType.StringLiteral)type2).getLiteral() + "\\\"");
        } else if (pType instanceof PType.Class) {
            String string;
            PClass pClass = ((PType.Class)type2).getPClass();
            Intrinsics.checkNotNullExpressionValue(pClass, "type.pClass");
            PClass pClass2 = pClass;
            if (pClass2.isModuleClass()) {
                String string2 = pClass2.getModuleName();
                Intrinsics.checkNotNullExpressionValue(string2, "pClass.moduleName");
                String string3 = string2;
                String string4 = pClass2.getModuleName();
                Intrinsics.checkNotNullExpressionValue(string4, "pClass.moduleName");
                int n = StringsKt.lastIndexOf$default((CharSequence)string4, '.', 0, false, 6, null) + 1;
                String string5 = string3.substring(n);
                string = string5;
                Intrinsics.checkNotNullExpressionValue(string5, "this as java.lang.String).substring(startIndex)");
            } else {
                String string6 = pClass2.getSimpleName();
                string = string6;
                Intrinsics.checkNotNullExpressionValue(string6, "{\n            pClass.simpleName\n          }");
            }
            String name = string;
            $this$appendType.append(name);
            List<PType> list = ((PType.Class)type2).getTypeArguments();
            Intrinsics.checkNotNullExpressionValue(list, "type.typeArguments");
            if (!((Collection)list).isEmpty()) {
                $this$appendType.append('<');
                boolean first2 = true;
                for (PType typeArg : ((PType.Class)type2).getTypeArguments()) {
                    if (first2) {
                        first2 = false;
                    } else {
                        $this$appendType.append(", ");
                    }
                    Intrinsics.checkNotNullExpressionValue(typeArg, "typeArg");
                    this.appendType($this$appendType, typeArg);
                }
                $this$appendType.append('>');
            }
        } else if (pType instanceof PType.Constrained) {
            PType pType2 = ((PType.Constrained)type2).getBaseType();
            Intrinsics.checkNotNullExpressionValue(pType2, "type.baseType");
            this.appendType($this$appendType, pType2);
        } else if (pType instanceof PType.Union) {
            boolean first3 = true;
            for (PType elemType : ((PType.Union)type2).getElementTypes()) {
                if (first3) {
                    first3 = false;
                } else {
                    $this$appendType.append("|");
                }
                Intrinsics.checkNotNullExpressionValue(elemType, "elemType");
                this.appendType($this$appendType, elemType);
            }
        } else if (pType instanceof PType.Nullable) {
            PType pType3 = ((PType.Nullable)type2).getBaseType();
            Intrinsics.checkNotNullExpressionValue(pType3, "type.baseType");
            this.appendType($this$appendType, pType3);
            $this$appendType.append("?");
        } else if (pType instanceof PType.Function) {
            if (((PType.Function)type2).getParameterTypes().size() == 1) {
                PType pType4 = ((PType.Function)type2).getParameterTypes().get(0);
                Intrinsics.checkNotNullExpressionValue(pType4, "type.parameterTypes[0]");
                this.appendType($this$appendType, pType4);
            } else {
                $this$appendType.append('(');
                boolean first4 = true;
                for (PType paramType : ((PType.Function)type2).getParameterTypes()) {
                    if (first4) {
                        first4 = false;
                    } else {
                        $this$appendType.append(", ");
                    }
                    Intrinsics.checkNotNullExpressionValue(paramType, "paramType");
                    this.appendType($this$appendType, paramType);
                }
                $this$appendType.append(')');
            }
            $this$appendType.append(" -> ");
            PType pType5 = ((PType.Function)type2).getReturnType();
            Intrinsics.checkNotNullExpressionValue(pType5, "type.returnType");
            this.appendType($this$appendType, pType5);
        } else if (pType instanceof PType.Alias) {
            $this$appendType.append(((PType.Alias)type2).getTypeAlias().getSimpleName());
        } else if (pType instanceof PType.TypeVariable) {
            $this$appendType.append(((PType.TypeVariable)type2).getTypeParameter().getName());
        } else {
            throw new AssertionError((Object)("Unknown PType: " + type2));
        }
    }

    private final JsonWriter writeAnnotations(JsonWriter $this$writeAnnotations, Member member) {
        block9: {
            PObject pObject;
            block8: {
                PObject it;
                Object element$iv2;
                boolean bl;
                block7: {
                    if (member == null) {
                        return $this$writeAnnotations;
                    }
                    List<PObject> list = member.getAnnotations();
                    Intrinsics.checkNotNullExpressionValue(list, "member.annotations");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            it = (PObject)element$iv2;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual(it.getClassInfo(), PClassInfo.Deprecated)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (bl) {
                    $this$writeAnnotations.name("deprecated");
                    $this$writeAnnotations.value(true);
                }
                List<PObject> list = member.getAnnotations();
                Intrinsics.checkNotNullExpressionValue(list, "member.annotations");
                Iterable iterable = list;
                element$iv2 = iterable.iterator();
                while (element$iv2.hasNext()) {
                    PObject it2 = it = element$iv2.next();
                    boolean bl3 = false;
                    if (!Intrinsics.areEqual(it2.getClassInfo(), PClassInfo.AlsoKnownAs)) continue;
                    pObject = it;
                    break block8;
                }
                pObject = null;
            }
            PObject pObject2 = pObject;
            if (pObject2 == null) break block9;
            PObject alsoKnownAs = pObject2;
            boolean bl = false;
            $this$writeAnnotations.name("aka");
            JsonWriter $this$array$iv = $this$writeAnnotations;
            boolean $i$f$array = false;
            $this$array$iv.beginArray();
            JsonWriter $this$writeAnnotations_u24lambda_u2d20_u24lambda_u2d19 = $this$array$iv;
            boolean bl4 = false;
            Object object = alsoKnownAs.get("names");
            Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.collections.List<kotlin.String>");
            for (String name : (List)object) {
                $this$writeAnnotations_u24lambda_u2d20_u24lambda_u2d19.value(name);
            }
            $this$array$iv.endArray();
        }
        return $this$writeAnnotations;
    }
}

