/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.doc;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pkl.commons.PathsKt;
import org.pkl.core.Member;
import org.pkl.core.ModuleSchema;
import org.pkl.core.PClass;
import org.pkl.core.PClassInfo;
import org.pkl.core.PNull;
import org.pkl.core.PObject;
import org.pkl.core.TypeAlias;
import org.pkl.core.parser.Lexer;
import org.pkl.core.util.IoUtils;
import org.pkl.core.util.json.JsonWriter;
import org.pkl.doc.DocGeneratorException;
import org.pkl.doc.UtilKt;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.jetbrains.annotations.Nullable;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.Pair;
import org.pkl.thirdparty.kotlin.TuplesKt;
import org.pkl.thirdparty.kotlin.Unit;
import org.pkl.thirdparty.kotlin.collections.CollectionsKt;
import org.pkl.thirdparty.kotlin.collections.MapsKt;
import org.pkl.thirdparty.kotlin.io.ByteStreamsKt;
import org.pkl.thirdparty.kotlin.io.CloseableKt;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;
import org.pkl.thirdparty.kotlin.text.Charsets;
import org.pkl.thirdparty.kotlin.text.MatchResult;
import org.pkl.thirdparty.kotlin.text.Regex;
import org.pkl.thirdparty.kotlin.text.StringsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000d\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020-H\u0000\u001a\u0010\u0010.\u001a\u00020\u00052\u0006\u0010/\u001a\u00020\u0004H\u0000\u001a\u0014\u00100\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0014\u00102\u001a\u0004\u0018\u00010\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004H\u0000\u001a\u0016\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004\u001a\u0010\u00106\u001a\u0002072\u0006\u0010+\u001a\u00020\u0004H\u0000\u001a\u0012\u00108\u001a\u0004\u0018\u0001072\u0006\u0010+\u001a\u00020\u0004H\u0000\u001a)\u00109\u001a\u00020**\u00020:2\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020*0<\u00a2\u0006\u0002\b=H\u0080\b\u00f8\u0001\u0000\u001a\f\u0010>\u001a\u00020:*\u00020-H\u0000\u001a)\u0010?\u001a\u00020**\u00020:2\u0017\u0010;\u001a\u0013\u0012\u0004\u0012\u00020:\u0012\u0004\u0012\u00020*0<\u00a2\u0006\u0002\b=H\u0080\b\u00f8\u0001\u0000\u001a\u001c\u0010@\u001a\u00020\u0004*\u00020\u00042\u0006\u0010A\u001a\u00020\u00042\u0006\u0010B\u001a\u00020CH\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\",\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003*\b\u0012\u0004\u0012\u00020\u00050\u00038@X\u0080\u0004\u00a2\u0006\f\u0012\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\"\u0018\u0010\n\u001a\u00020\u0004*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\"\u0018\u0010\r\u001a\u00020\u0004*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\f\" \u0010\u000f\u001a\u0004\u0018\u00010\u0004*\b\u0012\u0004\u0012\u00020\u00050\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u001a\u0010\u0012\u001a\u00020\u0013*\u0004\u0018\u00010\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\"\u001a\u0010\u0017\u001a\u00020\u0013*\u0004\u0018\u00010\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\"\u001a\u0010\u001b\u001a\u00020\u0013*\u0004\u0018\u00010\u00188@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001a\"\u001a\u0010\u001d\u001a\u00020\u0013*\u0004\u0018\u00010\u00148@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u0016\"\u001e\u0010\u001f\u001a\u00020\u0013*\b\u0012\u0004\u0012\u00020\u00050\u00038@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 \"\u0018\u0010\u001f\u001a\u00020\u0013*\u00020!8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\"\"\u0018\u0010#\u001a\u00020\u0004*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b$\u0010\f\"\u0018\u0010%\u001a\u00020\u0004*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010\f\"\u0018\u0010'\u001a\u00020\u0004*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010\f\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006D"}, d2={"paragraphSeparatorRegex", "Lorg/pkl/thirdparty/kotlin/text/Regex;", "alsoKnownAs", "", "", "Lorg/pkl/core/PObject;", "getAlsoKnownAs$annotations", "(Ljava/util/List;)V", "getAlsoKnownAs", "(Ljava/util/List;)Ljava/util/List;", "asIdentifier", "getAsIdentifier", "(Ljava/lang/String;)Ljava/lang/String;", "asModuleName", "getAsModuleName", "deprecation", "getDeprecation", "(Ljava/util/List;)Ljava/lang/String;", "hasListedClass", "", "Lorg/pkl/core/ModuleSchema;", "getHasListedClass", "(Lorg/pkl/core/ModuleSchema;)Z", "hasListedMethod", "Lorg/pkl/core/PClass;", "getHasListedMethod", "(Lorg/pkl/core/PClass;)Z", "hasListedProperty", "getHasListedProperty", "hasListedTypeAlias", "getHasListedTypeAlias", "isUnlisted", "(Ljava/util/List;)Z", "Lorg/pkl/core/Member;", "(Lorg/pkl/core/Member;)Z", "pathEncoded", "getPathEncoded", "uriEncoded", "getUriEncoded", "uriEncodedComponent", "getUriEncodedComponent", "copyResource", "", "resourceName", "targetDir", "Ljava/nio/file/Path;", "createDeprecatedAnnotation", "message", "getDocCommentOverflow", "docComment", "getDocCommentSummary", "getModulePath", "moduleName", "packagePrefix", "getResourceAsStream", "Ljava/io/InputStream;", "getResourceAsStreamOrNull", "array", "Lorg/pkl/core/util/json/JsonWriter;", "body", "Lorg/pkl/thirdparty/kotlin/Function1;", "Lorg/pkl/thirdparty/kotlin/ExtensionFunctionType;", "jsonWriter", "obj", "replaceSourceCodePlaceholders", "path", "sourceLocation", "Lorg/pkl/core/Member$SourceLocation;", "pkl-doc"})
public final class UtilKt {
    @NotNull
    private static final Regex paragraphSeparatorRegex = new Regex("(?m:^\\s*(`{3,}\\w*)?\\s*\n)");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyResource(@NotNull String resourceName, @NotNull Path targetDir) {
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        Intrinsics.checkNotNullParameter(targetDir, "targetDir");
        Object object = targetDir.resolve(resourceName);
        Path $this$copyResource_u24lambda_u2d0 = object;
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue($this$copyResource_u24lambda_u2d0, "");
        PathsKt.createParentDirectories($this$copyResource_u24lambda_u2d0, new FileAttribute[0]);
        Path targetFile = object;
        object = UtilKt.getResourceAsStream(resourceName);
        Throwable throwable = null;
        try {
            long l;
            InputStream sourceStream = (InputStream)object;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue(targetFile, "targetFile");
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream2 = Files.newOutputStream(targetFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue(outputStream2, "newOutputStream(this, *options)");
            Closeable closeable = outputStream2;
            Throwable throwable2 = null;
            try {
                OutputStream targetStream = (OutputStream)closeable;
                boolean bl3 = false;
                l = ByteStreamsKt.copyTo$default(sourceStream, targetStream, 0, 2, null);
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable2);
            }
            long l2 = l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
    }

    @Nullable
    public static final InputStream getResourceAsStreamOrNull(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        return Thread.currentThread().getContextClassLoader().getResourceAsStream("org/pkl/doc/" + resourceName);
    }

    @NotNull
    public static final InputStream getResourceAsStream(@NotNull String resourceName) {
        Intrinsics.checkNotNullParameter(resourceName, "resourceName");
        InputStream inputStream2 = UtilKt.getResourceAsStreamOrNull(resourceName);
        if (inputStream2 == null) {
            throw new DocGeneratorException("Failed to load class path resource `" + resourceName + "`.", null, 2, null);
        }
        return inputStream2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasListedClass(@Nullable ModuleSchema $this$hasListedClass) {
        boolean bl;
        if ($this$hasListedClass == null) return false;
        Map<String, PClass> map2 = $this$hasListedClass.getAllClasses();
        Intrinsics.checkNotNullExpressionValue(map2, "allClasses");
        Map<String, PClass> $this$any$iv = map2;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<String, PClass>> iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<String, PClass> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<String, PClass> it = element$iv = iterator2.next();
            boolean bl2 = false;
            PClass pClass = it.getValue();
            Intrinsics.checkNotNullExpressionValue(pClass, "it.value");
            if (!UtilKt.isUnlisted(pClass)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasListedTypeAlias(@Nullable ModuleSchema $this$hasListedTypeAlias) {
        boolean bl;
        if ($this$hasListedTypeAlias == null) return false;
        Map<String, TypeAlias> map2 = $this$hasListedTypeAlias.getAllTypeAliases();
        Intrinsics.checkNotNullExpressionValue(map2, "allTypeAliases");
        Map<String, TypeAlias> $this$any$iv = map2;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<String, TypeAlias>> iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<String, TypeAlias> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<String, TypeAlias> it = element$iv = iterator2.next();
            boolean bl2 = false;
            TypeAlias typeAlias = it.getValue();
            Intrinsics.checkNotNullExpressionValue(typeAlias, "it.value");
            if (!UtilKt.isUnlisted(typeAlias)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasListedProperty(@Nullable PClass $this$hasListedProperty) {
        boolean bl;
        if ($this$hasListedProperty == null) return false;
        Map<String, PClass.Property> map2 = $this$hasListedProperty.getAllProperties();
        Intrinsics.checkNotNullExpressionValue(map2, "allProperties");
        Map<String, PClass.Property> $this$any$iv = map2;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<String, PClass.Property>> iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<String, PClass.Property> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<String, PClass.Property> it = element$iv = iterator2.next();
            boolean bl2 = false;
            PClass.Property property = it.getValue();
            Intrinsics.checkNotNullExpressionValue(property, "it.value");
            if (!UtilKt.isUnlisted(property)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean getHasListedMethod(@Nullable PClass $this$hasListedMethod) {
        boolean bl;
        if ($this$hasListedMethod == null) return false;
        Map<String, PClass.Method> map2 = $this$hasListedMethod.getAllMethods();
        Intrinsics.checkNotNullExpressionValue(map2, "allMethods");
        Map<String, PClass.Method> $this$any$iv = map2;
        boolean $i$f$any = false;
        if ($this$any$iv.isEmpty()) {
            return false;
        }
        Iterator<Map.Entry<String, PClass.Method>> iterator2 = $this$any$iv.entrySet().iterator();
        do {
            Map.Entry<String, PClass.Method> element$iv;
            if (!iterator2.hasNext()) return false;
            Map.Entry<String, PClass.Method> it = element$iv = iterator2.next();
            boolean bl2 = false;
            PClass.Method method = it.getValue();
            Intrinsics.checkNotNullExpressionValue(method, "it.value");
            if (!UtilKt.isUnlisted(method)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    public static final boolean isUnlisted(@NotNull Member $this$isUnlisted) {
        Intrinsics.checkNotNullParameter($this$isUnlisted, "<this>");
        List<PObject> list = $this$isUnlisted.getAnnotations();
        Intrinsics.checkNotNullExpressionValue(list, "annotations");
        return UtilKt.isUnlisted(list);
    }

    public static final boolean isUnlisted(@NotNull List<? extends PObject> $this$isUnlisted) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter($this$isUnlisted, "<this>");
            Iterable $this$any$iv = $this$isUnlisted;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    PObject it = (PObject)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual(it.getClassInfo(), PClassInfo.Unlisted)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Nullable
    public static final String getDeprecation(@NotNull List<? extends PObject> $this$deprecation) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$deprecation, "<this>");
            Iterable iterable = $this$deprecation;
            for (Object t : iterable) {
                PObject it = (PObject)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getClassInfo(), PClassInfo.Deprecated)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        PObject pObject = v0;
        return (String)(pObject != null ? pObject.get("message") : null);
    }

    @Nullable
    public static final List<String> getAlsoKnownAs(@NotNull List<? extends PObject> $this$alsoKnownAs) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter($this$alsoKnownAs, "<this>");
            Iterable iterable = $this$alsoKnownAs;
            for (Object t : iterable) {
                PObject it = (PObject)t;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getClassInfo(), PClassInfo.AlsoKnownAs)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        PObject pObject = v0;
        return (List)(pObject != null ? pObject.get("names") : null);
    }

    public static /* synthetic */ void getAlsoKnownAs$annotations(List list) {
    }

    @NotNull
    public static final PObject createDeprecatedAnnotation(@NotNull String message) {
        Intrinsics.checkNotNullParameter(message, "message");
        Pair[] pairArray = new Pair[]{TuplesKt.to("message", message), TuplesKt.to("replaceWith", PNull.getInstance())};
        return new PObject(PClassInfo.Deprecated, MapsKt.mapOf(pairArray));
    }

    @Nullable
    public static final String getDocCommentSummary(@Nullable String docComment) {
        String string;
        if (docComment == null) {
            return null;
        }
        MatchResult match = Regex.find$default(paragraphSeparatorRegex, docComment, 0, 2, null);
        if (match == null) {
            CharSequence charSequence;
            CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)docComment)).toString();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        } else {
            CharSequence charSequence;
            String string2 = docComment.substring(0, match.getRange().getFirst());
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String\u2026ing(startIndex, endIndex)");
            CharSequence charSequence3 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (charSequence3.length() == 0) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence3;
            }
            string = (String)charSequence;
        }
        return string;
    }

    @Nullable
    public static final String getDocCommentOverflow(@Nullable String docComment) {
        String string;
        if (docComment == null) {
            return null;
        }
        MatchResult match = Regex.find$default(paragraphSeparatorRegex, docComment, 0, 2, null);
        if (match != null) {
            CharSequence charSequence;
            int index = match.getGroups().get(1) != null ? match.getRange().getFirst() : match.getRange().getLast() + 1;
            String string2 = docComment.substring(index);
            Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).substring(startIndex)");
            CharSequence charSequence2 = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            if (charSequence2.length() == 0) {
                boolean bl = false;
                charSequence = null;
            } else {
                charSequence = charSequence2;
            }
            string = (String)charSequence;
        } else {
            string = null;
        }
        return string;
    }

    @NotNull
    public static final JsonWriter jsonWriter(@NotNull Path $this$jsonWriter) {
        Intrinsics.checkNotNullParameter($this$jsonWriter, "<this>");
        PathsKt.createParentDirectories($this$jsonWriter, new FileAttribute[0]);
        Object object = $this$jsonWriter;
        OpenOption[] openOptionArray = new OpenOption[]{};
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        Object $this$jsonWriter_u24lambda_u2d13 = object = new JsonWriter(new BufferedWriter(new OutputStreamWriter(Files.newOutputStream((Path)object, Arrays.copyOf(openOptionArray, openOptionArray.length)), charset), n));
        boolean bl = false;
        ((JsonWriter)$this$jsonWriter_u24lambda_u2d13).setSerializeNulls(false);
        return object;
    }

    public static final void obj(@NotNull JsonWriter $this$obj, @NotNull Function1<? super JsonWriter, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$obj, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$obj = false;
        $this$obj.beginObject();
        body2.invoke($this$obj);
        $this$obj.endObject();
    }

    public static final void array(@NotNull JsonWriter $this$array, @NotNull Function1<? super JsonWriter, Unit> body2) {
        Intrinsics.checkNotNullParameter($this$array, "<this>");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$array = false;
        $this$array.beginArray();
        body2.invoke($this$array);
        $this$array.endArray();
    }

    @NotNull
    public static final String replaceSourceCodePlaceholders(@NotNull String $this$replaceSourceCodePlaceholders, @NotNull String path2, @NotNull Member.SourceLocation sourceLocation) {
        Intrinsics.checkNotNullParameter($this$replaceSourceCodePlaceholders, "<this>");
        Intrinsics.checkNotNullParameter(path2, "path");
        Intrinsics.checkNotNullParameter(sourceLocation, "sourceLocation");
        return StringsKt.replace$default(StringsKt.replace$default(StringsKt.replace$default($this$replaceSourceCodePlaceholders, "%{path}", path2, false, 4, null), "%{line}", String.valueOf(sourceLocation.getStartLine()), false, 4, null), "%{endLine}", String.valueOf(sourceLocation.getEndLine()), false, 4, null);
    }

    @NotNull
    public static final String getUriEncodedComponent(@NotNull String $this$uriEncodedComponent) {
        Intrinsics.checkNotNullParameter($this$uriEncodedComponent, "<this>");
        URI ret = new URI(null, null, $this$uriEncodedComponent, null);
        String string = ret.toString();
        Intrinsics.checkNotNullExpressionValue(string, "ret.toString()");
        return StringsKt.replace$default(string, "/", "%2F", false, 4, null);
    }

    @NotNull
    public static final String getUriEncoded(@NotNull String $this$uriEncoded) {
        Intrinsics.checkNotNullParameter($this$uriEncoded, "<this>");
        CharSequence charSequence = $this$uriEncoded;
        Regex regex = new Regex("([^;/?:@&=+$,#]+)");
        Function1 function1 = uriEncoded.1.INSTANCE;
        return regex.replace(charSequence, function1);
    }

    @NotNull
    public static final String getModulePath(@NotNull String moduleName, @NotNull String packagePrefix) {
        Intrinsics.checkNotNullParameter(moduleName, "moduleName");
        Intrinsics.checkNotNullParameter(packagePrefix, "packagePrefix");
        String string = moduleName.substring(packagePrefix.length());
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).substring(startIndex)");
        return StringsKt.replace$default(string, '.', '/', false, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getAsModuleName(@NotNull String $this$asModuleName) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$asModuleName, "<this>");
        String[] stringArray = new String[]{"."};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)$this$asModuleName, stringArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Lexer.maybeQuoteIdentifier((String)p0));
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, ".", null, null, 0, null, asModuleName.2.INSTANCE, 30, null);
    }

    @NotNull
    public static final String getAsIdentifier(@NotNull String $this$asIdentifier) {
        Intrinsics.checkNotNullParameter($this$asIdentifier, "<this>");
        String string = Lexer.maybeQuoteIdentifier($this$asIdentifier);
        Intrinsics.checkNotNullExpressionValue(string, "maybeQuoteIdentifier(this)");
        return string;
    }

    @NotNull
    public static final String getPathEncoded(@NotNull String $this$pathEncoded) {
        Intrinsics.checkNotNullParameter($this$pathEncoded, "<this>");
        String string = IoUtils.encodePath($this$pathEncoded);
        Intrinsics.checkNotNullExpressionValue(string, "encodePath(this)");
        return string;
    }
}

