/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.pkl.server.Message;
import org.pkl.server.MessageDecoder;
import org.pkl.server.MessageDecoders;
import org.pkl.server.MessageEncoder;
import org.pkl.server.MessageEncoders;
import org.pkl.server.MessageTransport;
import org.pkl.server.OneWayMessage;
import org.pkl.server.ProtocolException;
import org.pkl.server.RequestMessage;
import org.pkl.server.ResponseMessage;
import org.pkl.server.UtilsKt;
import org.pkl.thirdparty.jetbrains.annotations.NotNull;
import org.pkl.thirdparty.kotlin.Metadata;
import org.pkl.thirdparty.kotlin.Pair;
import org.pkl.thirdparty.kotlin.TuplesKt;
import org.pkl.thirdparty.kotlin.Unit;
import org.pkl.thirdparty.kotlin.jvm.functions.Function1;
import org.pkl.thirdparty.kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u000b\f\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004J\u0016\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000e"}, d2={"Lorg/pkl/server/MessageTransports;", "", "()V", "direct", "Lorg/pkl/thirdparty/kotlin/Pair;", "Lorg/pkl/server/MessageTransport;", "stream", "inputStream", "Ljava/io/InputStream;", "outputStream", "Ljava/io/OutputStream;", "AbstractMessageTransport", "DirectMessageTransport", "EncodingMessageTransport", "pkl-server"})
public final class MessageTransports {
    @NotNull
    public static final MessageTransports INSTANCE = new MessageTransports();

    private MessageTransports() {
    }

    @NotNull
    public final MessageTransport stream(@NotNull InputStream inputStream2, @NotNull OutputStream outputStream2) {
        Intrinsics.checkNotNullParameter(inputStream2, "inputStream");
        Intrinsics.checkNotNullParameter(outputStream2, "outputStream");
        return new EncodingMessageTransport(MessageDecoders.INSTANCE.from(inputStream2), MessageEncoders.INSTANCE.into(outputStream2));
    }

    @NotNull
    public final Pair<MessageTransport, MessageTransport> direct() {
        DirectMessageTransport transport1 = new DirectMessageTransport();
        DirectMessageTransport transport2 = new DirectMessageTransport();
        transport1.setOther(transport2);
        transport2.setOther(transport1);
        return TuplesKt.to(transport1, transport2);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0014J\b\u0010\u000e\u001a\u00020\nH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/pkl/server/MessageTransports$EncodingMessageTransport;", "Lorg/pkl/server/MessageTransports$AbstractMessageTransport;", "decoder", "Lorg/pkl/server/MessageDecoder;", "encoder", "Lorg/pkl/server/MessageEncoder;", "(Lorg/pkl/server/MessageDecoder;Lorg/pkl/server/MessageEncoder;)V", "isClosed", "", "doClose", "", "doSend", "message", "Lorg/pkl/server/Message;", "doStart", "pkl-server"})
    public static final class EncodingMessageTransport
    extends AbstractMessageTransport {
        @NotNull
        private final MessageDecoder decoder;
        @NotNull
        private final MessageEncoder encoder;
        private volatile boolean isClosed;

        public EncodingMessageTransport(@NotNull MessageDecoder decoder, @NotNull MessageEncoder encoder2) {
            Intrinsics.checkNotNullParameter(decoder, "decoder");
            Intrinsics.checkNotNullParameter(encoder2, "encoder");
            this.decoder = decoder;
            this.encoder = encoder2;
        }

        @Override
        protected void doStart() {
            while (!this.isClosed) {
                Message message;
                if (this.decoder.decode() == null) {
                    return;
                }
                this.accept(message);
            }
        }

        @Override
        protected void doClose() {
            this.isClosed = true;
        }

        @Override
        protected void doSend(@NotNull Message message) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.encoder.encode(message);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0014J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\b\u0010\r\u001a\u00020\tH\u0014R\u001a\u0010\u0003\u001a\u00020\u0000X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/pkl/server/MessageTransports$DirectMessageTransport;", "Lorg/pkl/server/MessageTransports$AbstractMessageTransport;", "()V", "other", "getOther", "()Lorg/pkl/server/MessageTransports$DirectMessageTransport;", "setOther", "(Lorg/pkl/server/MessageTransports$DirectMessageTransport;)V", "doClose", "", "doSend", "message", "Lorg/pkl/server/Message;", "doStart", "pkl-server"})
    public static final class DirectMessageTransport
    extends AbstractMessageTransport {
        public DirectMessageTransport other;

        @NotNull
        public final DirectMessageTransport getOther() {
            DirectMessageTransport directMessageTransport = this.other;
            if (directMessageTransport != null) {
                return directMessageTransport;
            }
            Intrinsics.throwUninitializedPropertyAccessException("other");
            return null;
        }

        public final void setOther(@NotNull DirectMessageTransport directMessageTransport) {
            Intrinsics.checkNotNullParameter(directMessageTransport, "<set-?>");
            this.other = directMessageTransport;
        }

        @Override
        protected void doStart() {
        }

        @Override
        protected void doClose() {
        }

        @Override
        protected void doSend(@NotNull Message message) {
            Intrinsics.checkNotNullParameter(message, "message");
            this.getOther().accept(message);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b \u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0004J\u0006\u0010\u0010\u001a\u00020\u0006J\b\u0010\u0011\u001a\u00020\u0006H$J\u0010\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH$J\b\u0010\u0013\u001a\u00020\u0006H$J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0005H\u0016J$\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\b2\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u0004H\u0016J\u0010\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\fH\u0016J.\u0010\u0016\u001a\u00020\u00062\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00060\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/pkl/server/MessageTransports$AbstractMessageTransport;", "Lorg/pkl/server/MessageTransport;", "()V", "oneWayHandler", "Lorg/pkl/thirdparty/kotlin/Function1;", "Lorg/pkl/server/OneWayMessage;", "", "requestHandler", "Lorg/pkl/server/RequestMessage;", "responseHandlers", "", "", "Lorg/pkl/server/ResponseMessage;", "accept", "message", "Lorg/pkl/server/Message;", "close", "doClose", "doSend", "doStart", "send", "responseHandler", "start", "pkl-server"})
    public static abstract class AbstractMessageTransport
    implements MessageTransport {
        private Function1<? super OneWayMessage, Unit> oneWayHandler;
        private Function1<? super RequestMessage, Unit> requestHandler;
        @NotNull
        private final Map<Long, Function1<ResponseMessage, Unit>> responseHandlers = new ConcurrentHashMap();

        protected abstract void doStart();

        protected abstract void doClose();

        protected abstract void doSend(@NotNull Message var1);

        protected final void accept(@NotNull Message message) {
            Intrinsics.checkNotNullParameter(message, "message");
            UtilsKt.log("Received message: " + message);
            Message message2 = message;
            if (message2 instanceof OneWayMessage) {
                Function1<? super OneWayMessage, Unit> function1 = this.oneWayHandler;
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("oneWayHandler");
                    function1 = null;
                }
                function1.invoke((OneWayMessage)message);
            } else if (message2 instanceof RequestMessage) {
                Function1<? super RequestMessage, Unit> function1 = this.requestHandler;
                if (function1 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("requestHandler");
                    function1 = null;
                }
                function1.invoke((RequestMessage)message);
            } else if (message2 instanceof ResponseMessage) {
                Function1<ResponseMessage, Unit> function1 = this.responseHandlers.remove(((ResponseMessage)message).getRequestId());
                if (function1 == null) {
                    throw new ProtocolException("Received response " + message.getClass().getSimpleName() + " for unknown request ID `" + ((ResponseMessage)message).getRequestId() + "`.", null, 2, null);
                }
                Function1<ResponseMessage, Unit> handler = function1;
                handler.invoke((ResponseMessage)message);
            }
        }

        @Override
        public final void start(@NotNull Function1<? super OneWayMessage, Unit> oneWayHandler, @NotNull Function1<? super RequestMessage, Unit> requestHandler) {
            Intrinsics.checkNotNullParameter(oneWayHandler, "oneWayHandler");
            Intrinsics.checkNotNullParameter(requestHandler, "requestHandler");
            UtilsKt.log("Starting transport: " + this);
            this.oneWayHandler = oneWayHandler;
            this.requestHandler = requestHandler;
            this.doStart();
        }

        @Override
        public final void close() {
            UtilsKt.log("Closing transport: " + this);
            this.doClose();
            this.responseHandlers.clear();
        }

        @Override
        public void send(@NotNull OneWayMessage message) {
            Intrinsics.checkNotNullParameter(message, "message");
            UtilsKt.log("Sending message: " + message);
            this.doSend(message);
        }

        @Override
        public void send(@NotNull RequestMessage message, @NotNull Function1<? super ResponseMessage, Unit> responseHandler) {
            Intrinsics.checkNotNullParameter(message, "message");
            Intrinsics.checkNotNullParameter(responseHandler, "responseHandler");
            UtilsKt.log("Sending message: " + message);
            this.responseHandlers.put(message.getRequestId(), responseHandler);
            this.doSend(message);
        }

        @Override
        public void send(@NotNull ResponseMessage message) {
            Intrinsics.checkNotNullParameter(message, "message");
            UtilsKt.log("Sending message: " + message);
            this.doSend(message);
        }
    }
}

