/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.antlr.v4.runtime;

import org.pkl.thirdparty.antlr.v4.runtime.ANTLRErrorStrategy;
import org.pkl.thirdparty.antlr.v4.runtime.FailedPredicateException;
import org.pkl.thirdparty.antlr.v4.runtime.InputMismatchException;
import org.pkl.thirdparty.antlr.v4.runtime.NoViableAltException;
import org.pkl.thirdparty.antlr.v4.runtime.Parser;
import org.pkl.thirdparty.antlr.v4.runtime.ParserRuleContext;
import org.pkl.thirdparty.antlr.v4.runtime.RecognitionException;
import org.pkl.thirdparty.antlr.v4.runtime.RuleContext;
import org.pkl.thirdparty.antlr.v4.runtime.Token;
import org.pkl.thirdparty.antlr.v4.runtime.TokenFactory;
import org.pkl.thirdparty.antlr.v4.runtime.TokenSource;
import org.pkl.thirdparty.antlr.v4.runtime.TokenStream;
import org.pkl.thirdparty.antlr.v4.runtime.atn.ATN;
import org.pkl.thirdparty.antlr.v4.runtime.atn.ATNState;
import org.pkl.thirdparty.antlr.v4.runtime.atn.ParserATNSimulator;
import org.pkl.thirdparty.antlr.v4.runtime.atn.PredictionContext;
import org.pkl.thirdparty.antlr.v4.runtime.atn.RuleTransition;
import org.pkl.thirdparty.antlr.v4.runtime.misc.IntervalSet;
import org.pkl.thirdparty.antlr.v4.runtime.misc.NotNull;
import org.pkl.thirdparty.antlr.v4.runtime.misc.Nullable;
import org.pkl.thirdparty.antlr.v4.runtime.misc.Tuple;

public class DefaultErrorStrategy
implements ANTLRErrorStrategy {
    protected boolean errorRecoveryMode = false;
    protected int lastErrorIndex = -1;
    protected IntervalSet lastErrorStates;
    protected ParserRuleContext nextTokensContext;
    protected int nextTokensState;

    @Override
    public void reset(Parser recognizer) {
        this.endErrorCondition(recognizer);
    }

    protected void beginErrorCondition(@NotNull Parser recognizer) {
        this.errorRecoveryMode = true;
    }

    @Override
    public boolean inErrorRecoveryMode(Parser recognizer) {
        return this.errorRecoveryMode;
    }

    protected void endErrorCondition(@NotNull Parser recognizer) {
        this.errorRecoveryMode = false;
        this.lastErrorStates = null;
        this.lastErrorIndex = -1;
    }

    @Override
    public void reportMatch(Parser recognizer) {
        this.endErrorCondition(recognizer);
    }

    @Override
    public void reportError(Parser recognizer, RecognitionException e2) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        if (e2 instanceof NoViableAltException) {
            this.reportNoViableAlternative(recognizer, (NoViableAltException)e2);
        } else if (e2 instanceof InputMismatchException) {
            this.reportInputMismatch(recognizer, (InputMismatchException)e2);
        } else if (e2 instanceof FailedPredicateException) {
            this.reportFailedPredicate(recognizer, (FailedPredicateException)e2);
        } else {
            System.err.println("unknown recognition error type: " + e2.getClass().getName());
            this.notifyErrorListeners(recognizer, e2.getMessage(), e2);
        }
    }

    protected void notifyErrorListeners(@NotNull Parser recognizer, String message, RecognitionException e2) {
        recognizer.notifyErrorListeners(e2.getOffendingToken(recognizer), message, e2);
    }

    @Override
    public void recover(Parser recognizer, RecognitionException e2) {
        if (this.lastErrorIndex == recognizer.getInputStream().index() && this.lastErrorStates != null && this.lastErrorStates.contains(recognizer.getState())) {
            recognizer.consume();
        }
        this.lastErrorIndex = recognizer.getInputStream().index();
        if (this.lastErrorStates == null) {
            this.lastErrorStates = new IntervalSet(new int[0]);
        }
        this.lastErrorStates.add(recognizer.getState());
        IntervalSet followSet = this.getErrorRecoverySet(recognizer);
        this.consumeUntil(recognizer, followSet);
    }

    @Override
    public void sync(Parser recognizer) throws RecognitionException {
        ATNState s2 = ((ParserATNSimulator)recognizer.getInterpreter()).atn.states.get(recognizer.getState());
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        TokenStream tokens = recognizer.getInputStream();
        int la = tokens.LA(1);
        IntervalSet nextTokens = recognizer.getATN().nextTokens(s2);
        if (nextTokens.contains(la)) {
            this.nextTokensContext = null;
            this.nextTokensState = -1;
            return;
        }
        if (nextTokens.contains(-2)) {
            if (this.nextTokensContext == null) {
                this.nextTokensContext = recognizer.getContext();
                this.nextTokensState = recognizer.getState();
            }
            return;
        }
        switch (s2.getStateType()) {
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                if (this.singleTokenDeletion(recognizer) != null) {
                    return;
                }
                throw new InputMismatchException(recognizer);
            }
            case 9: 
            case 11: {
                this.reportUnwantedToken(recognizer);
                IntervalSet expecting = recognizer.getExpectedTokens();
                IntervalSet whatFollowsLoopIterationOrRule = expecting.or(this.getErrorRecoverySet(recognizer));
                this.consumeUntil(recognizer, whatFollowsLoopIterationOrRule);
                break;
            }
        }
    }

    protected void reportNoViableAlternative(@NotNull Parser recognizer, @NotNull NoViableAltException e2) {
        TokenStream tokens = recognizer.getInputStream();
        String input2 = tokens != null ? (e2.getStartToken().getType() == -1 ? "<EOF>" : tokens.getText(e2.getStartToken(), e2.getOffendingToken())) : "<unknown input>";
        String msg = "no viable alternative at input " + this.escapeWSAndQuote(input2);
        this.notifyErrorListeners(recognizer, msg, e2);
    }

    protected void reportInputMismatch(@NotNull Parser recognizer, @NotNull InputMismatchException e2) {
        String msg = "mismatched input " + this.getTokenErrorDisplay(e2.getOffendingToken(recognizer)) + " expecting " + e2.getExpectedTokens().toString(recognizer.getVocabulary());
        this.notifyErrorListeners(recognizer, msg, e2);
    }

    protected void reportFailedPredicate(@NotNull Parser recognizer, @NotNull FailedPredicateException e2) {
        String ruleName = recognizer.getRuleNames()[recognizer._ctx.getRuleIndex()];
        String msg = "rule " + ruleName + " " + e2.getMessage();
        this.notifyErrorListeners(recognizer, msg, e2);
    }

    protected void reportUnwantedToken(@NotNull Parser recognizer) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        Token t = recognizer.getCurrentToken();
        String tokenName = this.getTokenErrorDisplay(t);
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = "extraneous input " + tokenName + " expecting " + expecting.toString(recognizer.getVocabulary());
        recognizer.notifyErrorListeners(t, msg, null);
    }

    protected void reportMissingToken(@NotNull Parser recognizer) {
        if (this.inErrorRecoveryMode(recognizer)) {
            return;
        }
        this.beginErrorCondition(recognizer);
        Token t = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        String msg = "missing " + expecting.toString(recognizer.getVocabulary()) + " at " + this.getTokenErrorDisplay(t);
        recognizer.notifyErrorListeners(t, msg, null);
    }

    @Override
    public Token recoverInline(Parser recognizer) throws RecognitionException {
        Token matchedSymbol = this.singleTokenDeletion(recognizer);
        if (matchedSymbol != null) {
            recognizer.consume();
            return matchedSymbol;
        }
        if (this.singleTokenInsertion(recognizer)) {
            return this.getMissingSymbol(recognizer);
        }
        InputMismatchException e2 = this.nextTokensContext == null ? new InputMismatchException(recognizer) : new InputMismatchException(recognizer, this.nextTokensState, this.nextTokensContext);
        throw e2;
    }

    protected boolean singleTokenInsertion(@NotNull Parser recognizer) {
        int currentSymbolType = recognizer.getInputStream().LA(1);
        ATNState currentState = ((ParserATNSimulator)recognizer.getInterpreter()).atn.states.get(recognizer.getState());
        ATN atn = ((ParserATNSimulator)recognizer.getInterpreter()).atn;
        ATNState next = currentState.transition((int)0).target;
        IntervalSet expectingAtLL2 = atn.nextTokens(next, PredictionContext.fromRuleContext(atn, recognizer._ctx));
        if (expectingAtLL2.contains(currentSymbolType)) {
            this.reportMissingToken(recognizer);
            return true;
        }
        return false;
    }

    @Nullable
    protected Token singleTokenDeletion(@NotNull Parser recognizer) {
        int nextTokenType = recognizer.getInputStream().LA(2);
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        if (expecting.contains(nextTokenType)) {
            this.reportUnwantedToken(recognizer);
            recognizer.consume();
            Token matchedSymbol = recognizer.getCurrentToken();
            this.reportMatch(recognizer);
            return matchedSymbol;
        }
        return null;
    }

    @NotNull
    protected Token getMissingSymbol(@NotNull Parser recognizer) {
        Token currentSymbol = recognizer.getCurrentToken();
        IntervalSet expecting = this.getExpectedTokens(recognizer);
        int expectedTokenType = 0;
        if (!expecting.isNil()) {
            expectedTokenType = expecting.getMinElement();
        }
        String tokenText = expectedTokenType == -1 ? "<missing EOF>" : "<missing " + recognizer.getVocabulary().getDisplayName(expectedTokenType) + ">";
        Token current2 = currentSymbol;
        Token lookback = recognizer.getInputStream().LT(-1);
        if (current2.getType() == -1 && lookback != null) {
            current2 = lookback;
        }
        return this.constructToken(recognizer.getInputStream().getTokenSource(), expectedTokenType, tokenText, current2);
    }

    protected Token constructToken(TokenSource tokenSource, int expectedTokenType, String tokenText, Token current2) {
        TokenFactory factory = tokenSource.getTokenFactory();
        return factory.create(Tuple.create(tokenSource, current2.getTokenSource().getInputStream()), expectedTokenType, tokenText, 0, -1, -1, current2.getLine(), current2.getCharPositionInLine());
    }

    @NotNull
    protected IntervalSet getExpectedTokens(@NotNull Parser recognizer) {
        return recognizer.getExpectedTokens();
    }

    protected String getTokenErrorDisplay(Token t) {
        if (t == null) {
            return "<no token>";
        }
        String s2 = this.getSymbolText(t);
        if (s2 == null) {
            s2 = this.getSymbolType(t) == -1 ? "<EOF>" : "<" + this.getSymbolType(t) + ">";
        }
        return this.escapeWSAndQuote(s2);
    }

    protected String getSymbolText(@NotNull Token symbol) {
        return symbol.getText();
    }

    protected int getSymbolType(@NotNull Token symbol) {
        return symbol.getType();
    }

    @NotNull
    protected String escapeWSAndQuote(@NotNull String s2) {
        s2 = s2.replace("\n", "\\n");
        s2 = s2.replace("\r", "\\r");
        s2 = s2.replace("\t", "\\t");
        return "'" + s2 + "'";
    }

    @NotNull
    protected IntervalSet getErrorRecoverySet(@NotNull Parser recognizer) {
        ATN atn = ((ParserATNSimulator)recognizer.getInterpreter()).atn;
        RuleContext ctx = recognizer._ctx;
        IntervalSet recoverSet = new IntervalSet(new int[0]);
        while (ctx != null && ctx.invokingState >= 0) {
            ATNState invokingState = atn.states.get(ctx.invokingState);
            RuleTransition rt2 = (RuleTransition)invokingState.transition(0);
            IntervalSet follow = atn.nextTokens(rt2.followState);
            recoverSet.addAll(follow);
            ctx = ctx.parent;
        }
        recoverSet.remove(-2);
        return recoverSet;
    }

    protected void consumeUntil(@NotNull Parser recognizer, @NotNull IntervalSet set) {
        int ttype = recognizer.getInputStream().LA(1);
        while (ttype != -1 && !set.contains(ttype)) {
            recognizer.consume();
            ttype = recognizer.getInputStream().LA(1);
        }
    }
}

