/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.antlr.v4.runtime.dfa;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicIntegerArray;
import org.pkl.thirdparty.antlr.v4.runtime.dfa.AbstractEdgeMap;
import org.pkl.thirdparty.antlr.v4.runtime.dfa.ArrayEdgeMap;
import org.pkl.thirdparty.antlr.v4.runtime.dfa.EdgeMap;
import org.pkl.thirdparty.antlr.v4.runtime.dfa.EmptyEdgeMap;
import org.pkl.thirdparty.antlr.v4.runtime.misc.NotNull;

public final class HashEdgeMap<T>
extends AbstractEdgeMap<T> {
    private static final int DEFAULT_MAX_SIZE = 2;
    private final AtomicIntegerArray keys;
    private final T[] values;

    public HashEdgeMap(int minIndex, int maxIndex) {
        this(minIndex, maxIndex, 2);
    }

    public HashEdgeMap(int minIndex, int maxIndex, int maxSparseSize) {
        super(minIndex, maxIndex);
        this.keys = new AtomicIntegerArray(maxSparseSize);
        this.values = new Object[maxSparseSize];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashEdgeMap(@NotNull HashEdgeMap<T> map2, int maxSparseSize) {
        super(map2.minIndex, map2.maxIndex);
        HashEdgeMap<T> hashEdgeMap = map2;
        synchronized (hashEdgeMap) {
            if (maxSparseSize < map2.values.length) {
                throw new IllegalArgumentException();
            }
            this.keys = new AtomicIntegerArray(maxSparseSize);
            this.values = new Object[maxSparseSize];
            for (int i2 = 0; i2 < map2.values.length; ++i2) {
                int key2 = map2.keys.get(i2);
                T value2 = map2.values[i2];
                if (value2 == null) continue;
                int bucket = this.bucket(key2);
                this.keys.set(bucket, key2);
                this.values[bucket] = value2;
            }
        }
    }

    private static int bucket(int length2, int key2) {
        return key2 & length2 - 1;
    }

    private int bucket(int key2) {
        return key2 & this.values.length - 1;
    }

    @NotNull
    AtomicIntegerArray getKeys() {
        return this.keys;
    }

    @NotNull
    T[] getValues() {
        return this.values;
    }

    @Override
    public int size() {
        int size = 0;
        for (T edge : this.values) {
            if (edge == null) continue;
            ++size;
        }
        return size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(int key2) {
        return this.get(key2) != null;
    }

    @Override
    public T get(int key2) {
        int bucket = this.bucket(key2);
        T value2 = this.values[bucket];
        if (value2 == null || this.keys.get(bucket) != key2) {
            return null;
        }
        return value2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractEdgeMap<T> put(int key2, T value2) {
        if (key2 < this.minIndex || key2 > this.maxIndex) {
            return this;
        }
        if (value2 == null) {
            return this.remove(key2);
        }
        HashEdgeMap hashEdgeMap = this;
        synchronized (hashEdgeMap) {
            int bucket = this.bucket(key2);
            int currentKey = this.keys.get(bucket);
            if (currentKey == key2) {
                this.values[bucket] = value2;
                return this;
            }
            T currentValue = this.values[bucket];
            if (currentValue == null) {
                this.keys.set(bucket, key2);
                this.values[bucket] = value2;
                return this;
            }
            int newSize = this.values.length;
            do {
                if ((newSize *= 2) < (this.maxIndex - this.minIndex + 1) / 2) continue;
                AbstractEdgeMap arrayMap = new ArrayEdgeMap(this.minIndex, this.maxIndex);
                arrayMap = ((ArrayEdgeMap)arrayMap).putAll((EdgeMap)this);
                ((ArrayEdgeMap)arrayMap).put(key2, (Object)value2);
                return arrayMap;
            } while (HashEdgeMap.bucket(newSize, currentKey) == HashEdgeMap.bucket(newSize, key2));
            HashEdgeMap<T> resized = new HashEdgeMap<T>(this, newSize);
            resized.put(key2, (Object)value2);
            return resized;
        }
    }

    @Override
    public HashEdgeMap<T> remove(int key2) {
        if (this.get(key2) == null) {
            return this;
        }
        HashEdgeMap<T> result2 = new HashEdgeMap<T>(this, this.values.length);
        int bucket = super.bucket(key2);
        result2.keys.set(bucket, 0);
        result2.values[bucket] = null;
        return result2;
    }

    @Override
    public AbstractEdgeMap<T> clear() {
        if (this.isEmpty()) {
            return this;
        }
        return new EmptyEdgeMap(this.minIndex, this.maxIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Integer, T> toMap() {
        if (this.isEmpty()) {
            return Collections.emptyMap();
        }
        HashEdgeMap hashEdgeMap = this;
        synchronized (hashEdgeMap) {
            TreeMap<Integer, T> result2 = new TreeMap<Integer, T>();
            for (int i2 = 0; i2 < this.values.length; ++i2) {
                int key2 = this.keys.get(i2);
                T value2 = this.values[i2];
                if (value2 == null) continue;
                result2.put(key2, value2);
            }
            return result2;
        }
    }

    @Override
    public Set<Map.Entry<Integer, T>> entrySet() {
        return this.toMap().entrySet();
    }
}

