/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableBlock;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableBody;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableCell;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableHead;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableRow;
import org.pkl.thirdparty.commonmark.node.Block;
import org.pkl.thirdparty.commonmark.node.Node;
import org.pkl.thirdparty.commonmark.node.SourceSpan;
import org.pkl.thirdparty.commonmark.parser.InlineParser;
import org.pkl.thirdparty.commonmark.parser.SourceLine;
import org.pkl.thirdparty.commonmark.parser.SourceLines;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParserFactory;
import org.pkl.thirdparty.commonmark.parser.block.BlockContinue;
import org.pkl.thirdparty.commonmark.parser.block.BlockStart;
import org.pkl.thirdparty.commonmark.parser.block.MatchedBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.ParserState;
import org.pkl.thirdparty.commonmark.text.Characters;

public class TableBlockParser
extends AbstractBlockParser {
    private final TableBlock block = new TableBlock();
    private final List<SourceLine> rowLines = new ArrayList<SourceLine>();
    private final List<TableCellInfo> columns;
    private boolean canHaveLazyContinuationLines = true;

    private TableBlockParser(List<TableCellInfo> columns, SourceLine headerLine) {
        this.columns = columns;
        this.rowLines.add(headerLine);
    }

    @Override
    public boolean canHaveLazyContinuationLines() {
        return this.canHaveLazyContinuationLines;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        CharSequence content = state.getLine().getContent();
        int pipe = Characters.find('|', content, state.getNextNonSpaceIndex());
        if (pipe != -1) {
            if (pipe == state.getNextNonSpaceIndex() && Characters.skipSpaceTab(content, pipe + 1, content.length()) == content.length()) {
                this.canHaveLazyContinuationLines = false;
                return BlockContinue.none();
            }
            return BlockContinue.atIndex(state.getIndex());
        }
        return BlockContinue.none();
    }

    @Override
    public void addLine(SourceLine line) {
        this.rowLines.add(line);
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        List<SourceSpan> sourceSpans = this.block.getSourceSpans();
        SourceSpan headerSourceSpan = !sourceSpans.isEmpty() ? sourceSpans.get(0) : null;
        TableHead head2 = new TableHead();
        if (headerSourceSpan != null) {
            head2.addSourceSpan(headerSourceSpan);
        }
        this.block.appendChild(head2);
        TableRow headerRow = new TableRow();
        headerRow.setSourceSpans(head2.getSourceSpans());
        head2.appendChild(headerRow);
        List<SourceLine> headerCells = TableBlockParser.split(this.rowLines.get(0));
        int headerColumns = headerCells.size();
        for (int i2 = 0; i2 < headerColumns; ++i2) {
            SourceLine cell = headerCells.get(i2);
            TableCell tableCell = this.parseCell(cell, i2, inlineParser);
            tableCell.setHeader(true);
            headerRow.appendChild(tableCell);
        }
        Node body2 = null;
        for (int rowIndex = 2; rowIndex < this.rowLines.size(); ++rowIndex) {
            SourceLine rowLine = this.rowLines.get(rowIndex);
            SourceSpan sourceSpan = rowIndex < sourceSpans.size() ? sourceSpans.get(rowIndex) : null;
            List<SourceLine> cells = TableBlockParser.split(rowLine);
            TableRow row = new TableRow();
            if (sourceSpan != null) {
                row.addSourceSpan(sourceSpan);
            }
            for (int i3 = 0; i3 < headerColumns; ++i3) {
                SourceLine cell = i3 < cells.size() ? cells.get(i3) : SourceLine.of("", null);
                TableCell tableCell = this.parseCell(cell, i3, inlineParser);
                row.appendChild(tableCell);
            }
            if (body2 == null) {
                body2 = new TableBody();
                this.block.appendChild(body2);
            }
            body2.appendChild(row);
            body2.addSourceSpan(sourceSpan);
        }
    }

    private TableCell parseCell(SourceLine cell, int column, InlineParser inlineParser) {
        TableCell tableCell = new TableCell();
        SourceSpan sourceSpan = cell.getSourceSpan();
        if (sourceSpan != null) {
            tableCell.addSourceSpan(sourceSpan);
        }
        if (column < this.columns.size()) {
            TableCellInfo cellInfo = this.columns.get(column);
            tableCell.setAlignment(cellInfo.getAlignment());
            tableCell.setWidth(cellInfo.getWidth());
        }
        CharSequence content = cell.getContent();
        int start2 = Characters.skipSpaceTab(content, 0, content.length());
        int end2 = Characters.skipSpaceTabBackwards(content, content.length() - 1, start2);
        inlineParser.parse(SourceLines.of(cell.substring(start2, end2 + 1)), tableCell);
        return tableCell;
    }

    private static List<SourceLine> split(SourceLine line) {
        int nonSpace;
        CharSequence row = line.getContent();
        int cellStart = nonSpace = Characters.skipSpaceTab(row, 0, row.length());
        int cellEnd = row.length();
        if (row.charAt(nonSpace) == '|') {
            cellStart = nonSpace + 1;
            int nonSpaceEnd = Characters.skipSpaceTabBackwards(row, row.length() - 1, cellStart);
            cellEnd = nonSpaceEnd + 1;
        }
        ArrayList<SourceLine> cells = new ArrayList<SourceLine>();
        StringBuilder sb = new StringBuilder();
        block4: for (int i2 = cellStart; i2 < cellEnd; ++i2) {
            char c = row.charAt(i2);
            switch (c) {
                case '\\': {
                    if (i2 + 1 < cellEnd && row.charAt(i2 + 1) == '|') {
                        sb.append('|');
                        ++i2;
                        continue block4;
                    }
                    sb.append('\\');
                    continue block4;
                }
                case '|': {
                    String content = sb.toString();
                    cells.add(SourceLine.of(content, line.substring(cellStart, i2).getSourceSpan()));
                    sb.setLength(0);
                    cellStart = i2 + 1;
                    continue block4;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        if (sb.length() > 0) {
            String content = sb.toString();
            cells.add(SourceLine.of(content, line.substring(cellStart, line.getContent().length()).getSourceSpan()));
        }
        return cells;
    }

    private static List<TableCellInfo> parseSeparator(CharSequence s2) {
        ArrayList<TableCellInfo> columns = new ArrayList<TableCellInfo>();
        int pipes = 0;
        boolean valid = false;
        int i2 = 0;
        int width = 0;
        block5: while (i2 < s2.length()) {
            char c = s2.charAt(i2);
            switch (c) {
                case '|': {
                    ++i2;
                    if (++pipes > 1) {
                        return null;
                    }
                    valid = true;
                    continue block5;
                }
                case '-': 
                case ':': {
                    if (pipes == 0 && !columns.isEmpty()) {
                        return null;
                    }
                    boolean left = false;
                    boolean right = false;
                    if (c == ':') {
                        left = true;
                        ++i2;
                        ++width;
                    }
                    boolean haveDash = false;
                    while (i2 < s2.length() && s2.charAt(i2) == '-') {
                        ++i2;
                        ++width;
                        haveDash = true;
                    }
                    if (!haveDash) {
                        return null;
                    }
                    if (i2 < s2.length() && s2.charAt(i2) == ':') {
                        right = true;
                        ++i2;
                        ++width;
                    }
                    columns.add(new TableCellInfo(TableBlockParser.getAlignment(left, right), width));
                    width = 0;
                    pipes = 0;
                    continue block5;
                }
                case '\t': 
                case ' ': {
                    ++i2;
                    continue block5;
                }
            }
            return null;
        }
        if (!valid) {
            return null;
        }
        return columns;
    }

    private static TableCell.Alignment getAlignment(boolean left, boolean right) {
        if (left && right) {
            return TableCell.Alignment.CENTER;
        }
        if (left) {
            return TableCell.Alignment.LEFT;
        }
        if (right) {
            return TableCell.Alignment.RIGHT;
        }
        return null;
    }

    private static class TableCellInfo {
        private final TableCell.Alignment alignment;
        private final int width;

        public TableCell.Alignment getAlignment() {
            return this.alignment;
        }

        public int getWidth() {
            return this.width;
        }

        public TableCellInfo(TableCell.Alignment alignment, int width) {
            this.alignment = alignment;
            this.width = width;
        }
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            SourceLine line;
            SourceLine separatorLine;
            List<TableCellInfo> columns;
            List<SourceLine> paragraphLines = matchedBlockParser.getParagraphLines().getLines();
            if (paragraphLines.size() == 1 && Characters.find('|', paragraphLines.get(0).getContent(), 0) != -1 && (columns = TableBlockParser.parseSeparator((separatorLine = (line = state.getLine()).substring(state.getIndex(), line.getContent().length())).getContent())) != null && !columns.isEmpty()) {
                SourceLine paragraph = paragraphLines.get(0);
                List<SourceLine> headerCells = TableBlockParser.split(paragraph);
                if (columns.size() >= headerCells.size()) {
                    return BlockStart.of(new TableBlockParser(columns, paragraph)).atIndex(state.getIndex()).replaceActiveBlockParser();
                }
            }
            return BlockStart.none();
        }
    }
}

