/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.ext.gfm.tables.internal;

import java.util.ArrayList;
import java.util.List;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableBlock;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableBody;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableCell;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableHead;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.TableRow;
import org.pkl.thirdparty.commonmark.ext.gfm.tables.internal.TableNodeRenderer;
import org.pkl.thirdparty.commonmark.node.Node;
import org.pkl.thirdparty.commonmark.renderer.NodeRenderer;
import org.pkl.thirdparty.commonmark.renderer.markdown.MarkdownNodeRendererContext;
import org.pkl.thirdparty.commonmark.renderer.markdown.MarkdownWriter;
import org.pkl.thirdparty.commonmark.text.AsciiMatcher;

public class TableMarkdownNodeRenderer
extends TableNodeRenderer
implements NodeRenderer {
    private final MarkdownWriter writer;
    private final MarkdownNodeRendererContext context;
    private final AsciiMatcher pipe = AsciiMatcher.builder().c('|').build();
    private final List<TableCell.Alignment> columns = new ArrayList<TableCell.Alignment>();

    public TableMarkdownNodeRenderer(MarkdownNodeRendererContext context2) {
        this.writer = context2.getWriter();
        this.context = context2;
    }

    @Override
    protected void renderBlock(TableBlock node) {
        this.columns.clear();
        this.writer.pushTight(true);
        this.renderChildren(node);
        this.writer.popTight();
        this.writer.block();
    }

    @Override
    protected void renderHead(TableHead node) {
        this.renderChildren(node);
        for (TableCell.Alignment columnAlignment : this.columns) {
            this.writer.raw('|');
            if (columnAlignment == TableCell.Alignment.LEFT) {
                this.writer.raw(":---");
                continue;
            }
            if (columnAlignment == TableCell.Alignment.RIGHT) {
                this.writer.raw("---:");
                continue;
            }
            if (columnAlignment == TableCell.Alignment.CENTER) {
                this.writer.raw(":---:");
                continue;
            }
            this.writer.raw("---");
        }
        this.writer.raw("|");
        this.writer.block();
    }

    @Override
    protected void renderBody(TableBody node) {
        this.renderChildren(node);
    }

    @Override
    protected void renderRow(TableRow node) {
        this.renderChildren(node);
        this.writer.raw("|");
        this.writer.block();
    }

    @Override
    protected void renderCell(TableCell node) {
        if (node.getParent() != null && node.getParent().getParent() instanceof TableHead) {
            this.columns.add(node.getAlignment());
        }
        this.writer.raw("|");
        this.writer.pushRawEscape(this.pipe);
        this.renderChildren(node);
        this.writer.popRawEscape();
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }
}

