/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal;

import java.util.List;
import org.pkl.thirdparty.commonmark.node.Text;
import org.pkl.thirdparty.commonmark.parser.delimiter.DelimiterRun;

public class Delimiter
implements DelimiterRun {
    public final List<Text> characters;
    public final char delimiterChar;
    private final int originalLength;
    private final boolean canOpen;
    private final boolean canClose;
    public Delimiter previous;
    public Delimiter next;

    public Delimiter(List<Text> characters, char delimiterChar, boolean canOpen, boolean canClose, Delimiter previous) {
        this.characters = characters;
        this.delimiterChar = delimiterChar;
        this.canOpen = canOpen;
        this.canClose = canClose;
        this.previous = previous;
        this.originalLength = characters.size();
    }

    @Override
    public boolean canOpen() {
        return this.canOpen;
    }

    @Override
    public boolean canClose() {
        return this.canClose;
    }

    @Override
    public int length() {
        return this.characters.size();
    }

    @Override
    public int originalLength() {
        return this.originalLength;
    }

    @Override
    public Text getOpener() {
        return this.characters.get(this.characters.size() - 1);
    }

    @Override
    public Text getCloser() {
        return this.characters.get(0);
    }

    @Override
    public Iterable<Text> getOpeners(int length2) {
        if (length2 < 1 || length2 > this.length()) {
            throw new IllegalArgumentException("length must be between 1 and " + this.length() + ", was " + length2);
        }
        return this.characters.subList(this.characters.size() - length2, this.characters.size());
    }

    @Override
    public Iterable<Text> getClosers(int length2) {
        if (length2 < 1 || length2 > this.length()) {
            throw new IllegalArgumentException("length must be between 1 and " + this.length() + ", was " + length2);
        }
        return this.characters.subList(0, length2);
    }
}

