/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal;

import org.pkl.thirdparty.commonmark.internal.util.Escaping;
import org.pkl.thirdparty.commonmark.internal.util.Parsing;
import org.pkl.thirdparty.commonmark.node.Block;
import org.pkl.thirdparty.commonmark.node.FencedCodeBlock;
import org.pkl.thirdparty.commonmark.parser.SourceLine;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParserFactory;
import org.pkl.thirdparty.commonmark.parser.block.BlockContinue;
import org.pkl.thirdparty.commonmark.parser.block.BlockStart;
import org.pkl.thirdparty.commonmark.parser.block.MatchedBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.ParserState;
import org.pkl.thirdparty.commonmark.text.Characters;

public class FencedCodeBlockParser
extends AbstractBlockParser {
    private final FencedCodeBlock block = new FencedCodeBlock();
    private final char fenceChar;
    private final int openingFenceLength;
    private String firstLine;
    private StringBuilder otherLines = new StringBuilder();

    public FencedCodeBlockParser(char fenceChar, int fenceLength, int fenceIndent) {
        this.fenceChar = fenceChar;
        this.openingFenceLength = fenceLength;
        this.block.setFenceCharacter(String.valueOf(fenceChar));
        this.block.setOpeningFenceLength(fenceLength);
        this.block.setFenceIndent(fenceIndent);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        int nextNonSpace = state.getNextNonSpaceIndex();
        int newIndex = state.getIndex();
        CharSequence line = state.getLine().getContent();
        if (state.getIndent() < Parsing.CODE_BLOCK_INDENT && nextNonSpace < line.length() && this.tryClosing(line, nextNonSpace)) {
            return BlockContinue.finished();
        }
        int length2 = line.length();
        for (int i2 = this.block.getFenceIndent(); i2 > 0 && newIndex < length2 && line.charAt(newIndex) == ' '; ++newIndex, --i2) {
        }
        return BlockContinue.atIndex(newIndex);
    }

    @Override
    public void addLine(SourceLine line) {
        if (this.firstLine == null) {
            this.firstLine = line.getContent().toString();
        } else {
            this.otherLines.append(line.getContent());
            this.otherLines.append('\n');
        }
    }

    @Override
    public void closeBlock() {
        this.block.setInfo(Escaping.unescapeString(this.firstLine.trim()));
        this.block.setLiteral(this.otherLines.toString());
    }

    private static FencedCodeBlockParser checkOpener(CharSequence line, int index, int indent) {
        int backticks = 0;
        int tildes = 0;
        int length2 = line.length();
        block4: for (int i2 = index; i2 < length2; ++i2) {
            switch (line.charAt(i2)) {
                case '`': {
                    ++backticks;
                    continue block4;
                }
                case '~': {
                    ++tildes;
                    continue block4;
                }
            }
        }
        if (backticks >= 3 && tildes == 0) {
            if (Characters.find('`', line, index + backticks) != -1) {
                return null;
            }
            return new FencedCodeBlockParser('`', backticks, indent);
        }
        if (tildes >= 3 && backticks == 0) {
            return new FencedCodeBlockParser('~', tildes, indent);
        }
        return null;
    }

    private boolean tryClosing(CharSequence line, int index) {
        int fences = Characters.skip(this.fenceChar, line, index, line.length()) - index;
        if (fences < this.openingFenceLength) {
            return false;
        }
        int after = Characters.skipSpaceTab(line, index + fences, line.length());
        if (after == line.length()) {
            this.block.setClosingFenceLength(fences);
            return true;
        }
        return false;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            int indent = state.getIndent();
            if (indent >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int nextNonSpace = state.getNextNonSpaceIndex();
            FencedCodeBlockParser blockParser = FencedCodeBlockParser.checkOpener(state.getLine().getContent(), nextNonSpace, indent);
            if (blockParser != null) {
                return BlockStart.of(blockParser).atIndex(nextNonSpace + blockParser.block.getOpeningFenceLength());
            }
            return BlockStart.none();
        }
    }
}

