/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal;

import java.util.Objects;
import org.pkl.thirdparty.commonmark.internal.ListItemParser;
import org.pkl.thirdparty.commonmark.internal.util.Parsing;
import org.pkl.thirdparty.commonmark.node.Block;
import org.pkl.thirdparty.commonmark.node.BulletList;
import org.pkl.thirdparty.commonmark.node.ListBlock;
import org.pkl.thirdparty.commonmark.node.ListItem;
import org.pkl.thirdparty.commonmark.node.OrderedList;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParserFactory;
import org.pkl.thirdparty.commonmark.parser.block.BlockContinue;
import org.pkl.thirdparty.commonmark.parser.block.BlockParser;
import org.pkl.thirdparty.commonmark.parser.block.BlockStart;
import org.pkl.thirdparty.commonmark.parser.block.MatchedBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.ParserState;

public class ListBlockParser
extends AbstractBlockParser {
    private final ListBlock block;
    private boolean hadBlankLine;
    private int linesAfterBlank;

    public ListBlockParser(ListBlock block) {
        this.block = block;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block childBlock) {
        if (childBlock instanceof ListItem) {
            if (this.hadBlankLine && this.linesAfterBlank == 1) {
                this.block.setTight(false);
                this.hadBlankLine = false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.isBlank()) {
            this.hadBlankLine = true;
            this.linesAfterBlank = 0;
        } else if (this.hadBlankLine) {
            ++this.linesAfterBlank;
        }
        return BlockContinue.atIndex(state.getIndex());
    }

    private static ListData parseList(CharSequence line, int markerIndex, int markerColumn, boolean inParagraph) {
        int columnAfterMarker;
        ListMarkerData listMarker = ListBlockParser.parseListMarker(line, markerIndex);
        if (listMarker == null) {
            return null;
        }
        ListBlock listBlock = listMarker.listBlock;
        int indexAfterMarker = listMarker.indexAfterMarker;
        int markerLength = indexAfterMarker - markerIndex;
        int contentColumn = columnAfterMarker = markerColumn + markerLength;
        boolean hasContent = false;
        int length2 = line.length();
        for (int i2 = indexAfterMarker; i2 < length2; ++i2) {
            char c = line.charAt(i2);
            if (c == '\t') {
                contentColumn += Parsing.columnsToNextTabStop(contentColumn);
                continue;
            }
            if (c == ' ') {
                ++contentColumn;
                continue;
            }
            hasContent = true;
            break;
        }
        if (inParagraph) {
            if (listBlock instanceof OrderedList && ((OrderedList)listBlock).getMarkerStartNumber() != 1) {
                return null;
            }
            if (!hasContent) {
                return null;
            }
        }
        if (!hasContent || contentColumn - columnAfterMarker > Parsing.CODE_BLOCK_INDENT) {
            contentColumn = columnAfterMarker + 1;
        }
        return new ListData(listBlock, contentColumn);
    }

    private static ListMarkerData parseListMarker(CharSequence line, int index) {
        char c = line.charAt(index);
        switch (c) {
            case '*': 
            case '+': 
            case '-': {
                if (ListBlockParser.isSpaceTabOrEnd(line, index + 1)) {
                    BulletList bulletList = new BulletList();
                    bulletList.setMarker(String.valueOf(c));
                    return new ListMarkerData(bulletList, index + 1);
                }
                return null;
            }
        }
        return ListBlockParser.parseOrderedList(line, index);
    }

    private static ListMarkerData parseOrderedList(CharSequence line, int index) {
        int digits = 0;
        int length2 = line.length();
        block4: for (int i2 = index; i2 < length2; ++i2) {
            char c = line.charAt(i2);
            switch (c) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (++digits <= 9) continue block4;
                    return null;
                }
                case ')': 
                case '.': {
                    if (digits >= 1 && ListBlockParser.isSpaceTabOrEnd(line, i2 + 1)) {
                        String number = line.subSequence(index, i2).toString();
                        OrderedList orderedList = new OrderedList();
                        orderedList.setMarkerStartNumber(Integer.parseInt(number));
                        orderedList.setMarkerDelimiter(String.valueOf(c));
                        return new ListMarkerData(orderedList, i2 + 1);
                    }
                    return null;
                }
                default: {
                    return null;
                }
            }
        }
        return null;
    }

    private static boolean isSpaceTabOrEnd(CharSequence line, int index) {
        if (index < line.length()) {
            switch (line.charAt(index)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    private static boolean listsMatch(ListBlock a2, ListBlock b2) {
        if (a2 instanceof BulletList && b2 instanceof BulletList) {
            return Objects.equals(((BulletList)a2).getMarker(), ((BulletList)b2).getMarker());
        }
        if (a2 instanceof OrderedList && b2 instanceof OrderedList) {
            return Objects.equals(((OrderedList)a2).getMarkerDelimiter(), ((OrderedList)b2).getMarkerDelimiter());
        }
        return false;
    }

    private static class ListMarkerData {
        final ListBlock listBlock;
        final int indexAfterMarker;

        ListMarkerData(ListBlock listBlock, int indexAfterMarker) {
            this.listBlock = listBlock;
            this.indexAfterMarker = indexAfterMarker;
        }
    }

    private static class ListData {
        final ListBlock listBlock;
        final int contentColumn;

        ListData(ListBlock listBlock, int contentColumn) {
            this.listBlock = listBlock;
            this.contentColumn = contentColumn;
        }
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            BlockParser matched = matchedBlockParser.getMatchedBlockParser();
            if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            int markerIndex = state.getNextNonSpaceIndex();
            int markerColumn = state.getColumn() + state.getIndent();
            boolean inParagraph = !matchedBlockParser.getParagraphLines().isEmpty();
            ListData listData = ListBlockParser.parseList(state.getLine().getContent(), markerIndex, markerColumn, inParagraph);
            if (listData == null) {
                return BlockStart.none();
            }
            int newColumn = listData.contentColumn;
            ListItemParser listItemParser = new ListItemParser(state.getIndent(), newColumn - state.getColumn());
            if (!(matched instanceof ListBlockParser) || !ListBlockParser.listsMatch((ListBlock)matched.getBlock(), listData.listBlock)) {
                ListBlockParser listBlockParser = new ListBlockParser(listData.listBlock);
                listData.listBlock.setTight(true);
                return BlockStart.of(listBlockParser, listItemParser).atColumn(newColumn);
            }
            return BlockStart.of(listItemParser).atColumn(newColumn);
        }
    }
}

