/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal;

import org.pkl.thirdparty.commonmark.node.Block;
import org.pkl.thirdparty.commonmark.node.ListBlock;
import org.pkl.thirdparty.commonmark.node.ListItem;
import org.pkl.thirdparty.commonmark.node.Paragraph;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.BlockContinue;
import org.pkl.thirdparty.commonmark.parser.block.ParserState;

public class ListItemParser
extends AbstractBlockParser {
    private final ListItem block = new ListItem();
    private int contentIndent;
    private boolean hadBlankLine;

    public ListItemParser(int markerIndent, int contentIndent) {
        this.contentIndent = contentIndent;
        this.block.setMarkerIndent(markerIndent);
        this.block.setContentIndent(contentIndent);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean canContain(Block childBlock) {
        Block parent;
        if (this.hadBlankLine && (parent = this.block.getParent()) instanceof ListBlock) {
            ((ListBlock)parent).setTight(false);
        }
        return true;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        if (state.isBlank()) {
            if (this.block.getFirstChild() == null) {
                return BlockContinue.none();
            }
            Block activeBlock = state.getActiveBlockParser().getBlock();
            this.hadBlankLine = activeBlock instanceof Paragraph || activeBlock instanceof ListItem;
            return BlockContinue.atIndex(state.getNextNonSpaceIndex());
        }
        if (state.getIndent() >= this.contentIndent) {
            return BlockContinue.atColumn(state.getColumn() + this.contentIndent);
        }
        return BlockContinue.none();
    }
}

