/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal;

import java.util.LinkedList;
import java.util.ListIterator;
import org.pkl.thirdparty.commonmark.parser.delimiter.DelimiterProcessor;
import org.pkl.thirdparty.commonmark.parser.delimiter.DelimiterRun;

class StaggeredDelimiterProcessor
implements DelimiterProcessor {
    private final char delim;
    private int minLength = 0;
    private LinkedList<DelimiterProcessor> processors = new LinkedList();

    StaggeredDelimiterProcessor(char delim) {
        this.delim = delim;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delim;
    }

    @Override
    public char getClosingCharacter() {
        return this.delim;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    void add(DelimiterProcessor dp) {
        int len = dp.getMinLength();
        ListIterator<DelimiterProcessor> it = this.processors.listIterator();
        boolean added = false;
        while (it.hasNext()) {
            DelimiterProcessor p2 = (DelimiterProcessor)it.next();
            int pLen = p2.getMinLength();
            if (len > pLen) {
                it.previous();
                it.add(dp);
                added = true;
                break;
            }
            if (len != pLen) continue;
            throw new IllegalArgumentException("Cannot add two delimiter processors for char '" + this.delim + "' and minimum length " + len + "; conflicting processors: " + p2 + ", " + dp);
        }
        if (!added) {
            this.processors.add(dp);
            this.minLength = len;
        }
    }

    private DelimiterProcessor findProcessor(int len) {
        for (DelimiterProcessor p2 : this.processors) {
            if (p2.getMinLength() > len) continue;
            return p2;
        }
        return this.processors.getFirst();
    }

    @Override
    public int process(DelimiterRun openingRun, DelimiterRun closingRun) {
        return this.findProcessor(openingRun.length()).process(openingRun, closingRun);
    }
}

