/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal;

import org.pkl.thirdparty.commonmark.node.Block;
import org.pkl.thirdparty.commonmark.node.ThematicBreak;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.AbstractBlockParserFactory;
import org.pkl.thirdparty.commonmark.parser.block.BlockContinue;
import org.pkl.thirdparty.commonmark.parser.block.BlockStart;
import org.pkl.thirdparty.commonmark.parser.block.MatchedBlockParser;
import org.pkl.thirdparty.commonmark.parser.block.ParserState;

public class ThematicBreakParser
extends AbstractBlockParser {
    private final ThematicBreak block = new ThematicBreak();

    public ThematicBreakParser(String literal) {
        this.block.setLiteral(literal);
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState state) {
        return BlockContinue.none();
    }

    private static boolean isThematicBreak(CharSequence line, int index) {
        int dashes = 0;
        int underscores = 0;
        int asterisks = 0;
        int length2 = line.length();
        block6: for (int i2 = index; i2 < length2; ++i2) {
            switch (line.charAt(i2)) {
                case '-': {
                    ++dashes;
                    continue block6;
                }
                case '_': {
                    ++underscores;
                    continue block6;
                }
                case '*': {
                    ++asterisks;
                    continue block6;
                }
                case '\t': 
                case ' ': {
                    continue block6;
                }
                default: {
                    return false;
                }
            }
        }
        return dashes >= 3 && underscores == 0 && asterisks == 0 || underscores >= 3 && dashes == 0 && asterisks == 0 || asterisks >= 3 && dashes == 0 && underscores == 0;
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            if (state.getIndent() >= 4) {
                return BlockStart.none();
            }
            int nextNonSpace = state.getNextNonSpaceIndex();
            CharSequence line = state.getLine().getContent();
            if (ThematicBreakParser.isThematicBreak(line, nextNonSpace)) {
                String literal = String.valueOf(line.subSequence(state.getIndex(), line.length()));
                return BlockStart.of(new ThematicBreakParser(literal)).atIndex(line.length());
            }
            return BlockStart.none();
        }
    }
}

