/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal.inline;

import java.util.regex.Pattern;
import org.pkl.thirdparty.commonmark.internal.inline.InlineContentParser;
import org.pkl.thirdparty.commonmark.internal.inline.InlineParserState;
import org.pkl.thirdparty.commonmark.internal.inline.ParsedInline;
import org.pkl.thirdparty.commonmark.node.HardLineBreak;
import org.pkl.thirdparty.commonmark.node.Text;
import org.pkl.thirdparty.commonmark.parser.beta.Scanner;

public class BackslashInlineParser
implements InlineContentParser {
    private static final Pattern ESCAPABLE = Pattern.compile("^[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        char next = scanner.peek();
        if (next == '\n') {
            scanner.next();
            return ParsedInline.of(new HardLineBreak(), scanner.position());
        }
        if (ESCAPABLE.matcher(String.valueOf(next)).matches()) {
            scanner.next();
            return ParsedInline.of(new Text(String.valueOf(next)), scanner.position());
        }
        return ParsedInline.of(new Text("\\"), scanner.position());
    }
}

