/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal.util;

import java.nio.charset.Charset;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.pkl.thirdparty.commonmark.internal.util.Html5Entities;

public class Escaping {
    public static final String ESCAPABLE = "[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]";
    public static final String ENTITY = "&(?:#x[a-f0-9]{1,6}|#[0-9]{1,7}|[a-z][a-z0-9]{1,31});";
    private static final Pattern BACKSLASH_OR_AMP = Pattern.compile("[\\\\&]");
    private static final Pattern ENTITY_OR_ESCAPED_CHAR = Pattern.compile("\\\\[!\"#$%&'()*+,./:;<=>?@\\[\\\\\\]^_`{|}~-]|&(?:#x[a-f0-9]{1,6}|#[0-9]{1,7}|[a-z][a-z0-9]{1,31});", 2);
    private static final Pattern ESCAPE_IN_URI = Pattern.compile("(%[a-fA-F0-9]{0,2}|[^:/?#@!$&'()*+,;=a-zA-Z0-9\\-._~])");
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final Pattern WHITESPACE = Pattern.compile("[ \t\r\n]+");
    private static final Replacer UNESCAPE_REPLACER = new Replacer(){

        @Override
        public void replace(String input2, StringBuilder sb) {
            if (input2.charAt(0) == '\\') {
                sb.append(input2, 1, input2.length());
            } else {
                sb.append(Html5Entities.entityToString(input2));
            }
        }
    };
    private static final Replacer URI_REPLACER = new Replacer(){

        @Override
        public void replace(String input2, StringBuilder sb) {
            if (input2.startsWith("%")) {
                if (input2.length() == 3) {
                    sb.append(input2);
                } else {
                    sb.append("%25");
                    sb.append(input2, 1, input2.length());
                }
            } else {
                byte[] bytes;
                for (byte b2 : bytes = input2.getBytes(Charset.forName("UTF-8"))) {
                    sb.append('%');
                    sb.append(HEX_DIGITS[b2 >> 4 & 0xF]);
                    sb.append(HEX_DIGITS[b2 & 0xF]);
                }
            }
        }
    };

    public static String escapeHtml(String input2) {
        StringBuilder sb = null;
        block6: for (int i2 = 0; i2 < input2.length(); ++i2) {
            String replacement;
            char c = input2.charAt(i2);
            switch (c) {
                case '&': {
                    replacement = "&amp;";
                    break;
                }
                case '<': {
                    replacement = "&lt;";
                    break;
                }
                case '>': {
                    replacement = "&gt;";
                    break;
                }
                case '\"': {
                    replacement = "&quot;";
                    break;
                }
                default: {
                    if (sb == null) continue block6;
                    sb.append(c);
                    continue block6;
                }
            }
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(input2, 0, i2);
            }
            sb.append(replacement);
        }
        return sb != null ? sb.toString() : input2;
    }

    public static String unescapeString(String s2) {
        if (BACKSLASH_OR_AMP.matcher(s2).find()) {
            return Escaping.replaceAll(ENTITY_OR_ESCAPED_CHAR, s2, UNESCAPE_REPLACER);
        }
        return s2;
    }

    public static String percentEncodeUrl(String s2) {
        return Escaping.replaceAll(ESCAPE_IN_URI, s2, URI_REPLACER);
    }

    public static String normalizeLabelContent(String input2) {
        String trimmed = input2.trim();
        String caseFolded = trimmed.toLowerCase(Locale.ROOT).toUpperCase(Locale.ROOT);
        return WHITESPACE.matcher(caseFolded).replaceAll(" ");
    }

    private static String replaceAll(Pattern p2, String s2, Replacer replacer) {
        Matcher matcher = p2.matcher(s2);
        if (!matcher.find()) {
            return s2;
        }
        StringBuilder sb = new StringBuilder(s2.length() + 16);
        int lastEnd = 0;
        do {
            sb.append(s2, lastEnd, matcher.start());
            replacer.replace(matcher.group(), sb);
            lastEnd = matcher.end();
        } while (matcher.find());
        if (lastEnd != s2.length()) {
            sb.append(s2, lastEnd, s2.length());
        }
        return sb.toString();
    }

    private static interface Replacer {
        public void replace(String var1, StringBuilder var2);
    }
}

