/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.internal.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public class Html5Entities {
    private static final Map<String, String> NAMED_CHARACTER_REFERENCES = Html5Entities.readEntities();
    private static final String ENTITY_PATH = "/org/pkl/thirdparty/commonmark/internal/util/entities.properties";

    public static String entityToString(String input2) {
        if (!input2.startsWith("&") || !input2.endsWith(";")) {
            return input2;
        }
        String value2 = input2.substring(1, input2.length() - 1);
        if (value2.startsWith("#")) {
            value2 = value2.substring(1);
            int base2 = 10;
            if (value2.startsWith("x") || value2.startsWith("X")) {
                value2 = value2.substring(1);
                base2 = 16;
            }
            try {
                int codePoint = Integer.parseInt(value2, base2);
                if (codePoint == 0) {
                    return "\ufffd";
                }
                return new String(Character.toChars(codePoint));
            }
            catch (IllegalArgumentException e2) {
                return "\ufffd";
            }
        }
        String s2 = NAMED_CHARACTER_REFERENCES.get(value2);
        if (s2 != null) {
            return s2;
        }
        return input2;
    }

    private static Map<String, String> readEntities() {
        HashMap<String, String> entities = new HashMap<String, String>();
        InputStream stream = Html5Entities.class.getResourceAsStream(ENTITY_PATH);
        Charset charset = StandardCharsets.UTF_8;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream, charset));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                if (line.length() == 0) continue;
                int equal = line.indexOf("=");
                String key2 = line.substring(0, equal);
                String value2 = line.substring(equal + 1);
                entities.put(key2, value2);
            }
        }
        catch (IOException e2) {
            throw new IllegalStateException("Failed reading data for HTML named character references", e2);
        }
        entities.put("NewLine", "\n");
        return entities;
    }
}

