/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pkl.thirdparty.commonmark.node.Node;
import org.pkl.thirdparty.commonmark.node.SourceSpan;

public class SourceSpans {
    private List<SourceSpan> sourceSpans;

    public static SourceSpans empty() {
        return new SourceSpans();
    }

    public List<SourceSpan> getSourceSpans() {
        return this.sourceSpans != null ? this.sourceSpans : Collections.emptyList();
    }

    public void addAllFrom(Iterable<? extends Node> nodes) {
        for (Node node : nodes) {
            this.addAll(node.getSourceSpans());
        }
    }

    public void addAll(List<SourceSpan> other) {
        if (other.isEmpty()) {
            return;
        }
        if (this.sourceSpans == null) {
            this.sourceSpans = new ArrayList<SourceSpan>();
        }
        if (this.sourceSpans.isEmpty()) {
            this.sourceSpans.addAll(other);
        } else {
            int lastIndex2 = this.sourceSpans.size() - 1;
            SourceSpan a2 = this.sourceSpans.get(lastIndex2);
            SourceSpan b2 = other.get(0);
            if (a2.getLineIndex() == b2.getLineIndex() && a2.getColumnIndex() + a2.getLength() == b2.getColumnIndex()) {
                this.sourceSpans.set(lastIndex2, SourceSpan.of(a2.getLineIndex(), a2.getColumnIndex(), a2.getLength() + b2.getLength()));
                this.sourceSpans.addAll(other.subList(1, other.size()));
            } else {
                this.sourceSpans.addAll(other);
            }
        }
    }
}

