/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.renderer.text;

import java.io.IOException;

public class TextContentWriter {
    private final Appendable buffer;
    private char lastChar;

    public TextContentWriter(Appendable out2) {
        this.buffer = out2;
    }

    public void whitespace() {
        if (this.lastChar != '\u0000' && this.lastChar != ' ') {
            this.append(' ');
        }
    }

    public void colon() {
        if (this.lastChar != '\u0000' && this.lastChar != ':') {
            this.append(':');
        }
    }

    public void line() {
        if (this.lastChar != '\u0000' && this.lastChar != '\n') {
            this.append('\n');
        }
    }

    public void writeStripped(String s2) {
        this.append(s2.replaceAll("[\\r\\n\\s]+", " "));
    }

    public void write(String s2) {
        this.append(s2);
    }

    public void write(char c) {
        this.append(c);
    }

    private void append(String s2) {
        try {
            this.buffer.append(s2);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        int length2 = s2.length();
        if (length2 != 0) {
            this.lastChar = s2.charAt(length2 - 1);
        }
    }

    private void append(char c) {
        try {
            this.buffer.append(c);
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        this.lastChar = c;
    }
}

