/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.commonmark.text;

public class Characters {
    public static int find(char c, CharSequence s2, int startIndex) {
        int length2 = s2.length();
        for (int i2 = startIndex; i2 < length2; ++i2) {
            if (s2.charAt(i2) != c) continue;
            return i2;
        }
        return -1;
    }

    public static int findLineBreak(CharSequence s2, int startIndex) {
        int length2 = s2.length();
        for (int i2 = startIndex; i2 < length2; ++i2) {
            switch (s2.charAt(i2)) {
                case '\n': 
                case '\r': {
                    return i2;
                }
            }
        }
        return -1;
    }

    public static boolean isBlank(CharSequence s2) {
        return Characters.skipSpaceTab(s2, 0, s2.length()) == s2.length();
    }

    public static boolean hasNonSpace(CharSequence s2) {
        int length2 = s2.length();
        int skipped = Characters.skip(' ', s2, 0, length2);
        return skipped != length2;
    }

    public static boolean isLetter(CharSequence s2, int index) {
        int codePoint = Character.codePointAt(s2, index);
        return Character.isLetter(codePoint);
    }

    public static boolean isSpaceOrTab(CharSequence s2, int index) {
        if (index < s2.length()) {
            switch (s2.charAt(index)) {
                case '\t': 
                case ' ': {
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isPunctuationCodePoint(int codePoint) {
        switch (Character.getType(codePoint)) {
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        switch (codePoint) {
            case 36: 
            case 43: 
            case 60: 
            case 61: 
            case 62: 
            case 94: 
            case 96: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespaceCodePoint(int codePoint) {
        switch (codePoint) {
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return Character.getType(codePoint) == 12;
    }

    public static int skip(char skip, CharSequence s2, int startIndex, int endIndex) {
        for (int i2 = startIndex; i2 < endIndex; ++i2) {
            if (s2.charAt(i2) == skip) continue;
            return i2;
        }
        return endIndex;
    }

    public static int skipBackwards(char skip, CharSequence s2, int startIndex, int lastIndex2) {
        for (int i2 = startIndex; i2 >= lastIndex2; --i2) {
            if (s2.charAt(i2) == skip) continue;
            return i2;
        }
        return lastIndex2 - 1;
    }

    public static int skipSpaceTab(CharSequence s2, int startIndex, int endIndex) {
        block3: for (int i2 = startIndex; i2 < endIndex; ++i2) {
            switch (s2.charAt(i2)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i2;
                }
            }
        }
        return endIndex;
    }

    public static int skipSpaceTabBackwards(CharSequence s2, int startIndex, int lastIndex2) {
        block3: for (int i2 = startIndex; i2 >= lastIndex2; --i2) {
            switch (s2.charAt(i2)) {
                case '\t': 
                case ' ': {
                    continue block3;
                }
                default: {
                    return i2;
                }
            }
        }
        return lastIndex2 - 1;
    }
}

