/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.geantyref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.pkl.thirdparty.geantyref.GenericTypeReflector;

class AnnotatedTypeImpl
implements AnnotatedType {
    protected Type type;
    protected Map<Class<? extends Annotation>, Annotation> annotations;

    AnnotatedTypeImpl(Type type2) {
        this(type2, new Annotation[0]);
    }

    AnnotatedTypeImpl(Type type2, Annotation[] annotations2) {
        this.type = Objects.requireNonNull(type2);
        this.annotations = this.toMap(annotations2);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return (T)this.annotations.get(annotationClass);
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations.values().toArray(new Annotation[0]);
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        return this.getAnnotations();
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AnnotatedType)) {
            return false;
        }
        AnnotatedType that = (AnnotatedType)other;
        return this.getType().equals(that.getType()) && Arrays.equals(this.getAnnotations(), that.getAnnotations());
    }

    public int hashCode() {
        return 127 * this.getType().hashCode() ^ Arrays.hashCode(this.getAnnotations());
    }

    public String toString() {
        return this.annotationsString() + GenericTypeReflector.getTypeName(this.type);
    }

    String annotationsString() {
        return this.annotations.isEmpty() ? "" : this.annotations.values().stream().map(Annotation::toString).collect(Collectors.joining(", ")) + " ";
    }

    String typesString(AnnotatedType[] types) {
        return Arrays.stream(types).map(Object::toString).collect(Collectors.joining(", "));
    }

    protected Map<Class<? extends Annotation>, Annotation> toMap(Annotation[] annotations2) {
        LinkedHashMap<Class<? extends Annotation>, Annotation> map2 = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        for (Annotation annotation : annotations2) {
            map2.put(annotation.annotationType(), annotation);
        }
        return Collections.unmodifiableMap(map2);
    }
}

