/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.geantyref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import org.pkl.thirdparty.geantyref.AnnotatedTypeImpl;
import org.pkl.thirdparty.geantyref.GenericTypeReflector;

class AnnotatedWildcardTypeImpl
extends AnnotatedTypeImpl
implements AnnotatedWildcardType {
    private final AnnotatedType[] lowerBounds;
    private final AnnotatedType[] upperBounds;

    AnnotatedWildcardTypeImpl(WildcardType type2, Annotation[] annotations2, AnnotatedType[] lowerBounds, AnnotatedType[] upperBounds2) {
        super(type2, annotations2);
        if (lowerBounds == null || lowerBounds.length == 0) {
            lowerBounds = new AnnotatedType[]{};
        }
        if (upperBounds2 == null || upperBounds2.length == 0) {
            upperBounds2 = new AnnotatedType[]{GenericTypeReflector.annotate(Object.class)};
        }
        AnnotatedWildcardTypeImpl.validateBounds(type2, lowerBounds, upperBounds2);
        this.lowerBounds = lowerBounds;
        this.upperBounds = upperBounds2;
    }

    @Override
    public AnnotatedType[] getAnnotatedLowerBounds() {
        return this.lowerBounds;
    }

    @Override
    public AnnotatedType[] getAnnotatedUpperBounds() {
        return this.upperBounds;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof AnnotatedWildcardType) || !super.equals(other)) {
            return false;
        }
        return GenericTypeReflector.typeArraysEqual(this.lowerBounds, ((AnnotatedWildcardType)other).getAnnotatedLowerBounds()) && GenericTypeReflector.typeArraysEqual(this.upperBounds, ((AnnotatedWildcardType)other).getAnnotatedUpperBounds());
    }

    @Override
    public int hashCode() {
        return 127 * super.hashCode() ^ GenericTypeReflector.hashCode(this.lowerBounds) + GenericTypeReflector.hashCode(this.upperBounds);
    }

    @Override
    public String toString() {
        if (this.lowerBounds.length > 0) {
            return this.annotationsString() + "? super " + this.typesString(this.lowerBounds);
        }
        if (this.upperBounds.length == 0 || this.upperBounds[0].getType() == Object.class) {
            return this.annotationsString() + "?";
        }
        return this.annotationsString() + "? extends " + this.typesString(this.upperBounds);
    }

    private static void validateBounds(WildcardType type2, AnnotatedType[] lowerBounds, AnnotatedType[] upperBounds2) {
        int i2;
        if (type2.getLowerBounds().length != lowerBounds.length) {
            throw new IllegalArgumentException("Incompatible lower bounds " + Arrays.toString(lowerBounds) + " for type " + type2);
        }
        if (type2.getUpperBounds().length != upperBounds2.length) {
            throw new IllegalArgumentException("Incompatible upper bounds " + Arrays.toString(upperBounds2) + " for type " + type2);
        }
        for (i2 = 0; i2 < type2.getLowerBounds().length; ++i2) {
            if (GenericTypeReflector.erase(type2.getLowerBounds()[i2]) == GenericTypeReflector.erase(lowerBounds[i2].getType())) continue;
            throw new IllegalArgumentException("Bound " + lowerBounds[i2].getType() + " incompatible with " + type2.getLowerBounds()[i2] + " in type " + type2);
        }
        for (i2 = 0; i2 < type2.getUpperBounds().length; ++i2) {
            if (GenericTypeReflector.erase(type2.getUpperBounds()[i2]) == GenericTypeReflector.erase(upperBounds2[i2].getType())) continue;
            throw new IllegalArgumentException("Bound " + upperBounds2[i2].getType() + " incompatible with " + type2.getUpperBounds()[i2] + " in type " + type2);
        }
    }
}

