/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.geantyref;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Stream;
import org.pkl.thirdparty.geantyref.AnnotatedArrayTypeImpl;
import org.pkl.thirdparty.geantyref.AnnotatedCaptureType;
import org.pkl.thirdparty.geantyref.AnnotatedCaptureTypeImpl;
import org.pkl.thirdparty.geantyref.AnnotatedParameterizedTypeImpl;
import org.pkl.thirdparty.geantyref.AnnotatedTypeImpl;
import org.pkl.thirdparty.geantyref.AnnotatedTypeVariableImpl;
import org.pkl.thirdparty.geantyref.AnnotatedWildcardTypeImpl;
import org.pkl.thirdparty.geantyref.CaptureType;
import org.pkl.thirdparty.geantyref.GenericArrayTypeImpl;
import org.pkl.thirdparty.geantyref.ParameterizedTypeImpl;
import org.pkl.thirdparty.geantyref.TypeFactory;
import org.pkl.thirdparty.geantyref.TypeVisitor;
import org.pkl.thirdparty.geantyref.UnresolvedTypeVariableException;
import org.pkl.thirdparty.geantyref.VarMap;
import org.pkl.thirdparty.geantyref.WildcardTypeImpl;

public class GenericTypeReflector {
    private static final WildcardType UNBOUND_WILDCARD = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);
    private static final Map<Class<?>, Class<?>> BOX_TYPES;

    public static Class<?> erase(Type type2) {
        if (type2 instanceof Class) {
            return (Class)type2;
        }
        if (type2 instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type2).getRawType();
        }
        if (type2 instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type2;
            if (tv.getBounds().length == 0) {
                return Object.class;
            }
            return GenericTypeReflector.erase(tv.getBounds()[0]);
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type2;
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.erase(aType.getGenericComponentType()));
        }
        if (type2 instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type2;
            Type[] lowerBounds = wildcardType.getLowerBounds();
            return GenericTypeReflector.erase(lowerBounds.length > 0 ? lowerBounds[0] : wildcardType.getUpperBounds()[0]);
        }
        if (type2 instanceof CaptureType) {
            CaptureType captureType = (CaptureType)type2;
            Type[] lowerBounds = captureType.getLowerBounds();
            return GenericTypeReflector.erase(lowerBounds.length > 0 ? lowerBounds[0] : captureType.getUpperBounds()[0]);
        }
        throw new RuntimeException("not supported: " + type2.getClass());
    }

    public static Type box(Type type2) {
        Class<?> boxed = BOX_TYPES.get(type2);
        return boxed != null ? boxed : type2;
    }

    public static boolean isBoxType(Type type2) {
        return BOX_TYPES.containsValue(type2);
    }

    public static boolean isFullyBound(Type type2) {
        if (type2 instanceof Class) {
            return true;
        }
        if (type2 instanceof ParameterizedType) {
            return Arrays.stream(((ParameterizedType)type2).getActualTypeArguments()).allMatch(GenericTypeReflector::isFullyBound);
        }
        if (type2 instanceof GenericArrayType) {
            return GenericTypeReflector.isFullyBound(((GenericArrayType)type2).getGenericComponentType());
        }
        return false;
    }

    private static AnnotatedType mapTypeParameters(AnnotatedType toMapType, AnnotatedType typeAndParams) {
        return GenericTypeReflector.mapTypeParameters(toMapType, typeAndParams, VarMap.MappingMode.EXACT);
    }

    private static AnnotatedType mapTypeParameters(AnnotatedType toMapType, AnnotatedType typeAndParams, VarMap.MappingMode mappingMode) {
        if (GenericTypeReflector.isMissingTypeParameters(typeAndParams.getType())) {
            return new AnnotatedTypeImpl(GenericTypeReflector.erase(toMapType.getType()), toMapType.getAnnotations());
        }
        VarMap varMap = new VarMap();
        AnnotatedType handlingTypeAndParams = typeAndParams;
        while (handlingTypeAndParams instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType pType = (AnnotatedParameterizedType)handlingTypeAndParams;
            Class clazz = (Class)((ParameterizedType)pType.getType()).getRawType();
            TypeVariable[] vars = clazz.getTypeParameters();
            varMap.addAll(vars, pType.getAnnotatedActualTypeArguments());
            Type owner = ((ParameterizedType)pType.getType()).getOwnerType();
            handlingTypeAndParams = owner == null ? null : GenericTypeReflector.annotate(owner);
        }
        return varMap.map(toMapType, mappingMode);
    }

    public static AnnotatedType resolveExactType(AnnotatedType unresolved, AnnotatedType typeAndParams) {
        return GenericTypeReflector.resolveType(unresolved, GenericTypeReflector.expandGenerics(typeAndParams), VarMap.MappingMode.EXACT);
    }

    public static Type resolveExactType(Type unresolved, Type typeAndParams) {
        return GenericTypeReflector.resolveType(GenericTypeReflector.annotate(unresolved), GenericTypeReflector.annotate(typeAndParams, true), VarMap.MappingMode.EXACT).getType();
    }

    public static AnnotatedType resolveType(AnnotatedType unresolved, AnnotatedType typeAndParams) {
        return GenericTypeReflector.resolveType(unresolved, GenericTypeReflector.expandGenerics(typeAndParams), VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type resolveType(Type unresolved, Type typeAndParams) {
        return GenericTypeReflector.resolveType(GenericTypeReflector.annotate(unresolved), GenericTypeReflector.annotate(typeAndParams, true), VarMap.MappingMode.ALLOW_INCOMPLETE).getType();
    }

    private static AnnotatedType resolveType(AnnotatedType unresolved, AnnotatedType typeAndParams, VarMap.MappingMode mappingMode) {
        if (unresolved instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)unresolved;
            AnnotatedType[] params = GenericTypeReflector.mapArray(parameterizedType.getAnnotatedActualTypeArguments(), AnnotatedType[]::new, p2 -> GenericTypeReflector.resolveType(p2, typeAndParams, mappingMode));
            return GenericTypeReflector.replaceParameters(parameterizedType, params);
        }
        if (unresolved instanceof AnnotatedWildcardType) {
            AnnotatedType[] lower = GenericTypeReflector.mapArray(((AnnotatedWildcardType)unresolved).getAnnotatedLowerBounds(), AnnotatedType[]::new, b2 -> GenericTypeReflector.resolveType(b2, typeAndParams, mappingMode));
            AnnotatedType[] upper = GenericTypeReflector.mapArray(((AnnotatedWildcardType)unresolved).getAnnotatedUpperBounds(), AnnotatedType[]::new, b2 -> GenericTypeReflector.resolveType(b2, typeAndParams, mappingMode));
            return new AnnotatedWildcardTypeImpl((WildcardType)unresolved.getType(), unresolved.getAnnotations(), lower, upper);
        }
        if (unresolved instanceof AnnotatedTypeVariable) {
            AnnotatedType resolved;
            TypeVariable var = (TypeVariable)unresolved.getType();
            if (var.getGenericDeclaration() instanceof Class && (resolved = GenericTypeReflector.getTypeParameter(typeAndParams, var)) != null) {
                return GenericTypeReflector.updateAnnotations(resolved, unresolved.getAnnotations());
            }
            if (mappingMode.equals((Object)VarMap.MappingMode.ALLOW_INCOMPLETE)) {
                return unresolved;
            }
            throw new IllegalArgumentException("Variable " + var.getName() + " is not declared by the given type " + typeAndParams.getType().getTypeName() + " or its super types");
        }
        if (unresolved instanceof AnnotatedArrayType) {
            AnnotatedType componentType = GenericTypeReflector.resolveType(((AnnotatedArrayType)unresolved).getAnnotatedGenericComponentType(), typeAndParams, mappingMode);
            return new AnnotatedArrayTypeImpl(TypeFactory.arrayOf(componentType.getType()), unresolved.getAnnotations(), componentType);
        }
        return unresolved;
    }

    public static boolean isMissingTypeParameters(Type type2) {
        if (type2 instanceof Class) {
            Class<?> clazz = (Class<?>)type2;
            if (Modifier.isStatic(clazz.getModifiers())) {
                return clazz.getTypeParameters().length != 0;
            }
            for (Class<?> enclosing = clazz; enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                if (enclosing.getTypeParameters().length == 0) continue;
                return true;
            }
            return false;
        }
        if (type2 instanceof ParameterizedType) {
            return false;
        }
        throw new AssertionError((Object)("Unexpected type " + type2.getClass()));
    }

    public static Type addWildcardParameters(Class<?> clazz) {
        if (clazz.isArray()) {
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.addWildcardParameters(clazz.getComponentType()));
        }
        if (GenericTypeReflector.isMissingTypeParameters(clazz)) {
            TypeVariable<Class<?>>[] vars = clazz.getTypeParameters();
            Object[] arguments2 = new Type[vars.length];
            Arrays.fill(arguments2, UNBOUND_WILDCARD);
            Type owner = clazz.getDeclaringClass() == null ? null : GenericTypeReflector.addWildcardParameters(clazz.getDeclaringClass());
            return new ParameterizedTypeImpl(clazz, (Type[])arguments2, owner);
        }
        return clazz;
    }

    public static AnnotatedType getExactSuperType(AnnotatedType subType, Class<?> searchSuperClass) {
        if (subType instanceof AnnotatedParameterizedType || subType.getType() instanceof Class || subType instanceof AnnotatedArrayType) {
            Class<?> superClass = GenericTypeReflector.erase(subType.getType());
            if (searchSuperClass == superClass) {
                return subType;
            }
            if (!searchSuperClass.isAssignableFrom(superClass)) {
                return null;
            }
        }
        for (AnnotatedType superType : GenericTypeReflector.getExactDirectSuperTypes(subType)) {
            AnnotatedType result2 = GenericTypeReflector.getExactSuperType(superType, searchSuperClass);
            if (result2 == null) continue;
            return result2;
        }
        return null;
    }

    public static Type getExactSuperType(Type subType, Class<?> searchSuperClass) {
        AnnotatedType superType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.annotate(subType), searchSuperClass);
        return superType == null ? null : superType.getType();
    }

    public static AnnotatedType getExactSubType(AnnotatedType superType, Class<?> searchSubClass) {
        Type subType = searchSubClass;
        if (searchSubClass.getTypeParameters().length > 0) {
            subType = TypeFactory.parameterizedClass(searchSubClass, searchSubClass.getTypeParameters());
        }
        AnnotatedType annotatedSubType = GenericTypeReflector.annotate(subType);
        Class<?> rawSuperType = GenericTypeReflector.erase(superType.getType());
        if (searchSubClass.isArray() && superType instanceof AnnotatedArrayType) {
            if (rawSuperType.isAssignableFrom(searchSubClass)) {
                return AnnotatedArrayTypeImpl.createArrayType(GenericTypeReflector.getExactSubType(((AnnotatedArrayType)superType).getAnnotatedGenericComponentType(), searchSubClass.getComponentType()), new Annotation[0]);
            }
            return null;
        }
        if (searchSubClass.getTypeParameters().length == 0) {
            return annotatedSubType;
        }
        if (!(superType instanceof AnnotatedParameterizedType)) {
            return GenericTypeReflector.annotate(searchSubClass);
        }
        AnnotatedParameterizedType parameterizedSuperType = (AnnotatedParameterizedType)superType;
        AnnotatedParameterizedType matched = (AnnotatedParameterizedType)GenericTypeReflector.getExactSuperType(annotatedSubType, rawSuperType);
        if (matched == null) {
            return null;
        }
        VarMap varMap = new VarMap();
        try {
            GenericTypeReflector.extractVariables(parameterizedSuperType, matched, searchSubClass, varMap);
            return varMap.map(annotatedSubType);
        }
        catch (UnresolvedTypeVariableException e2) {
            return GenericTypeReflector.annotate(searchSubClass);
        }
        catch (IllegalArgumentException e3) {
            return null;
        }
    }

    public static Type getExactSubType(Type superType, Class<?> searchSubClass) {
        AnnotatedType resolvedSubtype = GenericTypeReflector.getExactSubType(GenericTypeReflector.annotate(superType), searchSubClass);
        return resolvedSubtype == null ? null : resolvedSubtype.getType();
    }

    public static AnnotatedType getTypeParameter(AnnotatedType type2, TypeVariable<? extends Class<?>> variable) {
        Class<?> clazz = variable.getGenericDeclaration();
        AnnotatedType superType = GenericTypeReflector.getExactSuperType(type2, clazz);
        if (superType instanceof AnnotatedParameterizedType) {
            int index = Arrays.asList(clazz.getTypeParameters()).indexOf(variable);
            AnnotatedType resolvedVarType = ((AnnotatedParameterizedType)superType).getAnnotatedActualTypeArguments()[index];
            return GenericTypeReflector.updateAnnotations(resolvedVarType, variable.getAnnotations());
        }
        return null;
    }

    public static Type getTypeParameter(Type type2, TypeVariable<? extends Class<?>> variable) {
        AnnotatedType typeParameter = GenericTypeReflector.getTypeParameter(GenericTypeReflector.annotate(type2), variable);
        return typeParameter == null ? null : typeParameter.getType();
    }

    public static boolean isSuperType(Type superType, Type subType) {
        if (superType instanceof ParameterizedType || superType instanceof Class || superType instanceof GenericArrayType) {
            Type mappedSubType;
            Class<?> superClass = GenericTypeReflector.erase(superType);
            AnnotatedType annotatedMappedSubType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(GenericTypeReflector.annotate(subType)), superClass);
            Type type2 = mappedSubType = annotatedMappedSubType == null ? null : annotatedMappedSubType.getType();
            if (mappedSubType == null) {
                return false;
            }
            if (superType instanceof Class) {
                return true;
            }
            if (mappedSubType instanceof Class) {
                return true;
            }
            if (mappedSubType instanceof GenericArrayType) {
                Type superComponentType = GenericTypeReflector.getArrayComponentType(superType);
                assert (superComponentType != null);
                Type mappedSubComponentType = GenericTypeReflector.getArrayComponentType(mappedSubType);
                assert (mappedSubComponentType != null);
                return GenericTypeReflector.isSuperType(superComponentType, mappedSubComponentType);
            }
            assert (mappedSubType instanceof ParameterizedType);
            assert (superType instanceof ParameterizedType);
            ParameterizedType pMappedSubType = (ParameterizedType)mappedSubType;
            assert (pMappedSubType.getRawType() == superClass);
            ParameterizedType pSuperType = (ParameterizedType)superType;
            Type[] superTypeArgs = pSuperType.getActualTypeArguments();
            Type[] subTypeArgs = pMappedSubType.getActualTypeArguments();
            assert (superTypeArgs.length == subTypeArgs.length);
            for (int i2 = 0; i2 < superTypeArgs.length; ++i2) {
                if (GenericTypeReflector.contains(superTypeArgs[i2], subTypeArgs[i2])) continue;
                return false;
            }
            return pSuperType.getOwnerType() == null || GenericTypeReflector.isSuperType(pSuperType.getOwnerType(), pMappedSubType.getOwnerType());
        }
        if (superType instanceof CaptureType) {
            if (superType.equals(subType)) {
                return true;
            }
            for (Type lowerBound : ((CaptureType)superType).getLowerBounds()) {
                if (!GenericTypeReflector.isSuperType(lowerBound, subType)) continue;
                return true;
            }
            return false;
        }
        throw new RuntimeException("Type not supported: " + superType.getClass());
    }

    private static boolean isArraySupertype(Type arraySuperType, Type subType) {
        Type superTypeComponent = GenericTypeReflector.getArrayComponentType(arraySuperType);
        assert (superTypeComponent != null);
        Type subTypeComponent = GenericTypeReflector.getArrayComponentType(subType);
        if (subTypeComponent == null) {
            return false;
        }
        return GenericTypeReflector.isSuperType(superTypeComponent, subTypeComponent);
    }

    public static AnnotatedType getArrayComponentType(AnnotatedType type2) {
        if (type2.getType() instanceof Class) {
            Class clazz = (Class)type2.getType();
            return new AnnotatedTypeImpl(clazz.getComponentType(), clazz.getAnnotations());
        }
        if (type2 instanceof AnnotatedArrayType) {
            AnnotatedArrayType aType = (AnnotatedArrayType)type2;
            return aType.getAnnotatedGenericComponentType();
        }
        return null;
    }

    public static Type getArrayComponentType(Type type2) {
        AnnotatedType componentType = GenericTypeReflector.getArrayComponentType(GenericTypeReflector.annotate(type2));
        return componentType == null ? null : componentType.getType();
    }

    private static boolean contains(Type containingType, Type containedType) {
        if (containingType instanceof WildcardType) {
            WildcardType wContainingType = (WildcardType)containingType;
            for (Type upperBound : wContainingType.getUpperBounds()) {
                if (GenericTypeReflector.isSuperType(upperBound, containedType)) continue;
                return false;
            }
            for (Type lowerBound : wContainingType.getLowerBounds()) {
                if (GenericTypeReflector.isSuperType(containedType, lowerBound)) continue;
                return false;
            }
            return true;
        }
        return containingType.equals(containedType);
    }

    private static void extractVariables(AnnotatedParameterizedType resolvedTyped, AnnotatedParameterizedType unresolvedType, Class<?> declaringClass, VarMap variables) {
        for (int i2 = 0; i2 < resolvedTyped.getAnnotatedActualTypeArguments().length; ++i2) {
            AnnotatedType unresolvedParam = unresolvedType.getAnnotatedActualTypeArguments()[i2];
            AnnotatedType resolvedParam = resolvedTyped.getAnnotatedActualTypeArguments()[i2];
            Type var = unresolvedParam.getType();
            if (var instanceof TypeVariable && ((TypeVariable)var).getGenericDeclaration() == declaringClass) {
                variables.add((TypeVariable)var, resolvedParam);
                continue;
            }
            if (!(unresolvedParam instanceof AnnotatedParameterizedType)) continue;
            if (!(resolvedParam instanceof AnnotatedParameterizedType) || !GenericTypeReflector.erase(unresolvedParam.getType()).equals(GenericTypeReflector.erase(resolvedParam.getType()))) {
                throw new IllegalArgumentException("The provided types do not match in shape");
            }
            GenericTypeReflector.extractVariables((AnnotatedParameterizedType)resolvedParam, (AnnotatedParameterizedType)unresolvedParam, declaringClass, variables);
        }
    }

    private static AnnotatedType[] getExactDirectSuperTypes(AnnotatedType type2) {
        if (type2 instanceof AnnotatedParameterizedType || type2 != null && type2.getType() instanceof Class) {
            int resultIndex;
            AnnotatedType[] result2;
            Class clazz;
            if (type2 instanceof AnnotatedParameterizedType) {
                clazz = (Class)((ParameterizedType)type2.getType()).getRawType();
            } else {
                clazz = (Class)type2.getType();
                if (clazz.isArray()) {
                    return GenericTypeReflector.getArrayExactDirectSuperTypes(GenericTypeReflector.annotate(clazz));
                }
            }
            AnnotatedType[] superInterfaces = clazz.getAnnotatedInterfaces();
            AnnotatedType superClass = clazz.getAnnotatedSuperclass();
            if (superClass == null && superInterfaces.length == 0 && clazz.isInterface()) {
                return new AnnotatedType[]{new AnnotatedTypeImpl((Type)((Object)Object.class))};
            }
            if (superClass == null) {
                result2 = new AnnotatedType[superInterfaces.length];
                resultIndex = 0;
            } else {
                result2 = new AnnotatedType[superInterfaces.length + 1];
                resultIndex = 1;
                result2[0] = GenericTypeReflector.mapTypeParameters(superClass, type2);
            }
            for (AnnotatedType superInterface : superInterfaces) {
                result2[resultIndex++] = GenericTypeReflector.mapTypeParameters(superInterface, type2);
            }
            return result2;
        }
        if (type2 instanceof AnnotatedTypeVariable) {
            AnnotatedTypeVariable tv = (AnnotatedTypeVariable)type2;
            return tv.getAnnotatedBounds();
        }
        if (type2 instanceof AnnotatedWildcardType) {
            return ((AnnotatedWildcardType)type2).getAnnotatedUpperBounds();
        }
        if (type2 instanceof AnnotatedCaptureTypeImpl) {
            return ((AnnotatedCaptureTypeImpl)type2).getAnnotatedUpperBounds();
        }
        if (type2 instanceof AnnotatedArrayType) {
            return GenericTypeReflector.getArrayExactDirectSuperTypes(type2);
        }
        if (type2 == null) {
            throw new NullPointerException();
        }
        throw new RuntimeException("not implemented type: " + type2);
    }

    private static AnnotatedType[] getArrayExactDirectSuperTypes(AnnotatedType arrayType) {
        AnnotatedType[] result2;
        int resultIndex;
        AnnotatedType typeComponent = GenericTypeReflector.getArrayComponentType(arrayType);
        if (typeComponent != null && typeComponent.getType() instanceof Class && ((Class)typeComponent.getType()).isPrimitive()) {
            resultIndex = 0;
            result2 = new AnnotatedType[3];
        } else {
            AnnotatedType[] componentSupertypes = GenericTypeReflector.getExactDirectSuperTypes(typeComponent);
            result2 = new AnnotatedType[componentSupertypes.length + 3];
            for (resultIndex = 0; resultIndex < componentSupertypes.length; ++resultIndex) {
                result2[resultIndex] = AnnotatedArrayTypeImpl.createArrayType(componentSupertypes[resultIndex], new Annotation[0]);
            }
        }
        result2[resultIndex++] = new AnnotatedTypeImpl((Type)((Object)Object.class));
        result2[resultIndex++] = new AnnotatedTypeImpl((Type)((Object)Cloneable.class));
        result2[resultIndex++] = new AnnotatedTypeImpl((Type)((Object)Serializable.class));
        return result2;
    }

    public static AnnotatedType getExactReturnType(Method m, AnnotatedType declaringType) {
        return GenericTypeReflector.getReturnType(m, declaringType, VarMap.MappingMode.EXACT);
    }

    public static Type getExactReturnType(Method m, Type declaringType) {
        return GenericTypeReflector.getExactReturnType(m, GenericTypeReflector.annotate(declaringType)).getType();
    }

    public static AnnotatedType getReturnType(Method m, AnnotatedType declaringType) {
        return GenericTypeReflector.getReturnType(m, declaringType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type getReturnType(Method m, Type declaringType) {
        return GenericTypeReflector.getReturnType(m, GenericTypeReflector.annotate(declaringType)).getType();
    }

    private static AnnotatedType getReturnType(Method m, AnnotatedType declaringType, VarMap.MappingMode mappingMode) {
        AnnotatedType returnType = m.getAnnotatedReturnType();
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(declaringType), m.getDeclaringClass());
        if (exactDeclaringType == null) {
            throw new IllegalArgumentException("The method " + m + " is not a member of type " + declaringType);
        }
        return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType, mappingMode);
    }

    public static AnnotatedType getExactFieldType(Field f, AnnotatedType declaringType) {
        return GenericTypeReflector.getFieldType(f, declaringType, VarMap.MappingMode.EXACT);
    }

    public static Type getExactFieldType(Field f, Type type2) {
        return GenericTypeReflector.getExactFieldType(f, GenericTypeReflector.annotate(type2)).getType();
    }

    public static AnnotatedType getFieldType(Field f, AnnotatedType declaringType) {
        return GenericTypeReflector.getFieldType(f, declaringType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type getFieldType(Field f, Type type2) {
        return GenericTypeReflector.getFieldType(f, GenericTypeReflector.annotate(type2)).getType();
    }

    private static AnnotatedType getFieldType(Field f, AnnotatedType declaringType, VarMap.MappingMode mappingMode) {
        AnnotatedType returnType = f.getAnnotatedType();
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(declaringType), f.getDeclaringClass());
        if (exactDeclaringType == null) {
            throw new IllegalArgumentException("The field " + f + " is not a member of type " + declaringType);
        }
        return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType, mappingMode);
    }

    public static AnnotatedType[] getExactParameterTypes(Executable exe, AnnotatedType declaringType) {
        return GenericTypeReflector.getParameterTypes(exe, declaringType, VarMap.MappingMode.EXACT);
    }

    public static Type[] getExactParameterTypes(Executable exe, Type declaringType) {
        return GenericTypeReflector.mapArray(GenericTypeReflector.getExactParameterTypes(exe, GenericTypeReflector.annotate(declaringType)), Type[]::new, AnnotatedType::getType);
    }

    public static AnnotatedType[] getParameterTypes(Executable exe, AnnotatedType declaringType) {
        return GenericTypeReflector.getParameterTypes(exe, declaringType, VarMap.MappingMode.ALLOW_INCOMPLETE);
    }

    public static Type[] getParameterTypes(Executable exe, Type declaringType) {
        return GenericTypeReflector.mapArray(GenericTypeReflector.getParameterTypes(exe, GenericTypeReflector.annotate(declaringType)), Type[]::new, AnnotatedType::getType);
    }

    private static AnnotatedType[] getParameterTypes(Executable exe, AnnotatedType declaringType, VarMap.MappingMode mappingMode) {
        AnnotatedType[] parameterTypes = exe.getAnnotatedParameterTypes();
        AnnotatedType exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(declaringType), exe.getDeclaringClass());
        if (exactDeclaringType == null) {
            throw new IllegalArgumentException("The method/constructor " + exe + " is not a member of type " + declaringType);
        }
        AnnotatedType[] result2 = new AnnotatedType[parameterTypes.length];
        for (int i2 = 0; i2 < parameterTypes.length; ++i2) {
            result2[i2] = GenericTypeReflector.mapTypeParameters(parameterTypes[i2], exactDeclaringType, mappingMode);
        }
        return result2;
    }

    public static AnnotatedType capture(AnnotatedType type2) {
        if (type2 instanceof AnnotatedParameterizedType) {
            return GenericTypeReflector.capture((AnnotatedParameterizedType)type2);
        }
        return type2;
    }

    public static AnnotatedParameterizedType capture(AnnotatedParameterizedType type2) {
        VarMap varMap = new VarMap();
        ArrayList<AnnotatedCaptureTypeImpl> toInit = new ArrayList<AnnotatedCaptureTypeImpl>();
        Class clazz = (Class)((ParameterizedType)type2.getType()).getRawType();
        AnnotatedType[] arguments2 = type2.getAnnotatedActualTypeArguments();
        TypeVariable<Class<T>>[] vars = clazz.getTypeParameters();
        AnnotatedType[] capturedArguments = new AnnotatedType[arguments2.length];
        assert (arguments2.length == vars.length);
        for (int i2 = 0; i2 < arguments2.length; ++i2) {
            AnnotatedType argument2 = arguments2[i2];
            if (argument2 instanceof AnnotatedWildcardType) {
                AnnotatedCaptureTypeImpl captured = new AnnotatedCaptureTypeImpl((AnnotatedWildcardType)argument2, new AnnotatedTypeVariableImpl(vars[i2]));
                argument2 = captured;
                toInit.add(captured);
            }
            capturedArguments[i2] = argument2;
            varMap.add(vars[i2], argument2);
        }
        for (AnnotatedCaptureTypeImpl captured : toInit) {
            captured.init(varMap);
        }
        ParameterizedType inner = (ParameterizedType)type2.getType();
        AnnotatedType ownerType = inner.getOwnerType() == null ? null : GenericTypeReflector.capture(GenericTypeReflector.annotate(inner.getOwnerType()));
        Type[] rawArgs = GenericTypeReflector.mapArray(capturedArguments, Type[]::new, AnnotatedType::getType);
        ParameterizedTypeImpl nn = new ParameterizedTypeImpl(clazz, rawArgs, ownerType == null ? null : ownerType.getType());
        return new AnnotatedParameterizedTypeImpl(nn, type2.getAnnotations(), capturedArguments);
    }

    public static String getTypeName(Type type2) {
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            return clazz.isArray() ? GenericTypeReflector.getTypeName(clazz.getComponentType()) + "[]" : clazz.getName();
        }
        return type2.toString();
    }

    public static List<Class<?>> getUpperBoundClassAndInterfaces(Type type2) {
        LinkedHashSet result2 = new LinkedHashSet();
        GenericTypeReflector.buildUpperBoundClassAndInterfaces(type2, result2);
        return new ArrayList(result2);
    }

    private static AnnotatedType annotate(Type type2, boolean expandGenerics) {
        return GenericTypeReflector.annotate(type2, expandGenerics, new HashMap<CaptureCacheKey, AnnotatedType>());
    }

    public static AnnotatedType annotate(Type type2) {
        return GenericTypeReflector.annotate(type2, false);
    }

    public static AnnotatedType annotate(Type type2, Annotation[] annotations2) {
        return GenericTypeReflector.updateAnnotations(GenericTypeReflector.annotate(type2), annotations2);
    }

    private static AnnotatedType annotate(Type type2, boolean expandGenerics, Map<CaptureCacheKey, AnnotatedType> cache2) {
        if (type2 instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type2;
            AnnotatedType[] params = new AnnotatedType[parameterized.getActualTypeArguments().length];
            for (int i2 = 0; i2 < params.length; ++i2) {
                AnnotatedType param2 = GenericTypeReflector.annotate(parameterized.getActualTypeArguments()[i2], expandGenerics, cache2);
                params[i2] = GenericTypeReflector.updateAnnotations(param2, GenericTypeReflector.erase(type2).getTypeParameters()[i2].getAnnotations());
            }
            return new AnnotatedParameterizedTypeImpl(parameterized, GenericTypeReflector.erase(type2).getAnnotations(), params);
        }
        if (type2 instanceof CaptureType) {
            CaptureCacheKey key2 = new CaptureCacheKey((CaptureType)type2);
            if (cache2.containsKey(key2)) {
                return cache2.get(key2);
            }
            CaptureType capture = (CaptureType)type2;
            AnnotatedCaptureTypeImpl annotatedCapture = new AnnotatedCaptureTypeImpl(capture, (AnnotatedWildcardType)GenericTypeReflector.annotate(capture.getWildcardType(), expandGenerics, cache2), (AnnotatedTypeVariable)GenericTypeReflector.annotate(capture.getTypeVariable(), expandGenerics, cache2));
            cache2.put(new CaptureCacheKey(capture), annotatedCapture);
            AnnotatedType[] upperBounds2 = GenericTypeReflector.mapArray(capture.getUpperBounds(), AnnotatedType[]::new, bound -> GenericTypeReflector.annotate(bound, expandGenerics, cache2));
            annotatedCapture.setAnnotatedUpperBounds(upperBounds2);
            return annotatedCapture;
        }
        if (type2 instanceof WildcardType) {
            WildcardType wildcard = (WildcardType)type2;
            AnnotatedType[] lowerBounds = GenericTypeReflector.mapArray(wildcard.getLowerBounds(), AnnotatedType[]::new, bound -> GenericTypeReflector.annotate(bound, expandGenerics, cache2));
            AnnotatedType[] upperBounds3 = GenericTypeReflector.mapArray(wildcard.getUpperBounds(), AnnotatedType[]::new, bound -> GenericTypeReflector.annotate(bound, expandGenerics, cache2));
            return new AnnotatedWildcardTypeImpl(wildcard, GenericTypeReflector.erase(type2).getAnnotations(), lowerBounds, upperBounds3);
        }
        if (type2 instanceof TypeVariable) {
            return new AnnotatedTypeVariableImpl((TypeVariable)type2);
        }
        if (type2 instanceof GenericArrayType) {
            GenericArrayType genArray = (GenericArrayType)type2;
            return new AnnotatedArrayTypeImpl(genArray, new Annotation[0], GenericTypeReflector.annotate(genArray.getGenericComponentType(), expandGenerics, cache2));
        }
        if (type2 instanceof Class) {
            Class clazz = (Class)type2;
            if (clazz.isArray()) {
                Class<?> componentClass = clazz.getComponentType();
                return AnnotatedArrayTypeImpl.createArrayType(new AnnotatedTypeImpl(componentClass, componentClass.getAnnotations()), new Annotation[0]);
            }
            if (clazz.getTypeParameters().length > 0 && expandGenerics) {
                return GenericTypeReflector.expandClassGenerics(clazz);
            }
            return new AnnotatedTypeImpl(clazz, clazz.getAnnotations());
        }
        throw new IllegalArgumentException("Unrecognized type: " + type2.getTypeName());
    }

    public static <T extends AnnotatedType> T replaceAnnotations(T original, Annotation[] annotations2) {
        if (original instanceof AnnotatedParameterizedType) {
            return (T)new AnnotatedParameterizedTypeImpl((ParameterizedType)original.getType(), annotations2, ((AnnotatedParameterizedType)original).getAnnotatedActualTypeArguments());
        }
        if (original instanceof AnnotatedCaptureType) {
            AnnotatedCaptureTypeImpl capture = (AnnotatedCaptureTypeImpl)original;
            return (T)capture.setAnnotations(annotations2);
        }
        if (original instanceof AnnotatedWildcardType) {
            return (T)new AnnotatedWildcardTypeImpl((WildcardType)original.getType(), annotations2, ((AnnotatedWildcardType)original).getAnnotatedLowerBounds(), ((AnnotatedWildcardType)original).getAnnotatedUpperBounds());
        }
        if (original instanceof AnnotatedTypeVariable) {
            return (T)new AnnotatedTypeVariableImpl((TypeVariable)original.getType(), annotations2);
        }
        if (original instanceof AnnotatedArrayType) {
            return (T)new AnnotatedArrayTypeImpl(original.getType(), annotations2, ((AnnotatedArrayType)original).getAnnotatedGenericComponentType());
        }
        return (T)new AnnotatedTypeImpl(original.getType(), annotations2);
    }

    public static <T extends AnnotatedType> T updateAnnotations(T original, Annotation[] annotations2) {
        if (annotations2 == null || annotations2.length == 0 || Arrays.equals(original.getAnnotations(), annotations2)) {
            return original;
        }
        return GenericTypeReflector.replaceAnnotations(original, GenericTypeReflector.merge(original.getAnnotations(), annotations2));
    }

    public static <T extends AnnotatedType> T mergeAnnotations(T t1, T t2) {
        Annotation[] merged = GenericTypeReflector.merge(t1.getAnnotations(), t2.getAnnotations());
        if (t1 instanceof AnnotatedParameterizedType) {
            AnnotatedType[] p1 = ((AnnotatedParameterizedType)t1).getAnnotatedActualTypeArguments();
            AnnotatedType[] p2 = ((AnnotatedParameterizedType)t2).getAnnotatedActualTypeArguments();
            AnnotatedType[] params = new AnnotatedType[p1.length];
            for (int i2 = 0; i2 < p1.length; ++i2) {
                params[i2] = GenericTypeReflector.mergeAnnotations(p1[i2], p2[i2]);
            }
            return (T)new AnnotatedParameterizedTypeImpl((ParameterizedType)t1.getType(), merged, params);
        }
        if (t1 instanceof AnnotatedWildcardType) {
            AnnotatedType[] l1 = ((AnnotatedWildcardType)t1).getAnnotatedLowerBounds();
            AnnotatedType[] l2 = ((AnnotatedWildcardType)t2).getAnnotatedLowerBounds();
            AnnotatedType[] lowerBounds = new AnnotatedType[l1.length];
            for (int i3 = 0; i3 < l1.length; ++i3) {
                lowerBounds[i3] = GenericTypeReflector.mergeAnnotations(l1[i3], l2[i3]);
            }
            AnnotatedType[] u1 = ((AnnotatedWildcardType)t1).getAnnotatedUpperBounds();
            AnnotatedType[] u2 = ((AnnotatedWildcardType)t2).getAnnotatedUpperBounds();
            AnnotatedType[] upperBounds2 = new AnnotatedType[u1.length];
            for (int i4 = 0; i4 < u1.length; ++i4) {
                upperBounds2[i4] = GenericTypeReflector.mergeAnnotations(u1[i4], u2[i4]);
            }
            return (T)new AnnotatedWildcardTypeImpl((WildcardType)t1.getType(), merged, lowerBounds, upperBounds2);
        }
        if (t1 instanceof AnnotatedTypeVariable) {
            return (T)new AnnotatedTypeVariableImpl((TypeVariable)t1.getType(), merged);
        }
        if (t1 instanceof AnnotatedArrayType) {
            AnnotatedType componentType = GenericTypeReflector.mergeAnnotations(((AnnotatedArrayType)t1).getAnnotatedGenericComponentType(), ((AnnotatedArrayType)t2).getAnnotatedGenericComponentType());
            return (T)new AnnotatedArrayTypeImpl(t1.getType(), merged, componentType);
        }
        return (T)new AnnotatedTypeImpl(t1.getType(), merged);
    }

    public static AnnotatedParameterizedType replaceParameters(AnnotatedParameterizedType type2, AnnotatedType[] typeParameters2) {
        return GenericTypeReflector.replaceParameters(type2, new Annotation[0], typeParameters2);
    }

    private static AnnotatedParameterizedType replaceParameters(AnnotatedParameterizedType type2, Annotation[] annotations2, AnnotatedType[] typeParameters2) {
        Type[] rawArguments = GenericTypeReflector.mapArray(typeParameters2, Type[]::new, AnnotatedType::getType);
        ParameterizedType inner = (ParameterizedType)type2.getType();
        ParameterizedType rawType = (ParameterizedType)TypeFactory.parameterizedInnerClass(inner.getOwnerType(), GenericTypeReflector.erase(inner), rawArguments);
        return new AnnotatedParameterizedTypeImpl(rawType, GenericTypeReflector.merge(type2.getAnnotations(), annotations2), typeParameters2);
    }

    public static <T extends AnnotatedType> T toCanonical(T type2) {
        return GenericTypeReflector.toCanonical(type2, Function.identity());
    }

    public static <T extends AnnotatedType> T toCanonicalBoxed(T type2) {
        return GenericTypeReflector.toCanonical(type2, GenericTypeReflector::box);
    }

    private static <T extends AnnotatedType> T toCanonical(T type2, final Function<Type, Type> leafTransformer) {
        return (T)GenericTypeReflector.transform(type2, new TypeVisitor(){

            @Override
            protected AnnotatedType visitClass(AnnotatedType type2) {
                Annotation[] annotations2 = type2.getAnnotations();
                Class raw = (Class)type2.getType();
                annotations2 = GenericTypeReflector.merge(annotations2, raw.getAnnotations());
                return new AnnotatedTypeImpl((Type)leafTransformer.apply(type2.getType()), annotations2);
            }

            @Override
            protected AnnotatedType visitArray(AnnotatedArrayType type2) {
                return new AnnotatedArrayTypeImpl((Type)leafTransformer.apply(type2.getType()), type2.getAnnotations(), GenericTypeReflector.transform(type2.getAnnotatedGenericComponentType(), this));
            }

            @Override
            protected AnnotatedType visitParameterizedType(AnnotatedParameterizedType type2) {
                AnnotatedType[] params = (AnnotatedType[])Arrays.stream(type2.getAnnotatedActualTypeArguments()).map(param2 -> GenericTypeReflector.transform(param2, this)).toArray(AnnotatedType[]::new);
                Class raw = (Class)((ParameterizedType)type2.getType()).getRawType();
                return GenericTypeReflector.replaceParameters(type2, raw.getAnnotations(), params);
            }
        });
    }

    private static AnnotatedType expandGenerics(AnnotatedType type2) {
        return GenericTypeReflector.transform(type2, new TypeVisitor(){

            @Override
            public AnnotatedType visitClass(AnnotatedType type2) {
                Class clazz = (Class)type2.getType();
                if (clazz.getTypeParameters().length > 0) {
                    return GenericTypeReflector.expandClassGenerics(clazz);
                }
                return type2;
            }
        });
    }

    public static AnnotatedType transform(AnnotatedType type2, TypeVisitor visitor2) {
        if (type2 instanceof AnnotatedParameterizedType) {
            return visitor2.visitParameterizedType((AnnotatedParameterizedType)type2);
        }
        if (type2 instanceof AnnotatedWildcardType) {
            return visitor2.visitWildcardType((AnnotatedWildcardType)type2);
        }
        if (type2 instanceof AnnotatedTypeVariable) {
            return visitor2.visitVariable((AnnotatedTypeVariable)type2);
        }
        if (type2 instanceof AnnotatedArrayType) {
            return visitor2.visitArray((AnnotatedArrayType)type2);
        }
        if (type2 instanceof AnnotatedCaptureType) {
            return visitor2.visitCaptureType((AnnotatedCaptureType)type2);
        }
        if (type2.getType() instanceof Class) {
            return visitor2.visitClass(type2);
        }
        return visitor2.visitUnmatched(type2);
    }

    public static AnnotatedType reduceBounded(AnnotatedType type2) {
        AnnotatedType capture = GenericTypeReflector.capture(type2);
        return GenericTypeReflector.transform(capture, new TypeVisitor(){

            @Override
            protected AnnotatedType visitVariable(AnnotatedTypeVariable type2) {
                return GenericTypeReflector.updateAnnotations(GenericTypeReflector.transform(type2.getAnnotatedBounds()[0], this), type2.getAnnotations());
            }

            @Override
            protected AnnotatedType visitWildcardType(AnnotatedWildcardType type2) {
                return type2.getAnnotatedLowerBounds().length > 0 ? GenericTypeReflector.updateAnnotations(GenericTypeReflector.transform(type2.getAnnotatedLowerBounds()[0], this), type2.getAnnotations()) : GenericTypeReflector.updateAnnotations(GenericTypeReflector.transform(type2.getAnnotatedUpperBounds()[0], this), type2.getAnnotations());
            }

            @Override
            protected AnnotatedType visitCaptureType(AnnotatedCaptureType type2) {
                AnnotatedType bound;
                AnnotatedType annotatedType = bound = type2.getAnnotatedLowerBounds().length > 0 ? type2.getAnnotatedLowerBounds()[0] : type2.getAnnotatedUpperBounds()[0];
                if (bound instanceof AnnotatedParameterizedType) {
                    AnnotatedType[] typeArguments;
                    for (AnnotatedType typeArgument : typeArguments = ((AnnotatedParameterizedType)bound).getAnnotatedActualTypeArguments()) {
                        if (!type2.equals(typeArgument)) continue;
                        ParameterizedType parameterizedType = (ParameterizedType)bound.getType();
                        return GenericTypeReflector.annotate(parameterizedType.getRawType(), GenericTypeReflector.merge(type2.getAnnotations(), bound.getAnnotations()));
                    }
                }
                return GenericTypeReflector.updateAnnotations(GenericTypeReflector.transform(bound, this), type2.getAnnotations());
            }
        });
    }

    private static AnnotatedParameterizedType expandClassGenerics(Class<?> type2) {
        ParameterizedTypeImpl inner = new ParameterizedTypeImpl(type2, type2.getTypeParameters(), type2.getDeclaringClass());
        AnnotatedType[] params = GenericTypeReflector.mapArray(type2.getTypeParameters(), AnnotatedType[]::new, GenericTypeReflector::annotate);
        return new AnnotatedParameterizedTypeImpl(inner, type2.getAnnotations(), params);
    }

    public static Annotation[] merge(Annotation[] ... annotations2) {
        LinkedHashSet<Annotation> result2 = new LinkedHashSet<Annotation>();
        Annotation[][] annotationArray = annotations2;
        int n = annotationArray.length;
        for (int j = 0; j < n; ++j) {
            Annotation[] annos;
            for (Annotation anno : annos = annotationArray[j]) {
                result2.add(anno);
            }
        }
        return result2.toArray(new Annotation[0]);
    }

    static boolean typeArraysEqual(AnnotatedType[] t1, AnnotatedType[] t2) {
        if (t1 == t2) {
            return true;
        }
        if (t1 == null) {
            return false;
        }
        if (t2 == null) {
            return false;
        }
        if (t1.length != t2.length) {
            return false;
        }
        for (int i2 = 0; i2 < t1.length; ++i2) {
            if (t1[i2].getType().equals(t2[i2].getType()) && Arrays.equals(t1[i2].getAnnotations(), t2[i2].getAnnotations())) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(AnnotatedType ... types) {
        int typeHash = Arrays.stream(types).mapToInt(t -> t.getType().hashCode()).reduce(0, (x, y) -> 127 * x ^ y);
        int annotationHash = GenericTypeReflector.hashCode(Arrays.stream(types).flatMap(t -> Arrays.stream(t.getAnnotations())));
        return 31 * typeHash ^ annotationHash;
    }

    static int hashCode(Stream<Annotation> annotations2) {
        return annotations2.mapToInt(a2 -> 31 * a2.annotationType().hashCode() ^ a2.hashCode()).reduce(0, (x, y) -> 127 * x ^ y);
    }

    public static boolean equals(AnnotatedType t1, AnnotatedType t2) {
        Objects.requireNonNull(t1);
        Objects.requireNonNull(t2);
        t1 = GenericTypeReflector.toCanonical(t1);
        t2 = GenericTypeReflector.toCanonical(t2);
        return t1.equals(t2);
    }

    private static void buildUpperBoundClassAndInterfaces(Type type2, Set<Class<?>> result2) {
        if (type2 instanceof ParameterizedType || type2 instanceof Class) {
            result2.add(GenericTypeReflector.erase(type2));
            return;
        }
        for (AnnotatedType superType : GenericTypeReflector.getExactDirectSuperTypes(GenericTypeReflector.annotate(type2))) {
            GenericTypeReflector.buildUpperBoundClassAndInterfaces(superType.getType(), result2);
        }
    }

    private static <I, O> O[] mapArray(I[] array, IntFunction<O[]> resultCtor, Function<I, O> mapper) {
        O[] result2 = resultCtor.apply(array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            result2[i2] = mapper.apply(array[i2]);
        }
        return result2;
    }

    static {
        HashMap<Class<Object>, Class<Void>> boxTypes = new HashMap<Class<Object>, Class<Void>>();
        boxTypes.put(Boolean.TYPE, Boolean.class);
        boxTypes.put(Byte.TYPE, Byte.class);
        boxTypes.put(Character.TYPE, Character.class);
        boxTypes.put(Double.TYPE, Double.class);
        boxTypes.put(Float.TYPE, Float.class);
        boxTypes.put(Integer.TYPE, Integer.class);
        boxTypes.put(Long.TYPE, Long.class);
        boxTypes.put(Short.TYPE, Short.class);
        boxTypes.put(Void.TYPE, Void.class);
        BOX_TYPES = Collections.unmodifiableMap(boxTypes);
    }

    static class CaptureCacheKey {
        CaptureType capture;

        CaptureCacheKey(CaptureType capture) {
            this.capture = capture;
        }

        public int hashCode() {
            return 127 * this.capture.getWildcardType().hashCode() ^ this.capture.getTypeVariable().hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CaptureCacheKey)) {
                return false;
            }
            CaptureType that = ((CaptureCacheKey)obj).capture;
            return this.capture == that || this.capture.getWildcardType().equals(that.getWildcardType()) && this.capture.getTypeVariable().equals(that.getTypeVariable()) && Arrays.equals(this.capture.getUpperBounds(), that.getUpperBounds());
        }
    }

    private static class AnnotatedCaptureCacheKey {
        AnnotatedCaptureType capture;
        CaptureType raw;

        AnnotatedCaptureCacheKey(AnnotatedCaptureType capture) {
            this.capture = capture;
            this.raw = (CaptureType)capture.getType();
        }

        public int hashCode() {
            return 127 * this.raw.getWildcardType().hashCode() ^ this.raw.getTypeVariable().hashCode() ^ GenericTypeReflector.hashCode(Arrays.stream(this.capture.getAnnotations()));
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AnnotatedCaptureCacheKey)) {
                return false;
            }
            AnnotatedCaptureCacheKey that = (AnnotatedCaptureCacheKey)obj;
            return this.capture == that.capture || new CaptureCacheKey(this.raw).equals(new CaptureCacheKey(that.raw)) && Arrays.equals(this.capture.getAnnotations(), that.capture.getAnnotations());
        }
    }
}

