/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.geantyref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.pkl.thirdparty.geantyref.AnnotatedArrayTypeImpl;
import org.pkl.thirdparty.geantyref.AnnotatedParameterizedTypeImpl;
import org.pkl.thirdparty.geantyref.AnnotationFormatException;
import org.pkl.thirdparty.geantyref.AnnotationInvocationHandler;
import org.pkl.thirdparty.geantyref.GenericArrayTypeImpl;
import org.pkl.thirdparty.geantyref.GenericTypeReflector;
import org.pkl.thirdparty.geantyref.ParameterizedTypeImpl;
import org.pkl.thirdparty.geantyref.TypeArgumentNotInBoundException;
import org.pkl.thirdparty.geantyref.VarMap;
import org.pkl.thirdparty.geantyref.WildcardTypeImpl;

public class TypeFactory {
    private static final WildcardType UNBOUND_WILDCARD = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);

    public static Type parameterizedClass(Class<?> clazz, Type ... arguments2) {
        return TypeFactory.parameterizedInnerClass(null, clazz, arguments2);
    }

    public static AnnotatedType annotatedClass(Class<?> clazz, Annotation[] annotations2) {
        return TypeFactory.parameterizedAnnotatedClass(clazz, annotations2, new AnnotatedType[0]);
    }

    public static AnnotatedType parameterizedAnnotatedClass(Class<?> clazz, Annotation[] annotations2, AnnotatedType ... arguments2) {
        return TypeFactory.parameterizedAnnotatedInnerClass(null, clazz, annotations2, arguments2);
    }

    public static AnnotatedType annotatedInnerClass(Type owner, Class<?> clazz, Annotation[] annotations2) {
        return TypeFactory.parameterizedAnnotatedInnerClass(owner, clazz, annotations2, new AnnotatedType[0]);
    }

    public static AnnotatedType parameterizedAnnotatedInnerClass(Type owner, Class<?> clazz, Annotation[] annotations2, AnnotatedType ... arguments2) {
        if (arguments2 == null || arguments2.length == 0) {
            return GenericTypeReflector.annotate(clazz, annotations2);
        }
        Type[] typeArguments = (Type[])Arrays.stream(arguments2).map(AnnotatedType::getType).toArray(Type[]::new);
        return new AnnotatedParameterizedTypeImpl((ParameterizedType)TypeFactory.parameterizedInnerClass(owner, clazz, typeArguments), annotations2, arguments2);
    }

    public static AnnotatedParameterizedType parameterizedAnnotatedType(ParameterizedType type2, Annotation[] typeAnnotations, Annotation[] ... argumentAnnotations) {
        if (argumentAnnotations == null || argumentAnnotations.length == 0) {
            return (AnnotatedParameterizedType)GenericTypeReflector.annotate((Type)type2, typeAnnotations);
        }
        AnnotatedType[] typeArguments = new AnnotatedType[type2.getActualTypeArguments().length];
        for (int i2 = 0; i2 < typeArguments.length; ++i2) {
            Annotation[] annotations2 = argumentAnnotations.length > i2 ? argumentAnnotations[i2] : null;
            typeArguments[i2] = GenericTypeReflector.annotate(type2.getActualTypeArguments()[i2], annotations2);
        }
        return (AnnotatedParameterizedType)TypeFactory.parameterizedAnnotatedClass(GenericTypeReflector.erase(type2), typeAnnotations, typeArguments);
    }

    public static Type innerClass(Type owner, Class<?> clazz) {
        return TypeFactory.parameterizedInnerClass(owner, clazz, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Type parameterizedInnerClass(Type owner, Class<?> clazz, Type ... arguments2) {
        if (clazz.getDeclaringClass() == null && owner != null) {
            throw new IllegalArgumentException("Cannot specify an owner type for a top level class");
        }
        Type realOwner = TypeFactory.transformOwner(owner, clazz);
        if (arguments2 == null) {
            if (clazz.getTypeParameters().length != 0) return clazz;
            arguments2 = new Type[]{};
        } else if (arguments2.length != clazz.getTypeParameters().length) {
            throw new IllegalArgumentException("Incorrect number of type arguments for [" + clazz + "]: expected " + clazz.getTypeParameters().length + ", but got " + arguments2.length);
        }
        if (!GenericTypeReflector.isMissingTypeParameters(clazz)) {
            return clazz;
        }
        if (realOwner != null && !Modifier.isStatic(clazz.getModifiers()) && GenericTypeReflector.isMissingTypeParameters(realOwner)) {
            return clazz;
        }
        ParameterizedTypeImpl result2 = new ParameterizedTypeImpl(clazz, arguments2, realOwner);
        TypeFactory.checkParametersWithinBound(result2);
        return result2;
    }

    private static void checkParametersWithinBound(ParameterizedType type2) {
        Type[] arguments2 = type2.getActualTypeArguments();
        TypeVariable<Class<T>>[] typeParameters2 = ((Class)type2.getRawType()).getTypeParameters();
        VarMap varMap = new VarMap(type2);
        for (int i2 = 0; i2 < arguments2.length; ++i2) {
            for (Type bound : typeParameters2[i2].getBounds()) {
                Type replacedBound = varMap.map(bound);
                if (arguments2[i2] instanceof WildcardType) {
                    WildcardType wildcardTypeParameter = (WildcardType)arguments2[i2];
                    for (Type wildcardUpperBound : wildcardTypeParameter.getUpperBounds()) {
                        if (TypeFactory.couldHaveCommonSubtype(replacedBound, wildcardUpperBound)) continue;
                        throw new TypeArgumentNotInBoundException(arguments2[i2], typeParameters2[i2], bound);
                    }
                    for (Type wildcardLowerBound : wildcardTypeParameter.getLowerBounds()) {
                        if (GenericTypeReflector.isSuperType(replacedBound, wildcardLowerBound)) continue;
                        throw new TypeArgumentNotInBoundException(arguments2[i2], typeParameters2[i2], bound);
                    }
                    continue;
                }
                if (GenericTypeReflector.isSuperType(replacedBound, arguments2[i2])) continue;
                throw new TypeArgumentNotInBoundException(arguments2[i2], typeParameters2[i2], bound);
            }
        }
    }

    private static boolean couldHaveCommonSubtype(Type type1, Type type2) {
        Class<?> erased1 = GenericTypeReflector.erase(type1);
        Class<?> erased2 = GenericTypeReflector.erase(type2);
        return erased1.isInterface() || erased2.isInterface() || erased1.isAssignableFrom(erased2) || erased2.isAssignableFrom(erased1);
    }

    private static Type transformOwner(Type givenOwner, Class<?> clazz) {
        if (givenOwner == null) {
            return clazz.getDeclaringClass();
        }
        Type transformedOwner = GenericTypeReflector.getExactSuperType(GenericTypeReflector.annotate(givenOwner).getType(), clazz.getDeclaringClass());
        if (transformedOwner == null) {
            throw new IllegalArgumentException("Given owner type [" + givenOwner + "] is not appropriate for [" + clazz + "]: it should be a subtype of " + clazz.getDeclaringClass());
        }
        if (Modifier.isStatic(clazz.getModifiers())) {
            return GenericTypeReflector.erase(transformedOwner);
        }
        return transformedOwner;
    }

    public static WildcardType unboundWildcard() {
        return UNBOUND_WILDCARD;
    }

    public static WildcardType wildcardExtends(Type upperBound) {
        if (upperBound == null) {
            throw new NullPointerException();
        }
        return new WildcardTypeImpl(new Type[]{upperBound}, new Type[0]);
    }

    public static WildcardType wildcardSuper(Type lowerBound) {
        if (lowerBound == null) {
            throw new NullPointerException();
        }
        return new WildcardTypeImpl(new Type[]{Object.class}, new Type[]{lowerBound});
    }

    public static Type arrayOf(Type componentType) {
        return GenericArrayTypeImpl.createArrayType(componentType);
    }

    public static AnnotatedArrayType arrayOf(AnnotatedType componentType, Annotation[] annotations2) {
        return AnnotatedArrayTypeImpl.createArrayType(componentType, annotations2);
    }

    public static <A extends Annotation> A annotation(Class<A> annotationType, Map<String, Object> values2) throws AnnotationFormatException {
        return (A)((Annotation)Proxy.newProxyInstance(annotationType.getClassLoader(), new Class[]{annotationType}, (InvocationHandler)new AnnotationInvocationHandler(annotationType, values2 == null ? Collections.emptyMap() : values2)));
    }
}

