/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.geantyref;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedArrayType;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.AnnotatedTypeVariable;
import java.lang.reflect.AnnotatedWildcardType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.pkl.thirdparty.geantyref.AnnotatedArrayTypeImpl;
import org.pkl.thirdparty.geantyref.AnnotatedParameterizedTypeImpl;
import org.pkl.thirdparty.geantyref.AnnotatedTypeVariableImpl;
import org.pkl.thirdparty.geantyref.AnnotatedWildcardTypeImpl;
import org.pkl.thirdparty.geantyref.GenericTypeReflector;
import org.pkl.thirdparty.geantyref.ParameterizedTypeImpl;
import org.pkl.thirdparty.geantyref.TypeVariableImpl;
import org.pkl.thirdparty.geantyref.UnresolvedTypeVariableException;
import org.pkl.thirdparty.geantyref.WildcardTypeImpl;

class VarMap {
    private final Map<TypeVariable, AnnotatedType> map = new HashMap<TypeVariable, AnnotatedType>();

    VarMap() {
    }

    VarMap(AnnotatedParameterizedType type2) {
        Type owner;
        do {
            TypeVariable<Class<T>>[] typeParameters2;
            Class clazz = (Class)((ParameterizedType)type2.getType()).getRawType();
            AnnotatedType[] arguments2 = type2.getAnnotatedActualTypeArguments();
            if (arguments2.length != (typeParameters2 = clazz.getTypeParameters()).length) {
                throw new IllegalStateException("The given type [" + type2 + "] is inconsistent: it has " + arguments2.length + " arguments instead of " + typeParameters2.length);
            }
            for (int i2 = 0; i2 < arguments2.length; ++i2) {
                this.add(typeParameters2[i2], arguments2[i2]);
            }
        } while ((type2 = (owner = ((ParameterizedType)type2.getType()).getOwnerType()) instanceof ParameterizedType ? (AnnotatedParameterizedType)GenericTypeReflector.annotate(owner) : null) != null);
    }

    VarMap(ParameterizedType type2) {
        this((AnnotatedParameterizedType)GenericTypeReflector.annotate(type2));
    }

    VarMap(TypeVariable[] variables, AnnotatedType[] values2) {
        this.addAll(variables, values2);
    }

    void add(TypeVariable variable, AnnotatedType value2) {
        this.map.put(variable, value2);
    }

    void addAll(TypeVariable[] variables, AnnotatedType[] values2) {
        assert (variables.length == values2.length);
        for (int i2 = 0; i2 < variables.length; ++i2) {
            this.map.put(variables[i2], values2[i2]);
        }
    }

    AnnotatedType map(AnnotatedType type2) {
        return this.map(type2, MappingMode.EXACT);
    }

    AnnotatedType map(AnnotatedType type2, MappingMode mappingMode) {
        if (type2.getType() instanceof Class) {
            return GenericTypeReflector.updateAnnotations(type2, ((Class)type2.getType()).getAnnotations());
        }
        if (type2 instanceof AnnotatedTypeVariable) {
            TypeVariable tv = (TypeVariable)type2.getType();
            if (!this.map.containsKey(tv)) {
                if (mappingMode.equals((Object)MappingMode.ALLOW_INCOMPLETE)) {
                    AnnotatedTypeVariable variable = (AnnotatedTypeVariable)type2;
                    AnnotatedType[] bounds = this.map(variable.getAnnotatedBounds(), mappingMode);
                    Annotation[] merged = GenericTypeReflector.merge(variable.getAnnotations(), tv.getAnnotations());
                    TypeVariableImpl v = new TypeVariableImpl(tv, merged, bounds);
                    return new AnnotatedTypeVariableImpl(v, merged);
                }
                throw new UnresolvedTypeVariableException(tv);
            }
            TypeVariable varFromClass = this.map.keySet().stream().filter(key2 -> key2.equals(tv)).findFirst().get();
            Annotation[] merged = GenericTypeReflector.merge(type2.getAnnotations(), tv.getAnnotations(), this.map.get(tv).getAnnotations(), varFromClass.getAnnotations());
            return GenericTypeReflector.updateAnnotations(this.map.get(tv), merged);
        }
        if (type2 instanceof AnnotatedParameterizedType) {
            AnnotatedParameterizedType pType = (AnnotatedParameterizedType)type2;
            ParameterizedType inner = (ParameterizedType)pType.getType();
            Class raw = (Class)inner.getRawType();
            AnnotatedType[] typeParameters2 = new AnnotatedType[raw.getTypeParameters().length];
            for (int i2 = 0; i2 < typeParameters2.length; ++i2) {
                AnnotatedType typeParameter = this.map(pType.getAnnotatedActualTypeArguments()[i2], mappingMode);
                typeParameters2[i2] = GenericTypeReflector.updateAnnotations(typeParameter, raw.getTypeParameters()[i2].getAnnotations());
            }
            Type[] rawArgs = (Type[])Arrays.stream(typeParameters2).map(AnnotatedType::getType).toArray(Type[]::new);
            Type innerOwnerType = inner.getOwnerType() == null ? null : this.map(GenericTypeReflector.annotate(inner.getOwnerType()), mappingMode).getType();
            ParameterizedTypeImpl newInner = new ParameterizedTypeImpl((Class)inner.getRawType(), rawArgs, innerOwnerType);
            return new AnnotatedParameterizedTypeImpl(newInner, GenericTypeReflector.merge(pType.getAnnotations(), raw.getAnnotations()), typeParameters2);
        }
        if (type2 instanceof AnnotatedWildcardType) {
            AnnotatedWildcardType wType = (AnnotatedWildcardType)type2;
            AnnotatedType[] up = this.map(wType.getAnnotatedUpperBounds(), mappingMode);
            AnnotatedType[] lw = this.map(wType.getAnnotatedLowerBounds(), mappingMode);
            Type[] upperBounds2 = up == null || up.length == 0 ? ((WildcardType)wType.getType()).getUpperBounds() : (Type[])Arrays.stream(up).map(AnnotatedType::getType).toArray(Type[]::new);
            WildcardTypeImpl w = new WildcardTypeImpl(upperBounds2, (Type[])Arrays.stream(lw).map(AnnotatedType::getType).toArray(Type[]::new));
            return new AnnotatedWildcardTypeImpl(w, wType.getAnnotations(), lw, up);
        }
        if (type2 instanceof AnnotatedArrayType) {
            return AnnotatedArrayTypeImpl.createArrayType(this.map(((AnnotatedArrayType)type2).getAnnotatedGenericComponentType(), mappingMode), type2.getAnnotations());
        }
        throw new RuntimeException("Not implemented: mapping " + type2.getClass() + " (" + type2 + ")");
    }

    AnnotatedType[] map(AnnotatedType[] types) {
        return this.map(types, MappingMode.EXACT);
    }

    AnnotatedType[] map(AnnotatedType[] types, MappingMode mappingMode) {
        AnnotatedType[] result2 = new AnnotatedType[types.length];
        for (int i2 = 0; i2 < types.length; ++i2) {
            result2[i2] = this.map(types[i2], mappingMode);
        }
        return result2;
    }

    Type[] map(Type[] types) {
        AnnotatedType[] result2 = this.map((AnnotatedType[])Arrays.stream(types).map(GenericTypeReflector::annotate).toArray(AnnotatedType[]::new));
        return (Type[])Arrays.stream(result2).map(AnnotatedType::getType).toArray(Type[]::new);
    }

    Type map(Type type2) {
        return this.map(GenericTypeReflector.annotate(type2)).getType();
    }

    public static enum MappingMode {
        EXACT,
        ALLOW_INCOMPLETE;

    }
}

