/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.graalvm.nativeimage;

import org.pkl.thirdparty.graalvm.nativeimage.ImageSingletons;
import org.pkl.thirdparty.graalvm.nativeimage.impl.UnmanagedMemorySupport;
import org.pkl.thirdparty.graalvm.word.PointerBase;
import org.pkl.thirdparty.graalvm.word.UnsignedWord;
import org.pkl.thirdparty.graalvm.word.WordFactory;

public final class UnmanagedMemory {
    private UnmanagedMemory() {
    }

    public static <T extends PointerBase> T malloc(UnsignedWord size) {
        Object result2 = ImageSingletons.lookup(UnmanagedMemorySupport.class).malloc(size);
        if (result2.isNull()) {
            throw new OutOfMemoryError("malloc of unmanaged memory");
        }
        return result2;
    }

    public static <T extends PointerBase> T malloc(int size) {
        return UnmanagedMemory.malloc(WordFactory.unsigned(size));
    }

    public static <T extends PointerBase> T calloc(UnsignedWord size) {
        Object result2 = ImageSingletons.lookup(UnmanagedMemorySupport.class).calloc(size);
        if (result2.isNull()) {
            throw new OutOfMemoryError("calloc of unmanaged memory");
        }
        return result2;
    }

    public static <T extends PointerBase> T calloc(int size) {
        return UnmanagedMemory.calloc(WordFactory.unsigned(size));
    }

    public static <T extends PointerBase> T realloc(T ptr, UnsignedWord size) {
        T result2 = ImageSingletons.lookup(UnmanagedMemorySupport.class).realloc(ptr, size);
        if (result2.isNull()) {
            throw new OutOfMemoryError("realloc of unmanaged memory");
        }
        return result2;
    }

    public static void free(PointerBase ptr) {
        ImageSingletons.lookup(UnmanagedMemorySupport.class).free(ptr);
    }
}

