/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.graalvm.options;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.pkl.thirdparty.graalvm.options.OptionDescriptor;
import org.pkl.thirdparty.graalvm.options.OptionDescriptors;

class OptionDescriptorsMap
implements OptionDescriptors {
    final Map<String, OptionDescriptor> descriptors = new LinkedHashMap<String, OptionDescriptor>();
    final List<String> prefixes = new ArrayList<String>();

    OptionDescriptorsMap(List<OptionDescriptor> descriptorList) {
        for (OptionDescriptor descriptor2 : descriptorList) {
            if (descriptor2.isOptionMap()) {
                this.prefixes.add(descriptor2.getName());
            }
            this.descriptors.put(descriptor2.getName(), descriptor2);
        }
    }

    @Override
    public OptionDescriptor get(String optionName) {
        if (!this.prefixes.isEmpty()) {
            for (String prefix : this.prefixes) {
                if (!optionName.startsWith(prefix + ".") && !optionName.equals(prefix)) continue;
                return this.descriptors.get(prefix);
            }
        }
        return this.descriptors.get(optionName);
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return this.descriptors.values().iterator();
    }
}

