/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.graalvm.shadowed.org.jcodings;

import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.ApplyAllCaseFoldFunction;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.CaseFoldCodeItem;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.Encoding;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.IntHolder;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.ascii.AsciiTables;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.constants.PosixBracket;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.exception.CharacterPropertyException;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.exception.EncodingError;

abstract class AbstractEncoding
extends Encoding {
    private final short[] CTypeTable;

    protected AbstractEncoding(String name, int minLength, int maxLength, short[] CTypeTable) {
        super(name, minLength, maxLength);
        this.CTypeTable = CTypeTable;
    }

    private static int CTypeToBit(int ctype) {
        return 1 << ctype;
    }

    protected final boolean isCodeCTypeInternal(int code2, int ctype) {
        return (this.CTypeTable[code2] & AbstractEncoding.CTypeToBit(ctype)) != 0;
    }

    @Override
    public boolean isNewLine(byte[] bytes, int p2, int end2) {
        return p2 < end2 ? bytes[p2] == 10 : false;
    }

    protected final int asciiMbcCaseFold(int flag2, byte[] bytes, IntHolder pp, int end2, byte[] lower) {
        lower[0] = AsciiTables.ToLowerCaseTable[bytes[pp.value] & 0xFF];
        ++pp.value;
        return 1;
    }

    @Override
    public int mbcCaseFold(int flag2, byte[] bytes, IntHolder pp, int end2, byte[] lower) {
        return this.asciiMbcCaseFold(flag2, bytes, pp, end2, lower);
    }

    protected final void asciiApplyAllCaseFold(int flag2, ApplyAllCaseFoldFunction fun, Object arg) {
        int[] code2 = new int[]{0};
        for (int i2 = 0; i2 < AsciiTables.LowerMap.length; ++i2) {
            code2[0] = AsciiTables.LowerMap[i2][1];
            fun.apply(AsciiTables.LowerMap[i2][0], code2, 1, arg);
            code2[0] = AsciiTables.LowerMap[i2][0];
            fun.apply(AsciiTables.LowerMap[i2][1], code2, 1, arg);
        }
    }

    @Override
    public void applyAllCaseFold(int flag2, ApplyAllCaseFoldFunction fun, Object arg) {
        this.asciiApplyAllCaseFold(flag2, fun, arg);
    }

    protected final CaseFoldCodeItem[] asciiCaseFoldCodesByString(int flag2, byte[] bytes, int p2, int end2) {
        int b2 = bytes[p2] & 0xFF;
        if (65 <= b2 && b2 <= 90) {
            return new CaseFoldCodeItem[]{CaseFoldCodeItem.create(1, b2 + 32)};
        }
        if (97 <= b2 && b2 <= 122) {
            return new CaseFoldCodeItem[]{CaseFoldCodeItem.create(1, b2 - 32)};
        }
        return CaseFoldCodeItem.EMPTY_FOLD_CODES;
    }

    @Override
    public CaseFoldCodeItem[] caseFoldCodesByString(int flag2, byte[] bytes, int p2, int end2) {
        return this.asciiCaseFoldCodesByString(flag2, bytes, p2, end2);
    }

    int asciiOnlyCaseMap(IntHolder flagP, byte[] bytes, IntHolder pp, int end2, byte[] to, int toP, int toEnd) {
        int toStart = toP;
        int flags = flagP.value;
        while (pp.value < end2 && toP < toEnd) {
            int length2 = this.length(bytes, pp.value, end2);
            if (length2 < 0) {
                return length2;
            }
            int code2 = this.mbcToCode(bytes, pp.value, end2);
            pp.value += length2;
            if (code2 >= 97 && code2 <= 122 && (flags & 0x2000) != 0) {
                flags |= 0x40000;
                code2 -= 32;
            } else if (code2 >= 65 && code2 <= 90 && (flags & 0x84000) != 0) {
                flags |= 0x40000;
                code2 += 32;
            }
            toP += this.codeToMbc(code2, to, toP);
            if ((flags & 0x8000) == 0) continue;
            flags ^= 0xE000;
        }
        flagP.value = flags;
        return toP - toStart;
    }

    int singleByteAsciiOnlyCaseMap(IntHolder flagP, byte[] bytes, IntHolder pp, int end2, byte[] to, int toP, int toEnd) {
        int toStart = toP;
        int flags = flagP.value;
        while (pp.value < end2 && toP < toEnd) {
            int code2;
            if ((code2 = bytes[pp.value++] & 0xFF) >= 97 && code2 <= 122 && (flags & 0x2000) != 0) {
                flags |= 0x40000;
                code2 -= 32;
            } else if (code2 >= 65 && code2 <= 90 && (flags & 0x84000) != 0) {
                flags |= 0x40000;
                code2 += 32;
            }
            to[toP++] = (byte)code2;
            if ((flags & 0x8000) == 0) continue;
            flags ^= 0xE000;
        }
        flagP.value = flags;
        return toP - toStart;
    }

    @Override
    public int propertyNameToCType(byte[] bytes, int p2, int end2) {
        Integer ctype = PosixBracket.PBSTableUpper.get(bytes, p2, end2);
        if (ctype != null) {
            return ctype;
        }
        throw new CharacterPropertyException(EncodingError.ERR_INVALID_CHAR_PROPERTY_NAME, bytes, p2, end2 - p2);
    }
}

