/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.graalvm.shadowed.org.jcodings.specific;

import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.IntHolder;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.ascii.AsciiTables;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.unicode.UnicodeEncoding;

public final class UTF16BEEncoding
extends UnicodeEncoding {
    static final int[] UTF16EncLen = new int[]{2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 4, 4, 4, 4, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2};
    public static final UTF16BEEncoding INSTANCE = new UTF16BEEncoding();

    protected UTF16BEEncoding() {
        super("UTF-16BE", 2, 4, UTF16EncLen);
    }

    @Override
    public int length(byte[] bytes, int p2, int end2) {
        int b2 = bytes[p2] & 0xFF;
        if (!UTF16BEEncoding.isSurrogate(b2)) {
            return end2 - p2 >= 2 ? 2 : this.missing(1);
        }
        if (UTF16BEEncoding.isSurrogateFirst(b2)) {
            switch (end2 - p2) {
                case 1: {
                    return this.missing(3);
                }
                case 2: {
                    return this.missing(2);
                }
                case 3: {
                    if (!UTF16BEEncoding.isSurrogateSecond(bytes[p2 + 2] & 0xFF)) break;
                    return this.missing(1);
                }
            }
            if (UTF16BEEncoding.isSurrogateSecond(bytes[p2 + 2] & 0xFF)) {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public boolean isNewLine(byte[] bytes, int p2, int end2) {
        return p2 + 1 < end2 && bytes[p2 + 1] == 10 && bytes[p2] == 0;
    }

    @Override
    public int mbcToCode(byte[] bytes, int p2, int end2) {
        int code2 = UTF16BEEncoding.isSurrogateFirst(bytes[p2] & 0xFF) ? ((((bytes[p2 + 0] & 0xFF) << 8) + (bytes[p2 + 1] & 0xFF) & 0x3FF) << 10) + (((bytes[p2 + 2] & 0xFF) << 8) + (bytes[p2 + 3] & 0xFF) & 0x3FF) + 65536 : (bytes[p2 + 0] & 0xFF) * 256 + (bytes[p2 + 1] & 0xFF);
        return code2;
    }

    @Override
    public int codeToMbcLength(int code2) {
        return code2 > 65535 ? 4 : 2;
    }

    @Override
    public int codeToMbc(int code2, byte[] bytes, int p2) {
        int p_ = p2;
        if (code2 > 65535) {
            int high = (code2 >>> 10) + 55232;
            int low = (code2 & 0x3FF) + 56320;
            bytes[p_++] = (byte)(high >>> 8 & 0xFF);
            bytes[p_++] = (byte)(high & 0xFF);
            bytes[p_++] = (byte)(low >>> 8 & 0xFF);
            bytes[p_] = (byte)(low & 0xFF);
            return 4;
        }
        bytes[p_++] = (byte)((code2 & 0xFF00) >>> 8);
        bytes[p_++] = (byte)(code2 & 0xFF);
        return 2;
    }

    @Override
    public int mbcCaseFold(int flag2, byte[] bytes, IntHolder pp, int end2, byte[] fold2) {
        int p2 = pp.value;
        int foldP = 0;
        if (UTF16BEEncoding.isAscii(bytes[p2 + 1] & 0xFF) && bytes[p2] == 0) {
            fold2[foldP++] = 0;
            fold2[foldP] = AsciiTables.ToLowerCaseTable[bytes[++p2] & 0xFF];
            pp.value += 2;
            return 2;
        }
        return super.mbcCaseFold(flag2, bytes, pp, end2, fold2);
    }

    @Override
    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 0;
        return super.ctypeCodeRange(ctype);
    }

    @Override
    public int leftAdjustCharHead(byte[] bytes, int p2, int s2, int end2) {
        if (s2 <= p2) {
            return s2;
        }
        if ((s2 - p2) % 2 == 1) {
            --s2;
        }
        if (UTF16BEEncoding.isSurrogateSecond(bytes[s2] & 0xFF) && s2 > p2 + 1) {
            s2 -= 2;
        }
        return s2;
    }

    @Override
    public boolean isReverseMatchAllowed(byte[] bytes, int p2, int end2) {
        return false;
    }

    private static boolean isSurrogateFirst(int c) {
        return (c & 0xFC) == 216;
    }

    private static boolean isSurrogateSecond(int c) {
        return (c & 0xFC) == 220;
    }

    private static boolean isSurrogate(int c) {
        return (c & 0xF8) == 216;
    }
}

