/*
 * Decompiled with CFR 0.152.
 */
package org.pkl.thirdparty.graalvm.shadowed.org.jcodings.specific;

import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.IntHolder;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.ascii.AsciiTables;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.specific.UTF16BEEncoding;
import org.pkl.thirdparty.graalvm.shadowed.org.jcodings.unicode.UnicodeEncoding;

public final class UTF16LEEncoding
extends UnicodeEncoding {
    public static final UTF16LEEncoding INSTANCE = new UTF16LEEncoding();

    protected UTF16LEEncoding() {
        super("UTF-16LE", 2, 4, UTF16BEEncoding.UTF16EncLen);
    }

    @Override
    public int length(byte c) {
        return this.EncLen[(c & 0xFF) + 1];
    }

    @Override
    public int length(byte[] bytes, int p2, int end2) {
        int length2 = end2 - p2;
        if (length2 < 2) {
            return this.missing(1);
        }
        int b2 = bytes[p2 + 1] & 0xFF;
        if (!UTF16LEEncoding.isSurrogate(b2)) {
            return 2;
        }
        if (UTF16LEEncoding.isSurrogateFirst(b2)) {
            if (length2 < 4) {
                return this.missing(4 - length2);
            }
            if (UTF16LEEncoding.isSurrogateSecond(bytes[p2 + 3] & 0xFF)) {
                return 4;
            }
        }
        return -1;
    }

    @Override
    public boolean isNewLine(byte[] bytes, int p2, int end2) {
        return p2 + 1 < end2 && bytes[p2] == 10 && bytes[p2 + 1] == 0;
    }

    @Override
    public int mbcToCode(byte[] bytes, int p2, int end2) {
        int code2;
        if (UTF16LEEncoding.isSurrogateFirst(bytes[p2 + 1] & 0xFF)) {
            int c0 = bytes[p2] & 0xFF;
            int c1 = bytes[p2 + 1] & 0xFF;
            code2 = (((c1 << 8) + c0 & 0x3FF) << 10) + (((bytes[p2 + 3] & 0xFF) << 8) + (bytes[p2 + 2] & 0xFF) & 0x3FF) + 65536;
        } else {
            code2 = (bytes[p2 + 1] & 0xFF) * 256 + (bytes[p2 + 0] & 0xFF);
        }
        return code2;
    }

    @Override
    public int codeToMbcLength(int code2) {
        return code2 > 65535 ? 4 : 2;
    }

    @Override
    public int codeToMbc(int code2, byte[] bytes, int p2) {
        int p_ = p2;
        if (code2 > 65535) {
            int high = (code2 >>> 10) + 55232;
            int low = (code2 & 0x3FF) + 56320;
            bytes[p_++] = (byte)(high & 0xFF);
            bytes[p_++] = (byte)(high >>> 8 & 0xFF);
            bytes[p_++] = (byte)(low & 0xFF);
            bytes[p_] = (byte)(low >>> 8 & 0xFF);
            return 4;
        }
        bytes[p_++] = (byte)(code2 & 0xFF);
        bytes[p_++] = (byte)((code2 & 0xFF00) >>> 8);
        return 2;
    }

    @Override
    public int mbcCaseFold(int flag2, byte[] bytes, IntHolder pp, int end2, byte[] fold2) {
        int p2 = pp.value;
        int foldP = 0;
        if (UTF16LEEncoding.isAscii(bytes[p2] & 0xFF) && bytes[p2 + 1] == 0) {
            fold2[foldP++] = AsciiTables.ToLowerCaseTable[bytes[p2] & 0xFF];
            fold2[foldP] = 0;
            pp.value += 2;
            return 2;
        }
        return super.mbcCaseFold(flag2, bytes, pp, end2, fold2);
    }

    @Override
    public int[] ctypeCodeRange(int ctype, IntHolder sbOut) {
        sbOut.value = 0;
        return super.ctypeCodeRange(ctype);
    }

    @Override
    public int leftAdjustCharHead(byte[] bytes, int p2, int s2, int end2) {
        if (s2 <= p2) {
            return s2;
        }
        if ((s2 - p2) % 2 == 1) {
            --s2;
        }
        if (UTF16LEEncoding.isSurrogateSecond(bytes[s2 + 1] & 0xFF) && s2 > p2 + 1) {
            s2 -= 2;
        }
        return s2;
    }

    @Override
    public boolean isReverseMatchAllowed(byte[] bytes, int p2, int end2) {
        return false;
    }

    private static boolean isSurrogateFirst(int c) {
        return (c & 0xFC) == 216;
    }

    private static boolean isSurrogateSecond(int c) {
        return (c & 0xFC) == 220;
    }

    private static boolean isSurrogate(int c) {
        return (c & 0xF8) == 216;
    }
}

